/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.SonarCore;
import sonar.core.api.blocks.IWrenchable;
import sonar.core.api.inventories.ISonarInventoryTile;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.common.block.properties.SonarProperties;
import sonar.core.helpers.NBTHelper;

public class SonarBlock
extends Block
implements IWrenchable {
    public AxisAlignedBB bounding_box = field_185505_j;
    public boolean orientation;
    public boolean wrenchable = true;
    public boolean hasSpecialRenderer = false;
    public static final String DROP_TAG_NAME = "sonar_drop";
    public static final String DROP_TAG_LEGACY = "dropped";

    public SonarBlock(Material material, boolean orientation) {
        this(material, material.func_151565_r(), orientation);
    }

    public SonarBlock(Material material, MapColor mapColor, boolean orientation) {
        super(material, mapColor);
        this.orientation = orientation;
    }

    public void setBlockBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.bounding_box = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bounding_box;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemstack) {
        super.func_180633_a(world, pos, state, player, itemstack);
        SonarBlock.readDropStack(itemstack, state, pos, (IBlockAccess)world);
        if (this.orientation) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)SonarProperties.FACING, (Comparable)player.func_174811_aO().func_176734_d()), 2);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (this.orientation) {
            SonarBlock.setDefaultFacing(world, pos, state);
        }
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        SonarBlock.dropInventoryContents(world, pos, state);
        int count = this.quantityDropped(state, 0, SonarCore.rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, SonarCore.rand, 0);
            if (item == Items.field_190931_a) continue;
            ItemStack stack = new ItemStack(item, 1, this.func_180651_a(state));
            SonarBlock.writeDropStack(stack, state, pos, (IBlockAccess)world);
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
        super.func_180663_b(world, pos, state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    @Override
    public boolean canWrench(EntityPlayer player, World world, BlockPos pos) {
        return this.wrenchable;
    }

    public int func_176201_c(IBlockState state) {
        return this.orientation ? ((EnumFacing)state.func_177229_b((IProperty)SonarProperties.FACING)).func_176745_a() : 0;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing facing;
        EnumFacing enumFacing = facing = this.orientation ? EnumFacing.func_82600_a((int)meta) : EnumFacing.NORTH;
        if (facing.func_176740_k().func_176720_b()) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)SonarProperties.FACING, (Comparable)facing);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SonarProperties.FACING});
    }

    public EnumFacing getRotation(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)SonarProperties.FACING);
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return !this.hasSpecialRenderer();
    }

    public boolean func_149721_r(IBlockState state) {
        return !this.hasSpecialRenderer();
    }

    public boolean func_149686_d(IBlockState state) {
        return !this.hasSpecialRenderer();
    }

    public static void dropInventoryContents(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISonarInventoryTile) {
            List<ItemStack> stacks = ((ISonarInventoryTile)tile).inv().getDrops();
            for (ItemStack itemstack : stacks) {
                if (itemstack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
            }
        }
    }

    public static void writeDropStack(ItemStack stack, IBlockState state, BlockPos pos, IBlockAccess world) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof INBTSyncable) {
            stack.func_190919_e(DROP_TAG_NAME);
            NBTTagCompound tag = stack.func_190925_c(DROP_TAG_NAME);
            ((INBTSyncable)entity).writeData(tag, NBTHelper.SyncType.DROP);
        }
    }

    public static void readDropStack(ItemStack stack, IBlockState state, BlockPos pos, IBlockAccess world) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof INBTSyncable && stack.func_77942_o()) {
            if (stack.func_77978_p().func_74767_n(DROP_TAG_LEGACY)) {
                ((INBTSyncable)entity).readData(stack.func_77978_p(), NBTHelper.SyncType.DROP);
            } else {
                NBTTagCompound tag = stack.func_179543_a(DROP_TAG_NAME);
                if (tag != null) {
                    ((INBTSyncable)entity).readData(tag, NBTHelper.SyncType.DROP);
                }
            }
        }
    }

    public static void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState block = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState block1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState block2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState block3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)SonarProperties.FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_185913_b() && !block1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_185913_b() && !block.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_185913_b() && !block3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_185913_b() && !block2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)SonarProperties.FACING, (Comparable)enumfacing), 2);
        }
    }
}

