/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.SonarHelper;
import sonar.core.utils.CustomColour;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AccessType;
import sonar.flux.api.AdditionType;
import sonar.flux.api.FluxError;
import sonar.flux.api.RemovalType;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.client.gui.GuiTab;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.ListenerHelper;
import sonar.flux.network.NetworkData;
import sonar.flux.network.PacketFluxButton;
import sonar.flux.network.PacketFluxError;
import sonar.flux.network.PacketType;

public class PacketHelper {
    public static void sendPacketToServer(PacketType type, TileFlux source, NBTTagCompound packetTag) {
        BlockCoords coords = source.getCoords();
        FluxNetworks.network.sendToServer((IMessage)new PacketFluxButton(type, coords.getBlockPos(), packetTag, coords.getDimension()));
    }

    public static void sendPacketToServer(PacketType type, BlockCoords coords, NBTTagCompound packetTag) {
        FluxNetworks.network.sendToServer((IMessage)new PacketFluxButton(type, coords.getBlockPos(), packetTag, coords.getDimension()));
    }

    public static NBTTagCompound createNetworkSetPacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        return tag;
    }

    public static IMessage doNetworkSetPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        if (source.getNetwork().getNetworkID() == networkID) {
            return null;
        }
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!network.isFakeNetwork()) {
            if (network.getPlayerAccess(player).canConnect()) {
                source.getNetwork().queueConnectionRemoval(source, RemovalType.REMOVE);
                network.queueConnectionAddition(source, AdditionType.ADD);
            } else {
                return new PacketFluxError(source.func_174877_v(), FluxError.ACCESS_DENIED);
            }
        }
        return null;
    }

    public static NBTTagCompound createNetworkEditPacket(int networkID, String networkName, CustomColour networkColour, AccessType accessType, boolean enableConvert, EnergyType defaultEnergy) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(NetworkData.NETWORK_ID, networkID);
        tag.func_74778_a(NetworkData.NETWORK_NAME, networkName);
        tag.func_74768_a(NetworkData.COLOUR, networkColour.getRGB());
        tag.func_74768_a(NetworkData.ACCESS, accessType.ordinal());
        tag.func_74757_a(NetworkData.CONVERSION, enableConvert);
        EnergyType.writeToNBT((EnergyType)defaultEnergy, (NBTTagCompound)tag, (String)NetworkData.ENERGY_TYPE);
        return tag;
    }

    public static IMessage doNetworkEditPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(NetworkData.NETWORK_ID);
        String newName = packetTag.func_74779_i(NetworkData.NETWORK_NAME);
        CustomColour colour = new CustomColour(packetTag.func_74762_e(NetworkData.COLOUR));
        AccessType access = AccessType.values()[packetTag.func_74762_e(NetworkData.ACCESS)];
        boolean enableConvert = packetTag.func_74767_n(NetworkData.CONVERSION);
        EnergyType energyType = EnergyType.readFromNBT((NBTTagCompound)packetTag, (String)NetworkData.ENERGY_TYPE);
        IFluxNetwork common = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!common.isFakeNetwork()) {
            if (common.getPlayerAccess(player).canEdit()) {
                common.setSetting(NetworkSettings.NETWORK_NAME, newName);
                common.setSetting(NetworkSettings.NETWORK_ACCESS, access);
                common.setSetting(NetworkSettings.NETWORK_COLOUR, colour);
                common.setSetting(NetworkSettings.NETWORK_CONVERSION, enableConvert);
                common.setSetting(NetworkSettings.NETWORK_ENERGY_TYPE, energyType);
            } else {
                return new PacketFluxError(source.func_174877_v(), FluxError.EDIT_NETWORK);
            }
        }
        return null;
    }

    public static NBTTagCompound createNetworkCreationPacket(String networkName, CustomColour networkColour, AccessType accessType, boolean enableConvert, EnergyType defaultEnergy) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a(NetworkData.NETWORK_NAME, networkName);
        tag.func_74768_a(NetworkData.COLOUR, networkColour.getRGB());
        tag.func_74768_a(NetworkData.ACCESS, accessType.ordinal());
        tag.func_74757_a(NetworkData.CONVERSION, enableConvert);
        EnergyType.writeToNBT((EnergyType)defaultEnergy, (NBTTagCompound)tag, (String)NetworkData.ENERGY_TYPE);
        return tag;
    }

    public static IMessage doNetworkCreationPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        String newName = packetTag.func_74779_i(NetworkData.NETWORK_NAME);
        CustomColour colour = new CustomColour(packetTag.func_74762_e(NetworkData.COLOUR));
        AccessType access = AccessType.values()[packetTag.func_74762_e(NetworkData.ACCESS)];
        boolean enableConvert = packetTag.func_74767_n(NetworkData.CONVERSION);
        EnergyType energyType = EnergyType.readFromNBT((NBTTagCompound)packetTag, (String)NetworkData.ENERGY_TYPE);
        if (FluxNetworks.getServerCache().hasSpaceForNetwork(player)) {
            FluxNetworks.getServerCache().createNetwork(player, newName, colour, access, enableConvert, energyType);
        }
        return null;
    }

    public static NBTTagCompound createNetworkDeletePacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        return tag;
    }

    public static IMessage doNetworkDeletePacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        IFluxNetwork toDelete = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!toDelete.isFakeNetwork()) {
            if (toDelete.getPlayerAccess(player).canDelete()) {
                FluxNetworks.getServerCache().onPlayerRemoveNetwork(toDelete);
            } else {
                return new PacketFluxError(source.func_174877_v(), FluxError.NOT_OWNER);
            }
        }
        return null;
    }

    public static NBTTagCompound createSetPriorityPacket(int priority) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("priority", priority);
        return tag;
    }

    public static IMessage doSetPriorityPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int priority = packetTag.func_74762_e("priority");
        if (!source.canAccess(player).canEdit()) {
            return new PacketFluxError(source.func_174877_v(), FluxError.ACCESS_DENIED);
        }
        source.priority.setValue((Object)priority);
        return null;
    }

    public static NBTTagCompound createSetTransferLimitPacket(int transferLimit) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("transferLimit", (long)transferLimit);
        return tag;
    }

    public static IMessage doSetTransferLimitPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        long priority = packetTag.func_74763_f("transferLimit");
        if (!source.canAccess(player).canEdit()) {
            return new PacketFluxError(source.func_174877_v(), FluxError.ACCESS_DENIED);
        }
        source.limit.setValue((Object)priority);
        return null;
    }

    public static NBTTagCompound createAddPlayerPacket(int networkID, String playerName, PlayerAccess playerAccess) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        tag.func_74778_a("playerName", playerName);
        tag.func_74768_a("playerAccess", playerAccess.ordinal());
        return tag;
    }

    public static IMessage doAddPlayerPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        String playerName = packetTag.func_74779_i("playerName");
        PlayerAccess access = PlayerAccess.values()[packetTag.func_74762_e("playerAccess")];
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!network.isFakeNetwork()) {
            if (network.getPlayerAccess(player).canEdit()) {
                network.addPlayerAccess(playerName, access);
            } else {
                return new PacketFluxError(source.func_174877_v(), FluxError.EDIT_NETWORK);
            }
        }
        return null;
    }

    public static NBTTagCompound createRemovePlayerPacket(int networkID, UUID playerRemoved, PlayerAccess playerAccess) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        tag.func_186854_a("playerRemoved", playerRemoved);
        tag.func_74768_a("playerAccess", playerAccess.ordinal());
        return tag;
    }

    public static IMessage doRemovePlayerPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        UUID playerRemoved = packetTag.func_186857_a("playerRemoved");
        PlayerAccess access = PlayerAccess.values()[packetTag.func_74762_e("playerAccess")];
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!network.isFakeNetwork()) {
            if (network.getPlayerAccess(player).canEdit()) {
                network.removePlayerAccess(playerRemoved, access);
            } else {
                return new PacketFluxError(source.func_174877_v(), FluxError.EDIT_NETWORK);
            }
        }
        return null;
    }

    public static NBTTagCompound createChangePlayerPacket(int networkID, UUID playerChanged, PlayerAccess playerAccess) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        tag.func_186854_a("playerChanged", playerChanged);
        tag.func_74768_a("playerAccess", playerAccess.ordinal());
        return tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMessage doChangePlayerPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        UUID playerChanged = packetTag.func_186857_a("playerChanged");
        if (playerChanged == null) return null;
        if (FluxPlayer.getOnlineUUID(player).equals(playerChanged)) {
            return null;
        }
        PlayerAccess access = PlayerAccess.values()[packetTag.func_74762_e("playerAccess")];
        access = (PlayerAccess)SonarHelper.incrementEnum((Enum)access, (Enum[])PlayerAccess.values());
        while (access.canDelete()) {
            access = (PlayerAccess)SonarHelper.incrementEnum((Enum)access, (Enum[])PlayerAccess.values());
        }
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (network.isFakeNetwork()) return null;
        if (!network.getPlayerAccess(player).canEdit()) return new PacketFluxError(source.func_174877_v(), FluxError.EDIT_NETWORK);
        Optional<FluxPlayer> settings = network.getValidFluxPlayer(playerChanged);
        if (!settings.isPresent()) return new PacketFluxError(source.func_174877_v(), FluxError.INVALID_USER);
        settings.get().setAccess(access);
        network.getSyncSetting(NetworkSettings.NETWORK_PLAYERS).setDirty(true);
        return null;
    }

    public static NBTTagCompound createDisconnectPacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        return tag;
    }

    public static IMessage doDisconnectPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        IFluxNetwork network;
        int networkID = packetTag.func_74762_e("networkID");
        if (networkID == (network = source.getNetwork()).getNetworkID() && network.getPlayerAccess(player).canConnect() && ((UUID)source.playerUUID.getValue()).equals(FluxPlayer.getOnlineUUID(player))) {
            network.queueConnectionRemoval(source, RemovalType.REMOVE);
        }
        return null;
    }

    public static NBTTagCompound createStateChangePacket(GuiTab oldTab, @Nullable GuiTab newTab) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("oldTab", oldTab.ordinal());
        if (newTab != null) {
            tag.func_74768_a("newTab", newTab.ordinal());
        }
        return tag;
    }

    public static IMessage doStateChangePacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        GuiTab oldTab = GuiTab.values()[packetTag.func_74762_e("oldTab")];
        ListenerHelper.onPlayerCloseTab(source, player, oldTab);
        if (packetTag.func_74764_b("newTab")) {
            GuiTab newTab = GuiTab.values()[packetTag.func_74762_e("newTab")];
            ListenerHelper.onPlayerOpenTab(source, player, newTab);
        }
        return null;
    }

    public static NBTTagCompound createResetConnectedBlocksPacket() {
        return new NBTTagCompound();
    }

    public static IMessage doResetConnectedBlocksPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        IFluxNetwork network = source.getNetwork();
        network.debugConnectedBlocks();
        return null;
    }

    public static NBTTagCompound createValidateConnectionsPacket() {
        return new NBTTagCompound();
    }

    public static IMessage doValidateConnectionsPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        IFluxNetwork network = source.getNetwork();
        network.debugValidateFluxConnections();
        return null;
    }
}

