/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxNetwork;

public class PacketFluxNetworkUpdate
implements IMessage {
    public NBTHelper.SyncType type;
    public boolean wipe;
    public Map<Integer, NBTTagCompound> network_updates = new HashMap<Integer, NBTTagCompound>();

    public PacketFluxNetworkUpdate() {
    }

    public PacketFluxNetworkUpdate(List<IFluxNetwork> toSend, NBTHelper.SyncType type, boolean wipe) {
        this.type = type;
        this.wipe = wipe;
        toSend.forEach(network -> {
            NBTTagCompound tag = new NBTTagCompound();
            network.writeData(tag, type);
            if (!tag.func_82582_d() && !network.isFakeNetwork()) {
                this.network_updates.put(network.getNetworkID(), tag);
            }
        });
    }

    public void fromBytes(ByteBuf buf) {
        this.wipe = buf.readBoolean();
        this.type = NBTHelper.SyncType.values()[buf.readInt()];
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.network_updates.put(buf.readInt(), ByteBufUtils.readTag((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.wipe);
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.network_updates.size());
        this.network_updates.forEach((I, NBT2) -> {
            buf.writeInt(I.intValue());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBT2);
        });
    }

    public static class Handler
    implements IMessageHandler<PacketFluxNetworkUpdate, IMessage> {
        public IMessage onMessage(PacketFluxNetworkUpdate message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    if (message.wipe) {
                        FluxNetworks.getClientCache().clearNetworks();
                    }
                    FluxNetworks.getClientCache().updateNetworksFromPacket(message.network_updates, message.type);
                });
            }
            return null;
        }
    }
}

