/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection.transfer;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.api.energy.ITileEnergyHandler;
import sonar.core.api.utils.ActionType;
import sonar.core.handlers.inventories.ItemStackHelper;
import sonar.flux.api.energy.internal.IEnergyTransfer;
import sonar.flux.api.energy.internal.ITransferHandler;
import sonar.flux.connection.transfer.BaseFluxTransfer;
import sonar.flux.connection.transfer.ISidedTransfer;

public class ConnectionTransfer
extends BaseFluxTransfer
implements IEnergyTransfer,
ISidedTransfer {
    public final ITransferHandler transferHandler;
    public final ITileEnergyHandler handler;
    public final TileEntity tile;
    public final EnumFacing direction;

    public ConnectionTransfer(ITransferHandler transferHandler, ITileEnergyHandler handler, TileEntity tile, EnumFacing direction) {
        super(handler.getEnergyType());
        this.transferHandler = transferHandler;
        this.handler = handler;
        this.tile = tile;
        this.direction = direction;
    }

    @Override
    public EnumFacing getDirection() {
        return this.direction;
    }

    @Override
    public TileEntity getTile() {
        return this.tile;
    }

    @Override
    public long addToNetwork(long maxTransferRF, ActionType actionType) {
        EnumFacing face = this.direction.func_176734_d();
        if (this.handler.canRemoveEnergy(this.tile, face)) {
            long remove = this.handler.removeEnergy(maxTransferRF, this.tile, face, actionType);
            if (!actionType.shouldSimulate()) {
                this.addedToNetwork(remove, this.getEnergyType());
            }
            return remove;
        }
        return 0L;
    }

    @Override
    public long removeFromNetwork(long maxTransferRF, ActionType actionType) {
        EnumFacing face = this.direction.func_176734_d();
        if (this.handler.canAddEnergy(this.tile, face)) {
            long added = this.handler.addEnergy(maxTransferRF, this.tile, face, actionType);
            if (!actionType.shouldSimulate()) {
                this.removedFromNetwork(added, this.getEnergyType());
            }
            return added;
        }
        return 0L;
    }

    @Override
    public boolean isInvalid() {
        return this.tile.func_145837_r();
    }

    @Override
    public ItemStack getDisplayStack() {
        return ItemStackHelper.getBlockItem((World)this.tile.func_145831_w(), (BlockPos)this.tile.func_174877_v());
    }
}

