/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection;

import java.util.Iterator;
import java.util.List;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.connection.PriorityGrouping;

public class TransferIterator<T extends IFlux> {
    private Iterator<PriorityGrouping<T>> groupIterator;
    private PriorityGrouping<T> current_group;
    private Iterator<T> fluxIterator;
    private T current_flux;
    private EnergyType energyType;
    private int transferType;
    public boolean completed = false;

    public void update(List<PriorityGrouping<T>> list, EnergyType type, int transferType) {
        this.groupIterator = list.iterator();
        this.current_group = null;
        this.fluxIterator = null;
        this.current_flux = null;
        this.energyType = type;
        this.transferType = transferType;
        this.completed = false;
        this.incrementGroup();
    }

    public boolean incrementGroup() {
        if (this.groupIterator.hasNext()) {
            this.current_group = this.groupIterator.next();
            this.fluxIterator = this.current_group.getEntries().iterator();
            return this.incrementFlux();
        }
        this.completed = true;
        return false;
    }

    public boolean incrementFlux() {
        if (this.fluxIterator.hasNext()) {
            this.current_flux = (IFlux)this.fluxIterator.next();
            return this.canTransfer() || this.incrementFlux();
        }
        return this.incrementGroup();
    }

    public boolean canTransfer() {
        if (!this.current_flux.isActive()) {
            return false;
        }
        switch (this.transferType) {
            case 0: {
                return this.current_flux.getTransferHandler().addToNetwork(this.current_flux.getTransferLimit(), this.energyType, ActionType.SIMULATE) > 0L;
            }
            case 1: {
                return this.current_flux.getTransferHandler().removeFromNetwork(this.current_flux.getTransferLimit(), this.energyType, ActionType.SIMULATE) > 0L;
            }
        }
        return false;
    }

    public boolean hasNext() {
        if (this.completed) {
            return false;
        }
        return this.canTransfer() || this.incrementFlux();
    }

    public PriorityGrouping<T> getCurrentGroup() {
        return this.current_group;
    }

    public T getCurrentFlux() {
        return this.current_flux;
    }
}

