/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.core.helpers.FunctionHelper;
import sonar.core.helpers.ListHelper;
import sonar.core.utils.CustomColour;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AccessType;
import sonar.flux.api.AdditionType;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.ConnectionSettings;
import sonar.flux.api.RemovalType;
import sonar.flux.api.network.FluxCache;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxListenable;
import sonar.flux.api.tiles.IFluxPlug;
import sonar.flux.api.tiles.IFluxPoint;
import sonar.flux.common.events.FluxConnectionEvent;
import sonar.flux.common.events.FluxNetworkEvent;
import sonar.flux.connection.FNEnergyTransferProxy;
import sonar.flux.connection.FluxListener;
import sonar.flux.connection.FluxNetworkBase;
import sonar.flux.connection.PriorityGrouping;
import sonar.flux.connection.TransferIterator;
import sonar.flux.connection.transfer.stats.NetworkStatistics;

public class FluxNetworkServer
extends FluxNetworkBase
implements IFluxNetwork {
    public HashMap<FluxCache, List<IFluxListenable>> connections = new HashMap();
    public Queue<IFluxListenable> toAdd = new ConcurrentLinkedQueue<IFluxListenable>();
    public Queue<IFluxListenable> toRemove = new ConcurrentLinkedQueue<IFluxListenable>();
    public List<IFluxListenable> flux_listeners = new ArrayList<IFluxListenable>();
    public boolean sortConnections = true;
    public long buffer_limiter = 0L;
    public long network_transfer_limit = Long.MAX_VALUE;
    public List<PriorityGrouping<IFluxPlug>> sorted_plugs = new ArrayList<PriorityGrouping<IFluxPlug>>();
    public List<PriorityGrouping<IFluxPoint>> sorted_points = new ArrayList<PriorityGrouping<IFluxPoint>>();
    private TransferIterator<IFluxPlug> PLUG_ITERATOR = new TransferIterator();
    private TransferIterator<IFluxPoint> POINT_ITERATOR = new TransferIterator();
    public Map<ConnectionSettings, List<IFlux>> dirtySettings = new HashMap<ConnectionSettings, List<IFlux>>();

    public FluxNetworkServer() {
    }

    public FluxNetworkServer(int ID, UUID playerUUID, String playerName, String networkName, CustomColour colour, AccessType type, boolean disableConvert, EnergyType defaultEnergy) {
        super(ID, playerUUID, playerName, networkName, colour, type, disableConvert, defaultEnergy);
    }

    public void addConnections() {
        if (this.toAdd.isEmpty()) {
            return;
        }
        Iterator iterator = this.toAdd.iterator();
        while (iterator.hasNext()) {
            IFluxListenable tile = (IFluxListenable)iterator.next();
            FluxCache.getValidTypes(tile).forEach(type -> ListHelper.addWithCheck(this.getConnections((FluxCache)type), (Object)tile));
            MinecraftForge.EVENT_BUS.post((Event)new FluxConnectionEvent.Connected(tile, this));
            iterator.remove();
        }
    }

    public void removeConnections() {
        if (this.toRemove.isEmpty()) {
            return;
        }
        Iterator iterator = this.toRemove.iterator();
        while (iterator.hasNext()) {
            IFluxListenable tile = (IFluxListenable)iterator.next();
            FluxCache.getValidTypes(tile).forEach(type -> this.getConnections((FluxCache)type).removeIf(F -> F.getCoords().equals((Object)tile.getCoords())));
            MinecraftForge.EVENT_BUS.post((Event)new FluxConnectionEvent.Disconnected(tile, this));
            iterator.remove();
        }
    }

    public <T extends IFluxListenable> List<T> getConnections(FluxCache<T> type) {
        return this.connections.computeIfAbsent(type, FunctionHelper.ARRAY);
    }

    @Override
    public void onStartServerTick() {
        this.addConnections();
        this.removeConnections();
        if (this.sortConnections) {
            this.sortConnections();
            this.sortConnections = false;
        }
        ((NetworkStatistics)this.network_stats.getValue()).onStartServerTick();
    }

    @Override
    public void onEndServerTick() {
        this.buffer_limiter = 0L;
        this.sorted_points.forEach(g -> g.getEntries().forEach(p -> this.buffer_limiter += p.getTransferHandler().removeFromNetwork(p.getTransferLimit(), (EnergyType)this.network_energy_type.getValue(), ActionType.SIMULATE)));
        if (!this.sorted_plugs.isEmpty() && !this.sorted_points.isEmpty()) {
            this.POINT_ITERATOR.update(this.sorted_points, (EnergyType)this.network_energy_type.getValue(), 1);
            while (this.POINT_ITERATOR.hasNext()) {
                IFluxPoint point = this.POINT_ITERATOR.getCurrentFlux();
                this.PLUG_ITERATOR.update(this.sorted_plugs, (EnergyType)this.network_energy_type.getValue(), 0);
                while (this.PLUG_ITERATOR.hasNext()) {
                    IFluxPlug plug = this.PLUG_ITERATOR.getCurrentFlux();
                    if (plug.getConnectionType() != point.getConnectionType()) {
                        long max_pull = plug.getTransferHandler().addToNetwork(plug.getTransferLimit(), (EnergyType)this.network_energy_type.getValue(), ActionType.SIMULATE);
                        long max_push = point.getTransferHandler().removeFromNetwork(max_pull, (EnergyType)this.network_energy_type.getValue(), ActionType.SIMULATE);
                        if (max_push > 0L) {
                            long pulled = plug.getTransferHandler().addToNetwork(max_push, (EnergyType)this.network_energy_type.getValue(), ActionType.PERFORM);
                            long l = point.getTransferHandler().removeFromNetwork(pulled, (EnergyType)this.network_energy_type.getValue(), ActionType.PERFORM);
                        }
                    }
                    this.PLUG_ITERATOR.incrementFlux();
                }
                this.POINT_ITERATOR.incrementFlux();
            }
        }
        ((NetworkStatistics)this.network_stats.getValue()).onEndWorldTick();
        if (!this.flux_listeners.isEmpty()) {
            this.sendPacketToListeners();
        }
        if (this.isDirty()) {
            MinecraftForge.EVENT_BUS.post((Event)new FluxNetworkEvent.SettingsChanged(this));
            this.watched_values.forEach(value -> value.setDirty(false));
            this.setDirty(false);
        }
        this.flushDirtySettings();
    }

    public void markSettingDirty(ConnectionSettings setting, IFlux flux) {
        this.dirtySettings.putIfAbsent(setting, new ArrayList());
        this.dirtySettings.get((Object)setting).add(flux);
    }

    public boolean isSettingDirty(ConnectionSettings setting) {
        return this.dirtySettings.containsKey((Object)setting);
    }

    public List<IFlux> getChangedConnections(ConnectionSettings setting) {
        return this.dirtySettings.get((Object)setting);
    }

    public void flushDirtySettings() {
        this.dirtySettings.clear();
    }

    public void sendPacketToListeners() {
        for (FluxListener type : FluxListener.values()) {
            type.sync(this);
        }
    }

    public void markDirty() {
        this.connectAll();
    }

    @Override
    public void removePlayerAccess(UUID uuid, PlayerAccess access) {
        ArrayList toDelete = new ArrayList();
        ((List)this.network_players.getValue()).stream().filter(p -> p.getOnlineUUID().equals(uuid) || p.getOfflineUUID().equals(uuid)).forEach(toDelete::add);
        ((List)this.network_players.getValue()).removeAll(toDelete);
    }

    @Override
    public Optional<FluxPlayer> getValidFluxPlayer(UUID uuid) {
        return ((List)this.network_players.getValue()).stream().filter(p -> p.getOnlineUUID().equals(uuid) || p.getOfflineUUID().equals(uuid)).findFirst();
    }

    @Override
    public boolean isFakeNetwork() {
        return false;
    }

    @Override
    public void addPlayerAccess(String username, PlayerAccess access) {
        FluxPlayer created = FluxPlayer.createFluxPlayer(username, access);
        for (FluxPlayer player : (List)this.network_players.getValue()) {
            if (!created.getOnlineUUID().equals(player.getOnlineUUID()) && !created.getOfflineUUID().equals(player.getOfflineUUID())) continue;
            player.setAccess(access);
            return;
        }
        ((List)this.network_players.getValue()).add(created);
    }

    @Override
    public void queueConnectionAddition(IFluxListenable tile, AdditionType type) {
        this.toAdd.add(tile);
        this.toRemove.remove(tile);
        this.removeFromUnloaded(tile);
    }

    @Override
    public void queueConnectionRemoval(IFluxListenable tile, RemovalType type) {
        this.toRemove.add(tile);
        this.toAdd.remove(tile);
        if (type == RemovalType.CHUNK_UNLOAD) {
            this.addToUnloaded(tile);
        } else {
            this.removeFromUnloaded(tile);
        }
    }

    private void addToUnloaded(IFluxListenable tile) {
        boolean contains = ((List)this.unloaded_connections.getValue()).stream().anyMatch(f -> f != null && f.getCoords().equals((Object)tile.getCoords()));
        if (!contains) {
            ClientFlux flux_unload = new ClientFlux(tile);
            flux_unload.setChunkLoaded(false);
            ((List)this.unloaded_connections.getValue()).add(flux_unload);
        }
    }

    private void removeFromUnloaded(IFluxListenable tile) {
        ((List)this.unloaded_connections.getValue()).removeIf(f -> f != null && f.getCoords().equals((Object)tile.getCoords()));
    }

    private void sortConnections() {
        this.sorted_plugs.clear();
        this.sorted_points.clear();
        List<IFluxPlug> plugs = this.getConnections(FluxCache.plug);
        List<IFluxPoint> points = this.getConnections(FluxCache.point);
        plugs.forEach(P -> PriorityGrouping.getOrCreateGrouping(P.getCurrentPriority(), this.sorted_plugs).getEntries().add(P));
        points.forEach(P -> PriorityGrouping.getOrCreateGrouping(P.getCurrentPriority(), this.sorted_points).getEntries().add(P));
        this.sorted_plugs.sort(Comparator.comparingInt(g -> -g.getPriority()));
        this.sorted_points.sort(Comparator.comparingInt(g -> -g.getPriority()));
    }

    @Override
    public void buildFluxConnections() {
        ArrayList clientConnections = new ArrayList();
        List<IFluxListenable> connections = this.getConnections(FluxCache.flux);
        connections.forEach(flux -> clientConnections.add(new ClientFlux((IFlux)flux)));
        clientConnections.addAll((Collection)this.unloaded_connections.getValue());
        this.client_connections.setValueInternal(clientConnections);
    }

    public void connectAll() {
        this.forEachConnection(FluxCache.flux, flux -> MinecraftForge.EVENT_BUS.post((Event)new FluxConnectionEvent.Connected((IFlux)flux, this)));
    }

    public void disconnectAll() {
        this.forEachConnection(FluxCache.flux, flux -> MinecraftForge.EVENT_BUS.post((Event)new FluxConnectionEvent.Disconnected((IFlux)flux, this)));
    }

    public void forEachConnection(FluxCache type, Consumer<? super IFluxListenable> action) {
        this.getConnections(type).forEach(action);
    }

    public void forEachViewer(FluxListener listener, Consumer<EntityPlayerMP> action) {
        this.forEachConnection(FluxCache.flux, f -> f.getListenerList().getListeners(new Enum[]{listener}).forEach(p -> action.accept(p.player)));
    }

    @Override
    public void onRemoved() {
        this.disconnectAll();
        this.connections.clear();
        this.toAdd.clear();
        this.toRemove.clear();
        this.sorted_plugs.clear();
        this.sorted_points.clear();
    }

    @Override
    public boolean canConvert(EnergyType from, EnergyType to) {
        return from == to || (Boolean)this.network_conversion.getValue() != false && FluxNetworks.TRANSFER_HANDLER.getProxy().canConvert(to, from) || FNEnergyTransferProxy.checkOverride(to, from);
    }

    @Override
    public boolean canTransfer(EnergyType type) {
        return type == this.network_energy_type.getValue() || this.canConvert(type, (EnergyType)this.network_energy_type.getValue());
    }

    @Override
    public void debugConnectedBlocks() {
        List<IFluxListenable> flux = this.getConnections(FluxCache.flux);
        flux.forEach(f -> f.getTransferHandler().updateTransfers(EnumFacing.field_82609_l));
    }

    @Override
    public void debugValidateFluxConnections() {
        ArrayList flux = Lists.newArrayList(this.getConnections(FluxCache.flux));
        flux.forEach(f -> this.queueConnectionRemoval((IFluxListenable)f, RemovalType.REMOVE));
        this.removeConnections();
        ArrayList<IFluxListenable> copy = new ArrayList<IFluxListenable>();
        for (IFluxListenable fl : flux) {
            boolean match = copy.removeIf(f -> f.getCoords() != null && f.getCoords().equals((Object)fl.getCoords()));
            if (!match) {
                copy.add(fl);
                continue;
            }
            TileEntity tile = fl.getCoords().getTileEntity();
            if (!(tile instanceof IFluxListenable)) continue;
            copy.add((IFluxListenable)tile);
        }
        copy.forEach(f -> this.queueConnectionAddition((IFluxListenable)f, AdditionType.ADD));
        this.addConnections();
        this.buildFluxConnections();
    }
}

