/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.common.tile.TileEntitySyncable;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketTileSync;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.tiles.IFluxListenable;
import sonar.flux.connection.FluxNetworkServer;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.PacketFluxNetworkUpdate;
import sonar.flux.network.PacketNetworkStatistics;

public enum FluxListener {
    ADMIN((network, flux, player) -> {}, (network, flux, player) -> {}, network -> {}),
    SYNC_INDEX(FluxListener::doIndexOpen, (network, flux, player) -> {}, FluxListener::doIndexSync),
    SYNC_NETWORK_LIST(FluxListener::doNetworkListOpen, FluxListener::doNetworkListClose, FluxListener::doNetworkListSync),
    SYNC_NETWORK_CONNECTIONS(FluxListener::doConnectionsListOpen, (network, flux, player) -> {}, FluxListener::doConnectionsListSync),
    SYNC_NETWORK_STATS(FluxListener::doNetworkStatsOpen, (network, flux, player) -> {}, FluxListener::doNetworkStatsSync),
    SYNC_PLAYERS(FluxListener::doPlayerListOpen, (network, flux, player) -> {}, FluxListener::doPlayerListSync);

    public IListenerAction openPacket;
    public IListenerAction closePacket;
    public IListenerSync syncPacket;

    private FluxListener(IListenerAction openPacket, IListenerAction closePacket, IListenerSync syncPacket) {
        this.openPacket = openPacket;
        this.closePacket = closePacket;
        this.syncPacket = syncPacket;
    }

    public void doOpenPacket(IFluxNetwork network, IFluxListenable flux, EntityPlayerMP player) {
        this.openPacket.sendPacket(network, flux, player);
    }

    public void doClosePacket(IFluxNetwork network, IFluxListenable flux, EntityPlayerMP player) {
        this.closePacket.sendPacket(network, flux, player);
    }

    public void sync(FluxNetworkServer network) {
        this.syncPacket.sync(network);
    }

    public static void doIndexOpen(IFluxNetwork network, IFluxListenable flux, EntityPlayerMP player) {
        if (flux instanceof TileEntitySyncable) {
            TileEntitySyncable tileEntitySyncable = (TileEntitySyncable)flux;
        }
    }

    public static void doIndexSync(FluxNetworkServer network) {
        network.flux_listeners.forEach(flux -> flux.getListenerList().getListeners(new Enum[]{SYNC_INDEX}).forEach(p -> {
            TileEntitySyncable tile;
            NBTTagCompound tag;
            if (flux instanceof TileEntitySyncable && !(tag = (tile = (TileEntitySyncable)flux).writeData(new NBTTagCompound(), NBTHelper.SyncType.SPECIAL)).func_82582_d()) {
                tile.getSyncListeners().forEach(l -> SonarCore.network.sendTo((IMessage)new PacketTileSync(tile.func_174877_v(), tag, NBTHelper.SyncType.SPECIAL), l.player));
            }
        }));
    }

    public static void doNetworkListOpen(IFluxNetwork network, IFluxListenable flux, EntityPlayerMP player) {
        List<IFluxNetwork> toSend = FluxNetworkCache.instance().getAllowedNetworks((EntityPlayer)player, false);
        if (!network.isFakeNetwork()) {
            ListHelper.addWithCheck(toSend, (Object)network);
        }
        FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkUpdate(toSend, NBTHelper.SyncType.SAVE, true), player);
    }

    public static void doNetworkListClose(IFluxNetwork network, IFluxListenable flux, EntityPlayerMP player) {
    }

    public static void doNetworkListSync(IFluxNetwork network) {
    }

    public static void doConnectionsListOpen(IFluxNetwork network, IFluxListenable flux, EntityPlayerMP player) {
        if (!network.isFakeNetwork()) {
            network.buildFluxConnections();
            FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SAVE, false), player);
            FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.PACKET, false), player);
        }
    }

    public static void doConnectionsListSync(FluxNetworkServer network) {
        if (network.client_connections.isDirty()) {
            network.flux_listeners.forEach(flux -> flux.getListenerList().getListeners(new Enum[]{SYNC_INDEX}).forEach(p -> FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SPECIAL, false), p.player)));
        }
    }

    public static void doNetworkStatsOpen(IFluxNetwork network, IFluxListenable flux, EntityPlayerMP player) {
        if (!network.isFakeNetwork()) {
            FluxNetworks.network.sendTo((IMessage)new PacketNetworkStatistics(network), player);
        }
    }

    public static void doNetworkStatsSync(FluxNetworkServer network) {
        network.flux_listeners.forEach(flux -> flux.getListenerList().getListeners(new Enum[]{SYNC_INDEX}).forEach(p -> FluxListener.doNetworkStatsOpen(network, flux, p.player)));
    }

    public static void doPlayerListOpen(IFluxNetwork network, IFluxListenable flux, EntityPlayerMP player) {
        if (!network.isFakeNetwork()) {
            FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SAVE, false), player);
            FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.PACKET, false), player);
        }
    }

    public static void doPlayerListSync(FluxNetworkServer network) {
        if (network.network_players.isDirty()) {
            network.flux_listeners.forEach(flux -> flux.getListenerList().getListeners(new Enum[]{SYNC_INDEX}).forEach(p -> FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SPECIAL, false), p.player)));
        }
    }

    public static interface IListenerSync {
        public void sync(FluxNetworkServer var1);
    }

    public static interface IListenerAction {
        public void sendPacket(IFluxNetwork var1, IFluxListenable var2, EntityPlayerMP var3);
    }
}

