/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui.tabs;

import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import sonar.core.api.energy.EnergyType;
import sonar.core.helpers.FontHelper;
import sonar.flux.FluxTranslate;
import sonar.flux.client.gui.GuiAbstractTab;
import sonar.flux.client.gui.GuiTab;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.connection.transfer.stats.NetworkStatistics;

public class GuiTabNetworkStatistics
extends GuiAbstractTab {
    public GuiTabNetworkStatistics(TileFlux tile, List tabs) {
        super(tile, tabs);
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (this.common.isFakeNetwork()) {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_STATISTICS.t(), FluxTranslate.GUI_TAB_NETWORK_SELECTION.t());
        } else {
            this.renderNetwork(NetworkSettings.NETWORK_NAME.getValue(this.common), NetworkSettings.NETWORK_ACCESS.getValue(this.common), NetworkSettings.NETWORK_COLOUR.getValue(this.common).getRGB(), true, 11, 8);
            NetworkStatistics stats = NetworkSettings.NETWORK_STATISTICS.getValue(this.common);
            int rgb = this.getNetworkColour();
            FontHelper.text((String)(TextFormatting.DARK_GRAY + FluxTranslate.PLUGS.t() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + stats.flux_plug_count), (int)12, (int)26, (int)rgb);
            FontHelper.text((String)(TextFormatting.DARK_GRAY + FluxTranslate.POINTS.t() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + stats.flux_point_count), (int)12, (int)38, (int)rgb);
            FontHelper.text((String)(TextFormatting.DARK_GRAY + FluxTranslate.STORAGE.t() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + stats.flux_storage_count), (int)12, (int)50, (int)rgb);
            FontHelper.text((String)(TextFormatting.DARK_GRAY + FluxTranslate.CONTROLLERS.t() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + stats.flux_controller_count), (int)12, (int)62, (int)rgb);
            FontHelper.text((String)(TextFormatting.DARK_GRAY + FluxTranslate.TOTAL_INPUT.t() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + FontHelper.formatOutput((EnergyType)NetworkSettings.NETWORK_ENERGY_TYPE.getValue(this.common), (long)stats.total_energy_added)), (int)12, (int)74, (int)rgb);
            FontHelper.text((String)(TextFormatting.DARK_GRAY + FluxTranslate.TOTAL_OUTPUT.t() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + FontHelper.formatOutput((EnergyType)NetworkSettings.NETWORK_ENERGY_TYPE.getValue(this.common), (long)stats.total_energy_removed)), (int)12, (int)86, (int)rgb);
            FontHelper.text((String)(TextFormatting.DARK_GRAY + FluxTranslate.TOTAL_STORAGE_CHANGE.t() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + FontHelper.formatOutput((EnergyType)NetworkSettings.NETWORK_ENERGY_TYPE.getValue(this.common), (long)stats.network_energy_change)), (int)12, (int)98, (int)rgb);
            FontHelper.text((String)(TextFormatting.DARK_GRAY + FluxTranslate.TOTAL_NETWORK_TRANSFER.t() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + FontHelper.formatOutput((EnergyType)NetworkSettings.NETWORK_ENERGY_TYPE.getValue(this.common), (long)(stats.total_energy_added - stats.total_energy_removed))), (int)12, (int)110, (int)rgb);
            FontHelper.text((String)FluxTranslate.NETWORK_BUFFER.t(), (int)14, (int)124, (int)rgb);
            this.renderEnergyBar(14, 134, stats.network_energy, stats.network_energy_capacity, rgb, rgb);
        }
    }

    @Override
    public GuiTab getCurrentTab() {
        return GuiTab.NETWORK_STATISTICS;
    }

    public ResourceLocation getBackground() {
        return blank_flux_gui;
    }
}

