/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui.buttons;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import sonar.flux.FluxTranslate;
import sonar.flux.api.EnumActivationType;
import sonar.flux.client.gui.GuiAbstractTab;
import sonar.flux.client.gui.buttons.SmallButton;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.connection.NetworkSettings;

public class RedstoneSignalButton
extends SmallButton {
    public Supplier<EnumActivationType> redstoneType;

    public RedstoneSignalButton(GuiAbstractTab gui, int id, int x, int y, Supplier<EnumActivationType> redstoneType, String name) {
        super(gui, id, x, y, 24, 24, name);
        this.redstoneType = redstoneType;
    }

    @Override
    public void func_146111_b(int x, int y) {
        boolean active = true;
        switch (this.redstoneType.get()) {
            case ACTIVATED: {
                active = true;
                break;
            }
            case DISACTIVATED: {
                active = false;
                break;
            }
            case POSITIVE_SIGNAL: {
                active = (Boolean)((TileFlux)this.gui.flux).redstone_power.getValue();
                break;
            }
            case NEGATIVE_SIGNAL: {
                active = (Boolean)((TileFlux)this.gui.flux).redstone_power.getValue() == false;
                break;
            }
            default: {
                active = true;
            }
        }
        this.gui.drawSonarCreativeTabHoveringText(Lists.newArrayList((Object[])new String[]{this.redstoneType.get().comment.t(), FluxTranslate.ACTIVATION_CURRENT_STATE.t() + ": " + FluxTranslate.translateActivation(active)}), x, y);
    }

    public void func_191745_a(Minecraft mc, int x, int y, float partialTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean bl = this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
        if (this.field_146125_m) {
            RedstoneSignalButton.func_73734_a((int)(this.field_146128_h - 1), (int)(this.field_146129_i - 1), (int)(this.field_146128_h + this.sizeX + 2), (int)(this.field_146129_i + this.sizeY + 2), (int)NetworkSettings.NETWORK_COLOUR.getValue(this.gui.common).getRGB());
            RedstoneSignalButton.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.sizeX + 1), (int)(this.field_146129_i + this.sizeY + 1), (int)Color.BLACK.getRGB());
        }
        EnumActivationType type = this.redstoneType.get();
        switch (type) {
            case ACTIVATED: {
                this.textureY = 12;
                break;
            }
            case DISACTIVATED: {
                this.textureY = 24;
                break;
            }
            case POSITIVE_SIGNAL: {
                this.textureY = 36;
                break;
            }
            case NEGATIVE_SIGNAL: {
                this.textureY = 48;
            }
        }
        mc.func_110434_K().func_110577_a(this.texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_146128_h, this.field_146129_i, this.textureX, this.textureY, this.sizeX + 1, this.sizeY + 1);
    }
}

