/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux.proxy;

import com.zeitheron.solarflux.SolarFlux;
import com.zeitheron.solarflux.block.tile.TileBaseSolar;
import com.zeitheron.solarflux.client.TESRSolarPanel;
import com.zeitheron.solarflux.init.SolarsSF;
import com.zeitheron.solarflux.net.NetworkSF;
import com.zeitheron.solarflux.proxy.ISFProxy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientProxy
implements ISFProxy {
    private List<Item> render = new ArrayList<Item>();
    boolean requested;

    @Override
    public void init() {
        this.render.forEach(this::registerRender);
        this.render.clear();
        this.render = null;
        ClientRegistry.bindTileEntitySpecialRenderer(TileBaseSolar.class, (TileEntitySpecialRenderer)new TESRSolarPanel());
    }

    @Override
    public void render(Item item) {
        this.render.add(item);
    }

    @Override
    public void updateWindow(int window, int key, int val) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            EntityPlayerSP pl = Minecraft.func_71410_x().field_71439_g;
            if (pl != null && pl.field_71070_bA != null && pl.field_71070_bA.field_75152_c == window) {
                pl.field_71070_bA.func_75137_b(key, val);
            }
        });
    }

    @SubscribeEvent
    public void guiInit(GuiScreenEvent.InitGuiEvent.Post e) {
        Calendar c;
        if (e.getGui() instanceof GuiMainMenu && (c = Calendar.getInstance()).get(2) == 10 && c.get(5) == 10) {
            GuiMainMenu gmm = (GuiMainMenu)e.getGui();
            gmm.field_73975_c = "Happy hatchday, Zeitheron!";
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent e) {
        boolean ign;
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        boolean bl = ign = Minecraft.func_71410_x().field_71439_g != null;
        if (!ign && this.requested) {
            this.requested = false;
            SolarFlux.LOG.info("Restoring client settings for solar panels...");
            SolarsSF.reloadConfigs();
            SolarFlux.LOG.info("Solar Configs Restored!");
        }
    }

    @SubscribeEvent
    public void render(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL && !this.requested) {
            this.requested = true;
            NetworkSF.INSTANCE.request();
        }
    }

    private void registerRender(Item item) {
        SolarFlux.LOG.info("Model definition for item " + item.getRegistryName());
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }
}

