/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux.init;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import com.zeitheron.solarflux.api.SolarFluxAPI;
import com.zeitheron.solarflux.api.SolarInfo;
import com.zeitheron.solarflux.block.BlockBaseSolar;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SolarsSF {
    public static final SolarInfo SOLAR_1 = new SolarInfo(1, 8, 25000).setRegistryName("solarflux", "1");
    public static final SolarInfo SOLAR_2 = new SolarInfo(8, 64, 125000).setRegistryName("solarflux", "2");
    public static final SolarInfo SOLAR_3 = new SolarInfo(32, 256, 425000).setRegistryName("solarflux", "3");
    public static final SolarInfo SOLAR_4 = new SolarInfo(128, 1024, 2000000).setRegistryName("solarflux", "4");
    public static final SolarInfo SOLAR_5 = new SolarInfo(512, 4096, 8000000).setRegistryName("solarflux", "5");
    public static final SolarInfo SOLAR_6 = new SolarInfo(2048, 16384, 32000000).setRegistryName("solarflux", "6");
    public static final SolarInfo SOLAR_7 = new SolarInfo(8192, 64000, 64000000).setRegistryName("solarflux", "7");
    public static final SolarInfo SOLAR_8 = new SolarInfo(32768, 256000, 128000000).setRegistryName("solarflux", "8");
    private static File cfgDir;

    public static void preInit(File file) {
        String apath = file.getAbsolutePath();
        cfgDir = new File(apath.substring(0, apath.lastIndexOf(46)));
        if (!cfgDir.isDirectory()) {
            cfgDir.mkdirs();
        }
        IForgeRegistry blocks = ForgeRegistries.BLOCKS;
        IForgeRegistry items = ForgeRegistries.ITEMS;
        IForgeRegistry<SolarInfo> solars = SolarFluxAPI.SOLAR_PANELS;
        Arrays.stream(SolarsSF.class.getDeclaredFields()).filter(f -> SolarInfo.class.isAssignableFrom(f.getType())).forEach(f -> {
            try {
                SolarInfo si = (SolarInfo)f.get(null);
                solars.register((IForgeRegistryEntry)si);
                BlockBaseSolar block = si.getBlock();
                blocks.register((IForgeRegistryEntry)block);
                ItemBlock model = new ItemBlock((Block)block);
                model.setRegistryName(block.getRegistryName());
                items.register((IForgeRegistryEntry)model);
                SolarFluxAPI.renderRenderer.accept((Item)model);
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
        });
    }

    public static void reloadConfigs() {
        IForgeRegistry<SolarInfo> infos = SolarFluxAPI.SOLAR_PANELS;
        for (SolarInfo si : infos.getValuesCollection()) {
            Throwable throwable;
            si.getBlock().func_149647_a(SolarFluxAPI.tab);
            ResourceLocation rn = si.getRegistryName();
            File f = new File(cfgDir, si.getCompatMod() != null ? si.getCompatMod() : rn.func_110624_b());
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            if (!(f = new File(f, rn.func_110623_a().replaceAll("/", "_") + ".json")).isFile()) {
                try {
                    throwable = null;
                    try (FileWriter j = new FileWriter(f);){
                        j.append('{');
                        String nln = System.lineSeparator() + "\t";
                        char s = '\"';
                        j.append(nln + s + "capacity" + s + ": " + si.maxCapacity + ",");
                        j.append(nln + s + "generation" + s + ": " + si.maxGeneration + ",");
                        j.append(nln + s + "transfer" + s + ": " + si.maxTransfer + ",");
                        j.append(nln + s + "connected_textures" + s + ": " + si.connectTextures + System.lineSeparator());
                        j.append('}');
                        j.flush();
                    }
                    catch (Throwable nln) {
                        throwable = nln;
                        throw nln;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                FileReader reader = new FileReader(f);
                throwable = null;
                try {
                    JsonStreamParser j = new JsonStreamParser((Reader)reader);
                    JsonObject cfg = (JsonObject)j.next();
                    si.maxCapacity = cfg.get("capacity").getAsInt();
                    si.maxGeneration = cfg.get("generation").getAsInt();
                    si.maxTransfer = cfg.get("transfer").getAsInt();
                    JsonElement connected_textures = cfg.get("connected_textures");
                    si.connectTextures = connected_textures == null || connected_textures.getAsBoolean();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

