/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux.block.tile;

import com.zeitheron.solarflux.api.SolarInfo;
import com.zeitheron.solarflux.api.SolarInstance;
import com.zeitheron.solarflux.block.BlockBaseSolar;
import com.zeitheron.solarflux.gui.ContainerBaseSolar;
import com.zeitheron.solarflux.utils.FByteHelper;
import com.zeitheron.solarflux.utils.IVariableHandler;
import com.zeitheron.solarflux.utils.InventoryDummy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileBaseSolar
extends TileEntity
implements ITickable,
IEnergyStorage,
IVariableHandler {
    protected int energy;
    public int currentGeneration;
    public float sunIntensity;
    public SolarInstance instance;
    public boolean renderConnectedTextures = true;
    public List<EntityPlayer> crafters = new ArrayList<EntityPlayer>();
    public final InventoryDummy items = new InventoryDummy(5);
    public final InvWrapper itemWrapper = new InvWrapper((IInventory)this.items);

    public TileBaseSolar(SolarInstance instance) {
        this.items.validSlots = (slot, stack) -> false;
        this.items.fields = this;
        this.items.openInv = this.crafters::add;
        this.items.closeInv = this.crafters::remove;
        this.instance = instance;
    }

    public TileBaseSolar() {
        this.items.validSlots = (slot, stack) -> false;
        this.items.fields = this;
        this.items.openInv = this.crafters::add;
        this.items.closeInv = this.crafters::remove;
    }

    public boolean isSameLevel(TileBaseSolar other) {
        if (other == null) {
            return false;
        }
        if (other.instance == null || this.instance == null) {
            return false;
        }
        return Objects.equals(other.instance.delegate, this.instance.delegate);
    }

    public void func_73660_a() {
        TileEntity tile;
        if (this.func_145838_q() instanceof BlockBaseSolar) {
            SolarInfo si = ((BlockBaseSolar)this.func_145838_q()).solarInfo;
            this.renderConnectedTextures = si.connectTextures;
            if (si.maxGeneration <= 0) {
                this.field_145850_b.func_175655_b(this.field_174879_c, true);
                return;
            }
            if (this.instance == null || !this.instance.isValid()) {
                this.instance = new SolarInstance();
                si.accept(this.instance);
                return;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int i = 0; i < this.crafters.size(); ++i) {
            try {
                EntityPlayer player = this.crafters.get(i);
                if (player.field_71070_bA instanceof ContainerBaseSolar) {
                    player.field_71070_bA.func_75142_b();
                    continue;
                }
                this.crafters.remove(i);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int gen = this.getGeneration();
        this.energy += gen;
        this.currentGeneration = gen;
        this.energy = MathHelper.func_76125_a((int)this.energy, (int)0, (int)this.instance.cap);
        for (EnumFacing hor : EnumFacing.field_176754_o) {
            tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(hor));
            if (tile == null || !(tile instanceof TileBaseSolar)) continue;
            this.autoBalanceEnergy((TileBaseSolar)tile);
        }
        for (EnumFacing hor : EnumFacing.field_82609_l) {
            IEnergyStorage storage;
            if (hor == EnumFacing.UP || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(hor))) == null || !tile.hasCapability(CapabilityEnergy.ENERGY, hor.func_176734_d()) || !(storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, hor.func_176734_d())).canReceive()) continue;
            this.energy -= storage.receiveEnergy(Math.min(this.energy, this.instance.transfer), false);
        }
    }

    public int getGeneration() {
        boolean effUpgrs = false;
        float EfficiencyUpgradeReturnsToScale = 0.9f;
        float effUpgrIncr = 0.15f;
        float eff = this.instance.computeSunIntensity(this);
        if (!this.field_145850_b.field_72995_K) {
            this.sunIntensity = eff;
        }
        double energyGeneration = (float)this.instance.gen * eff;
        return (int)Math.round(energyGeneration *= 1.0 + (double)effUpgrIncr * Math.pow((double)effUpgrs, EfficiencyUpgradeReturnsToScale));
    }

    public NBTTagCompound write(NBTTagCompound nbt) {
        nbt.func_179237_a(this.instance.serializeNBT());
        nbt.func_74782_a("Items", (NBTBase)this.items.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("Energy", this.energy);
        return nbt;
    }

    public void read(NBTTagCompound nbt) {
        this.instance = SolarInstance.deserialize(nbt);
        this.items.readFromNBT(nbt.func_74775_l("Items"));
        this.energy = nbt.func_74762_e("Energy");
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != EnumFacing.UP) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != EnumFacing.UP) {
            return (T)this;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemWrapper;
        }
        return (T)super.getCapability(capability, facing);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.write(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.read(pkt.func_148857_g());
    }

    public void sync() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 11);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.read(nbt);
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        return super.func_189515_b(this.write(nbt));
    }

    public int autoBalanceEnergy(TileBaseSolar solar) {
        int delta = this.getEnergyStored() - solar.getEnergyStored();
        if (delta < 0) {
            return solar.autoBalanceEnergy(this);
        }
        if (delta > 0 && solar.getEnergyStored() < solar.getMaxEnergyStored()) {
            return this.extractEnergy(solar.receiveEnergyInternal(delta / 2, false), false);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(this.instance.transfer, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int receiveEnergyInternal(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.energy, Math.min(this.instance.transfer, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int getEnergyStored() {
        return this.getVar(0);
    }

    public int getMaxEnergyStored() {
        return this.getVar(1);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public int getVar(int id) {
        switch (id) {
            case 0: {
                return this.energy;
            }
            case 1: {
                return this.instance.cap;
            }
            case 2: {
                return this.instance.gen;
            }
            case 3: {
                return this.instance.transfer;
            }
            case 4: {
                return this.currentGeneration;
            }
            case 5: {
                return FByteHelper.toInt(this.sunIntensity);
            }
        }
        return 0;
    }

    @Override
    public void setVar(int id, int value) {
        switch (id) {
            case 0: {
                this.energy = MathHelper.func_76125_a((int)value, (int)0, (int)this.instance.cap);
                break;
            }
            case 1: {
                this.instance.cap = value;
                break;
            }
            case 2: {
                this.instance.gen = value;
                break;
            }
            case 3: {
                this.instance.transfer = value;
                break;
            }
            case 4: {
                this.currentGeneration = value;
                break;
            }
            case 5: {
                this.sunIntensity = FByteHelper.toFloat(value);
            }
        }
    }

    @Override
    public int getVarCount() {
        return 6;
    }
}

