/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux;

import com.zeitheron.solarflux.api.SolarFluxAPI;
import com.zeitheron.solarflux.api.SolarInfo;
import com.zeitheron.solarflux.api.compat.ISolarFluxCompat;
import com.zeitheron.solarflux.api.compat.SFCompat;
import com.zeitheron.solarflux.block.BlockBaseSolar;
import com.zeitheron.solarflux.block.tile.TileBaseSolar;
import com.zeitheron.solarflux.commands.CommandSolarFlux;
import com.zeitheron.solarflux.gui.GuiHandlerSF;
import com.zeitheron.solarflux.init.ItemsSF;
import com.zeitheron.solarflux.init.RecipesSF;
import com.zeitheron.solarflux.init.SolarsSF;
import com.zeitheron.solarflux.net.NetworkSF;
import com.zeitheron.solarflux.proxy.ISFProxy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="solarflux", name="Solar Flux Reborn", version="4.12r", certificateFingerprint="4d7b29cd19124e986da685107d16ce4b49bc0a97", updateJSON="https://pastebin.com/raw/EJgJGHLv", dependencies="after:thaumcraft", acceptedMinecraftVersions="[1.12.2]")
public class SolarFlux {
    public static final Logger LOG = LogManager.getLogger((String)"solarflux");
    @SidedProxy(clientSide="com.zeitheron.solarflux.proxy.ClientProxy", serverSide="com.zeitheron.solarflux.proxy.ServerProxy")
    public static ISFProxy proxy;
    @Mod.Instance
    public static SolarFlux instance;
    public static final Set<ISolarFluxCompat> compats;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (FinalFieldHelper.setSFField(SolarFluxAPI.class, "renderRenderer", proxy::render)) {
            LOG.info("Applied render register to SolarFluxAPI.renderRenderer");
        } else {
            LOG.error("Failed to set SolarFluxAPI.renderRenderer to a valid consumer!");
        }
        if (FinalFieldHelper.setSFField(SolarFluxAPI.class, "registerItem", item -> {
            item.func_77655_b(item.getRegistryName().toString());
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
            SolarFluxAPI.renderRenderer.accept((Item)item);
            item.func_77637_a(SolarFluxAPI.tab);
        })) {
            LOG.info("Applied item register to SolarFluxAPI.registerItem");
        } else {
            LOG.error("Failed to set SolarFluxAPI.registerItem to a valid consumer!");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        for (ASMDataTable.ASMData data : e.getAsmData().getAll(SFCompat.class.getCanonicalName())) {
            try {
                Class<?> c = Class.forName(data.getClassName());
                SFCompat compat = c.getAnnotation(SFCompat.class);
                if (compat != null && !ISolarFluxCompat.class.isAssignableFrom(c)) {
                    LOG.error("Found class that expects a compat from SolarFlux, but it doesn't implement " + ISolarFluxCompat.class.getName() + "!");
                    continue;
                }
                if (Loader.isModLoaded((String)compat.modid())) {
                    ISolarFluxCompat icompat = (ISolarFluxCompat)ISolarFluxCompat.class.cast(c.newInstance());
                    compats.add(icompat);
                    MinecraftForge.EVENT_BUS.register((Object)icompat);
                    LOG.info("Added SolarFlux compat - " + c.getCanonicalName());
                    continue;
                }
                LOG.debug("Skipped SolarFlux compat - " + c.getCanonicalName() + " @" + compat.modid() + " not found!");
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
        }
        if (FinalFieldHelper.setSFField(SolarFluxAPI.class, "tab", new CreativeTabs("solarflux"){

            public ItemStack func_78016_d() {
                return new ItemStack(ItemsSF.PHOTOVOLTAIC_CELL_2);
            }

            public void func_78018_a(NonNullList<ItemStack> items) {
                NonNullList sub = NonNullList.func_191196_a();
                super.func_78018_a(sub);
                for (int i = 0; i < sub.size(); ++i) {
                    ItemBlock ib;
                    Item it = ((ItemStack)sub.get(i)).func_77973_b();
                    if (!(it instanceof ItemBlock) || !((ib = (ItemBlock)it).func_179223_d() instanceof BlockBaseSolar)) continue;
                    BlockBaseSolar bs = (BlockBaseSolar)ib.func_179223_d();
                    if (bs.solarInfo.maxGeneration > 0) continue;
                    sub.remove(i);
                    --i;
                }
                sub.sort((a, b) -> {
                    if (a.func_77973_b() instanceof ItemBlock && b.func_77973_b() instanceof ItemBlock) {
                        ItemBlock aib = (ItemBlock)a.func_77973_b();
                        ItemBlock bib = (ItemBlock)b.func_77973_b();
                        if (aib.func_179223_d() instanceof BlockBaseSolar && bib.func_179223_d() instanceof BlockBaseSolar) {
                            BlockBaseSolar abs = (BlockBaseSolar)aib.func_179223_d();
                            BlockBaseSolar bbs = (BlockBaseSolar)bib.func_179223_d();
                            return abs.solarInfo.maxGeneration - bbs.solarInfo.maxGeneration;
                        }
                    }
                    return a.func_77973_b().getRegistryName().toString().compareTo(b.func_77973_b().getRegistryName().toString());
                });
                items.addAll((Collection)sub);
            }
        })) {
            LOG.info("Applied new tab to SolarFluxAPI.tab!");
        } else {
            LOG.error("Failed to set SolarFluxAPI.tab to new creative tab!");
        }
        SolarsSF.preInit(e.getSuggestedConfigurationFile());
        ArrayList subs = new ArrayList();
        compats.forEach(i -> {
            ArrayList<SolarInfo> lo = new ArrayList<SolarInfo>();
            i.registerSolarInfos(lo);
            lo.forEach(si -> si.setCompatMod(i.getClass().getAnnotation(SFCompat.class).modid()));
            subs.addAll(lo);
        });
        subs.forEach(si -> {
            SolarFluxAPI.SOLAR_PANELS.register((IForgeRegistryEntry)si);
            BlockBaseSolar block = si.getBlock();
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
            ItemBlock model = new ItemBlock((Block)block);
            model.setRegistryName(block.getRegistryName());
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)model);
            SolarFluxAPI.renderRenderer.accept((Item)model);
        });
        subs.clear();
        ItemsSF.preInit();
        compats.forEach(ISolarFluxCompat::preInit);
        TileEntity.func_190560_a((String)"solarflux:base_solar", TileBaseSolar.class);
    }

    @SubscribeEvent
    public void createRegistries(RegistryEvent.NewRegistry e) {
        if (FinalFieldHelper.setSFField(SolarFluxAPI.class, "SOLAR_PANELS", new RegistryBuilder().setName(new ResourceLocation("solarflux", "panels")).setType(SolarInfo.class).create())) {
            LOG.info("Applied new registry to SolarFluxAPI.SOLAR_PANELS!");
        } else {
            LOG.error("Failed to set SolarFluxAPI.SOLAR_PANELS to new registry!");
        }
    }

    @SubscribeEvent
    public void registerRecipesEvent(RegistryEvent.Register<IRecipe> event) {
        RecipesSF.register((IForgeRegistry<IRecipe>)event.getRegistry());
        compats.forEach(s -> s.registerRecipes((IForgeRegistry<IRecipe>)event.getRegistry()));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        FinalFieldHelper.setSFField(NetworkSF.class, "INSTANCE", new NetworkSF());
        SolarsSF.reloadConfigs();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandlerSF());
        proxy.init();
        compats.forEach(ISolarFluxCompat::init);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        compats.forEach(ISolarFluxCompat::postInit);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandSolarFlux());
    }

    @Mod.EventHandler
    public void certificateViolation(FMLFingerprintViolationEvent e) {
        LOG.warn("*****************************");
        LOG.warn("WARNING: Somebody has been tampering with SolarFluxReborn jar!");
        LOG.warn("It is highly recommended that you redownload mod from https://minecraft.curseforge.com/projects/246974 !");
        LOG.warn("*****************************");
        try {
            Class<?> HammerCore = Class.forName("com.zeitheron.hammercore.HammerCore");
            Map invalidCertificates = (Map)HammerCore.getDeclaredField("invalidCertificates").get(null);
            invalidCertificates.put("blackholestorage", "https://minecraft.curseforge.com/projects/246974");
        }
        catch (Throwable err) {
            if (err instanceof ClassNotFoundException) {
                return;
            }
            if (err instanceof NoClassDefFoundError) {
                return;
            }
            err.printStackTrace();
        }
    }

    static {
        compats = new HashSet<ISolarFluxCompat>();
    }

    private static class FinalFieldHelper {
        private static Field modifiersField;
        private static Object reflectionFactory;
        private static Method newFieldAccessor;
        private static Method fieldAccessorSet;

        private FinalFieldHelper() {
        }

        static boolean setSFField(Class<?> cls, String var, Object val) {
            try {
                Field f = cls.getDeclaredField(var);
                if (Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers())) {
                    FinalFieldHelper.makeWritable(f);
                    FinalFieldHelper.setField(f, null, val);
                    return true;
                }
                return false;
            }
            catch (Throwable err) {
                err.printStackTrace();
                return false;
            }
        }

        static Field makeWritable(Field f) throws ReflectiveOperationException {
            f.setAccessible(true);
            if (modifiersField == null) {
                Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
                reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
                newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
                fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
                modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
            }
            modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            return f;
        }

        static void setField(Field field, @Nullable Object instance, Object thing) throws ReflectiveOperationException {
            Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, field, false);
            fieldAccessorSet.invoke(fieldAccessor, instance, thing);
        }
    }
}

