/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.inventory.IItemHandlerSize;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerBasic;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.ItemType;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryUtils {
    public static final int SLOT_ITER_LIMIT = 256;
    public static final ItemStackHandlerBasic NULL_INV = new ItemStackHandlerBasic(0);

    public static int calcRedstoneFromInventory(IItemHandler inv) {
        int slots = inv.getSlots();
        int items = 0;
        int capacity = 0;
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            capacity = inv instanceof IItemHandlerSize && !stack.func_190926_b() ? (capacity += ((IItemHandlerSize)inv).getItemStackLimit(slot, stack)) : (capacity += inv.getSlotLimit(slot));
            if (stack.func_190926_b()) continue;
            items += stack.func_190916_E();
        }
        if (capacity > 0) {
            int strength = 14 * items / capacity;
            if (items > 0) {
                ++strength;
            }
            return strength;
        }
        return 0;
    }

    public static void dropInventoryContentsInWorld(World world, BlockPos pos, IItemHandler inv) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            EntityUtils.dropItemStacksInWorld(world, pos, stack, -1, true);
        }
    }

    public static InvResult tryMoveAllItems(IItemHandler invSrc, IItemHandler invDst) {
        return InventoryUtils.tryMoveAllItemsWithinSlotRange(invSrc, invDst, new SlotRange(invSrc), new SlotRange(invDst));
    }

    public static InvResult tryMoveAllItemsWithinSlotRange(IItemHandler invSrc, IItemHandler invDst, SlotRange slotsSrc, SlotRange slotsDst) {
        boolean movedAll = true;
        boolean movedSome = false;
        int lastSlot = Math.min(slotsSrc.lastInc, invSrc.getSlots() - 1);
        block0: for (int slot = slotsSrc.first; slot <= lastSlot; ++slot) {
            ItemStack stack;
            int limit = 256;
            while (limit-- > 0 && !(stack = invSrc.extractItem(slot, 64, false)).func_190926_b()) {
                int origSize = stack.func_190916_E();
                if ((stack = InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange(invDst, stack, slotsDst)).func_190926_b() || stack.func_190916_E() != origSize) {
                    movedSome = true;
                }
                if (stack.func_190926_b()) continue;
                invSrc.insertItem(slot, stack, false);
                movedAll = false;
                continue block0;
            }
        }
        return movedAll ? InvResult.MOVED_ALL : (movedSome ? InvResult.MOVED_SOME : InvResult.MOVED_NOTHING);
    }

    public static InvResult tryMoveMatchingItems(IItemHandler invSrc, IItemHandler invDst) {
        return InventoryUtils.tryMoveMatchingItemsWithinSlotRange(invSrc, invDst, new SlotRange(invSrc), new SlotRange(invDst));
    }

    public static InvResult tryMoveMatchingItemsWithinSlotRange(IItemHandler invSrc, IItemHandler invDst, SlotRange slotsSrc, SlotRange slotsDst) {
        boolean movedAll = true;
        boolean movedSome = false;
        InvResult result = InvResult.MOVED_NOTHING;
        int lastSlot = Math.min(slotsSrc.lastInc, invSrc.getSlots() - 1);
        for (int slot = slotsSrc.first; slot <= lastSlot; ++slot) {
            ItemStack stack = invSrc.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            if (InventoryUtils.getSlotOfFirstMatchingItemStackWithinSlotRange(invDst, stack, slotsDst) != -1) {
                result = InventoryUtils.tryMoveAllItemsWithinSlotRange(invSrc, invDst, new SlotRange(slot, 1), slotsDst);
            }
            if (result != InvResult.MOVED_NOTHING) {
                movedSome = true;
                continue;
            }
            movedAll = false;
        }
        return movedAll ? InvResult.MOVED_ALL : (movedSome ? InvResult.MOVED_SOME : InvResult.MOVED_NOTHING);
    }

    public static InvResult fillStacksOfMatchingItems(IItemHandler invSrc, IItemHandler invDst) {
        return InventoryUtils.fillStacksOfMatchingItemsWithinSlotRange(invSrc, invDst, new SlotRange(invSrc), new SlotRange(invDst));
    }

    public static InvResult fillStacksOfMatchingItemsWithinSlotRange(IItemHandler invSrc, IItemHandler invDst, SlotRange slotsSrc, SlotRange slotsDst) {
        boolean movedAll = true;
        boolean movedSome = false;
        InvResult result = InvResult.MOVED_NOTHING;
        int lastSlot = Math.min(slotsSrc.lastInc, invSrc.getSlots() - 1);
        for (int slot = slotsSrc.first; slot <= lastSlot; ++slot) {
            ItemStack stack = invSrc.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            List<Integer> matchingSlots = InventoryUtils.getSlotNumbersOfMatchingStacksWithinSlotRange(invDst, stack, slotsDst);
            for (int dstSlot : matchingSlots) {
                result = InventoryUtils.tryMoveAllItemsWithinSlotRange(invSrc, invDst, new SlotRange(slot, 1), new SlotRange(dstSlot, 1));
                if (result != InvResult.MOVED_NOTHING) {
                    movedSome = true;
                    continue;
                }
                movedAll = false;
            }
        }
        return movedAll ? InvResult.MOVED_ALL : (movedSome ? InvResult.MOVED_SOME : InvResult.MOVED_NOTHING);
    }

    public static ItemStack tryInsertItemStackToInventory(IItemHandler inv, @Nonnull ItemStack stackIn) {
        return InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange(inv, stackIn, new SlotRange(inv));
    }

    public static ItemStack tryInsertItemStackToInventoryWithinSlotRange(IItemHandler inv, @Nonnull ItemStack stackIn, SlotRange slotRange) {
        int slot;
        int lastSlot = Math.min(slotRange.lastInc, inv.getSlots() - 1);
        for (slot = slotRange.first; slot <= lastSlot; ++slot) {
            if (inv.getStackInSlot(slot).func_190926_b() || !(stackIn = inv.insertItem(slot, stackIn, false)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        for (slot = slotRange.first; slot <= lastSlot; ++slot) {
            if (!(stackIn = inv.insertItem(slot, stackIn, false)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stackIn;
    }

    public static ItemStack tryInsertItemStackToExistingStacksInInventory(IItemHandler inv, @Nonnull ItemStack stackIn) {
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingStacks(inv, stackIn);
        for (int slot : slots) {
            stackIn = inv.insertItem(slot, stackIn, false);
            if (!stackIn.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stackIn;
    }

    public static boolean areItemStacksEqual(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return stack1.func_190926_b() == stack2.func_190926_b();
        }
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean areItemStacksOreDictMatch(@Nonnull ItemStack stackTarget, @Nonnull ItemStack stackReference) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stackReference)) {
            NonNullList oreStacks = OreDictionary.getOres((String)OreDictionary.getOreName((int)id), (boolean)false);
            for (ItemStack oreStack : oreStacks) {
                if (!OreDictionary.itemMatches((ItemStack)stackTarget, (ItemStack)oreStack, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getFirstEmptySlot(IItemHandler inv) {
        return InventoryUtils.getSlotOfFirstMatchingItemStack(inv, ItemStack.field_190927_a);
    }

    public static int getLastEmptySlot(IItemHandler inv) {
        return InventoryUtils.getSlotOfLastMatchingItemStack(inv, ItemStack.field_190927_a);
    }

    public static int getFirstNonEmptySlot(IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getItemsFromFirstNonEmptySlot(IItemHandler inv, int maxAmount, boolean simulate) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.extractItem(i, maxAmount, simulate);
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static int getSlotOfFirstMatchingItem(IItemHandler inv, Item item) {
        return InventoryUtils.getSlotOfFirstMatchingItem(inv, item, Short.MAX_VALUE);
    }

    public static int getSlotOfFirstMatchingItem(IItemHandler inv, Item item, int meta) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b() || stack.func_77973_b() != item || stack.func_77960_j() != meta && meta != Short.MAX_VALUE) continue;
            return slot;
        }
        return -1;
    }

    public static ItemStack getFirstMatchingItem(IItemHandler inv, Item item) {
        int slot = InventoryUtils.getSlotOfFirstMatchingItem(inv, item);
        return slot != -1 ? inv.getStackInSlot(slot) : ItemStack.field_190927_a;
    }

    public static ItemStack getFirstItemOfType(EntityPlayer player, Class<?> clazz) {
        IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        int numSlots = inv.getSlots();
        for (int slot = 0; slot < numSlots; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b() || !clazz.isAssignableFrom(stack.func_77973_b().getClass())) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getFirstItemOfType(EntityPlayer player, Item item) {
        IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        int numSlots = inv.getSlots();
        for (int slot = 0; slot < numSlots; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static int getSlotOfLastMatchingItem(IItemHandler inv, Item item) {
        return InventoryUtils.getSlotOfLastMatchingItem(inv, item, Short.MAX_VALUE);
    }

    public static int getSlotOfLastMatchingItem(IItemHandler inv, Item item, int meta) {
        for (int slot = inv.getSlots() - 1; slot >= 0; --slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b() || stack.func_77973_b() != item || stack.func_77960_j() != meta && meta != Short.MAX_VALUE) continue;
            return slot;
        }
        return -1;
    }

    public static int getSlotOfFirstMatchingItemStack(IItemHandler inv, @Nonnull ItemStack stackIn) {
        return InventoryUtils.getSlotOfFirstMatchingItemStackWithinSlotRange(inv, stackIn, new SlotRange(inv));
    }

    public static int getSlotOfFirstMatchingItemStackWithinSlotRange(IItemHandler inv, @Nonnull ItemStack stackIn, SlotRange slotRange) {
        int lastSlot = Math.min(inv.getSlots() - 1, slotRange.lastInc);
        for (int slot = slotRange.first; slot <= lastSlot; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (!InventoryUtils.areItemStacksEqual(stack, stackIn)) continue;
            return slot;
        }
        return -1;
    }

    public static int getSlotOfLastMatchingItemStack(IItemHandler inv, @Nonnull ItemStack stackIn) {
        return InventoryUtils.getSlotOfLastMatchingItemStackWithinSlotRange(inv, stackIn, new SlotRange(inv));
    }

    public static int getSlotOfLastMatchingItemStackWithinSlotRange(IItemHandler inv, @Nonnull ItemStack stackIn, SlotRange slotRange) {
        int lastSlot;
        for (int slot = lastSlot = Math.min(inv.getSlots() - 1, slotRange.lastInc); slot >= slotRange.first; --slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (!InventoryUtils.areItemStacksEqual(stack, stackIn)) continue;
            return slot;
        }
        return -1;
    }

    public static List<Integer> getSlotNumbersOfMatchingItems(IItemHandler inv, Item item) {
        return InventoryUtils.getSlotNumbersOfMatchingItems(inv, item, Short.MAX_VALUE);
    }

    public static List<Integer> getSlotNumbersOfMatchingItems(IItemHandler inv, Item item, int meta) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b() || stack.func_77973_b() != item || stack.func_77960_j() != meta && meta != Short.MAX_VALUE) continue;
            slots.add(slot);
        }
        return slots;
    }

    public static List<Integer> getSlotNumbersOfMatchingStacks(IItemHandler inv, @Nonnull ItemStack stackIn) {
        return InventoryUtils.getSlotNumbersOfMatchingStacksWithinSlotRange(inv, stackIn, new SlotRange(inv));
    }

    public static List<Integer> getSlotNumbersOfMatchingStacksWithinSlotRange(IItemHandler inv, @Nonnull ItemStack stackIn, SlotRange slotRange) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int lastSlot = Math.min(inv.getSlots() - 1, slotRange.lastInc);
        for (int slot = slotRange.first; slot <= lastSlot; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (!InventoryUtils.areItemStacksEqual(stack, stackIn)) continue;
            slots.add(slot);
        }
        return slots;
    }

    public static List<Integer> getSlotNumbersOfMatchingStacks(IItemHandler inv, @Nonnull ItemStack stackTemplate, boolean useOreDict) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b() || !InventoryUtils.areItemStacksEqual(stack, stackTemplate) && (!useOreDict || !InventoryUtils.areItemStacksOreDictMatch(stack, stackTemplate))) continue;
            slots.add(slot);
        }
        return slots;
    }

    public static ItemStack extractItems(IItemHandler inv, Item item, int amount) {
        int slot = InventoryUtils.getSlotOfFirstMatchingItem(inv, item);
        return slot >= 0 ? inv.extractItem(slot, amount, false) : ItemStack.field_190927_a;
    }

    public static ItemStack extractMatchingItems(IItemHandler inv, @Nonnull ItemStack templateStack, int amount, boolean simulate) {
        int slot = InventoryUtils.getSlotOfFirstMatchingItemStack(inv, templateStack);
        return slot >= 0 ? inv.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
    }

    public static ItemStack getItemStackByUUID(IItemHandler inv, UUID uuid, @Nullable String containerTagName) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b() || !uuid.equals(NBTUtils.getUUIDFromItemStack(stack, containerTagName, false))) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack extractItemsFromSlot(IItemHandler inv, int slot, int amount) {
        ItemStack stackTmp;
        ItemStack stackExtract = inv.extractItem(slot, amount, false);
        if (stackExtract.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stackExtract.func_77976_d() * 256 < amount && inv instanceof IItemHandlerModifiable) {
            amount -= stackExtract.func_190916_E();
            ItemStack stackSlot = inv.getStackInSlot(slot);
            if (!stackSlot.func_190926_b()) {
                if (stackSlot.func_190916_E() <= amount) {
                    stackExtract.func_190917_f(stackSlot.func_190916_E());
                    ((IItemHandlerModifiable)inv).setStackInSlot(slot, ItemStack.field_190927_a);
                } else {
                    stackExtract.func_190917_f(amount);
                    stackSlot = stackSlot.func_77946_l();
                    stackSlot.func_190918_g(amount);
                    ((IItemHandlerModifiable)inv).setStackInSlot(slot, stackSlot);
                }
            }
            return stackExtract;
        }
        for (int loops = 0; stackExtract.func_190916_E() < amount && loops < 256 && !(stackTmp = inv.extractItem(slot, amount - stackExtract.func_190916_E(), false)).func_190926_b(); ++loops) {
            stackExtract.func_190917_f(stackTmp.func_190916_E());
        }
        return stackExtract;
    }

    public static ItemStack collectItemsFromInventory(IItemHandler inv, @Nonnull ItemStack stackTemplate, int maxAmount, boolean reverse) {
        return InventoryUtils.collectItemsFromInventory(inv, stackTemplate, maxAmount, reverse, false);
    }

    public static ItemStack collectItemsFromInventory(IItemHandler inv, @Nonnull ItemStack stackTemplate, int maxAmount, boolean reverse, boolean useOreDict) {
        return InventoryUtils.collectItemsFromInventoryFromSlotRange(inv, stackTemplate, new SlotRange(inv), maxAmount, reverse, useOreDict);
    }

    public static ItemStack collectItemsFromInventoryFromSlotRange(IItemHandler inv, @Nonnull ItemStack stackTemplate, SlotRange range, int amount, boolean reverse, boolean useOreDict) {
        if (range.first >= inv.getSlots()) {
            return ItemStack.field_190927_a;
        }
        int inc = reverse ? -1 : 1;
        int lastSlot = Math.min(range.lastInc, inv.getSlots() - 1);
        int start = reverse ? lastSlot : range.first;
        ItemStack stack = stackTemplate.func_77946_l();
        stack.func_190920_e(0);
        for (int slot = start; slot >= range.first && slot <= lastSlot && stack.func_190916_E() < amount; slot += inc) {
            ItemStack stackTmp = inv.getStackInSlot(slot);
            if (stackTmp.func_190926_b()) continue;
            if (InventoryUtils.areItemStacksEqual(stackTmp, stackTemplate)) {
                stackTmp = InventoryUtils.extractItemsFromSlot(inv, slot, amount - stack.func_190916_E());
                if (stackTmp.func_190926_b()) continue;
                stack.func_190917_f(stackTmp.func_190916_E());
                continue;
            }
            if (!useOreDict || !InventoryUtils.areItemStacksOreDictMatch(stackTmp, stackTemplate)) continue;
            if (stack.func_190916_E() == 0) {
                stack = stackTmp.func_77946_l();
                stack.func_190920_e(0);
            }
            if ((stackTmp = InventoryUtils.extractItemsFromSlot(inv, slot, amount - stack.func_190916_E())).func_190926_b()) continue;
            stack.func_190917_f(stackTmp.func_190916_E());
        }
        return stack.func_190916_E() > 0 ? stack : ItemStack.field_190927_a;
    }

    public static ItemStack collectOneStackAndMoveOthers(IItemHandler invTarget, IItemHandler invStorage, @Nonnull ItemStack stackTemplate) {
        ItemStack stackTmp;
        int maxStackSize = stackTemplate.func_77976_d();
        ItemStack stack = InventoryUtils.collectItemsFromInventory(invTarget, stackTemplate, maxStackSize, true);
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingStacks(invTarget, stackTemplate);
        block0: for (int slot : slots) {
            ItemStack stackTmp2;
            int limit = 256;
            while (limit-- > 0 && !(stackTmp2 = invTarget.extractItem(slot, maxStackSize, false)).func_190926_b()) {
                if ((stackTmp2 = InventoryUtils.tryInsertItemStackToInventory(invStorage, stackTmp2)).func_190926_b()) continue;
                invTarget.insertItem(slot, stackTmp2, false);
                continue block0;
            }
        }
        if (!stack.func_190926_b() && stack.func_190916_E() < maxStackSize && !(stackTmp = InventoryUtils.collectItemsFromInventory(invStorage, stack, maxStackSize - stack.func_190916_E(), true)).func_190926_b()) {
            stack.func_190917_f(stackTmp.func_190916_E());
        }
        return stack;
    }

    public static void leaveOneFullStackOfEveryItem(IItemHandler invTarget, IItemHandler invStorage, boolean reverse) {
        int inc = reverse ? -1 : 1;
        int start = reverse ? invTarget.getSlots() - 1 : 0;
        int invSize = invTarget.getSlots();
        for (int slot = start; slot >= 0 && slot < invSize; slot += inc) {
            ItemStack stackTmp;
            ItemStack stack = invTarget.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            int maxSize = stack.func_77976_d();
            List<Integer> matchingSlots = InventoryUtils.getSlotNumbersOfMatchingStacks(invTarget, stack);
            if (matchingSlots.size() > 1) {
                for (int tmp : matchingSlots) {
                    if (tmp == slot) continue;
                    int limit = 256;
                    while (limit-- > 0 && !(stack = invTarget.extractItem(tmp, maxSize, false)).func_190926_b() && (stack = invTarget.insertItem(slot, stack, false)).func_190926_b()) {
                    }
                    limit = 256;
                    while (!stack.func_190926_b() && limit-- > 0) {
                        if (!(stack = InventoryUtils.tryInsertItemStackToInventory(invStorage, stack)).func_190926_b()) {
                            InventoryUtils.tryInsertItemStackToInventory(invTarget, stack);
                            return;
                        }
                        stack = invTarget.extractItem(tmp, maxSize, false);
                    }
                }
            }
            if ((stack = invTarget.getStackInSlot(slot)).func_190926_b()) continue;
            maxSize = stack.func_77976_d();
            if (stack.func_190916_E() >= maxSize || (stackTmp = InventoryUtils.collectItemsFromInventory(invStorage, stack, maxSize - stack.func_190916_E(), true)).func_190926_b() || (stackTmp = invTarget.insertItem(slot, stackTmp, false)).func_190926_b()) continue;
            InventoryUtils.tryInsertItemStackToInventory(invStorage, stackTmp);
        }
    }

    public static boolean matchingStackFoundInSlotRange(IItemHandler inv, SlotRange slotRange, @Nonnull ItemStack stackTemplate, boolean ignoreMeta, boolean ignoreNbt) {
        Item item = stackTemplate.func_77973_b();
        int meta = stackTemplate.func_77960_j();
        int lastSlot = Math.min(slotRange.lastInc, inv.getSlots() - 1);
        for (int slot = slotRange.first; slot <= lastSlot; ++slot) {
            ItemStack stackTmp = inv.getStackInSlot(slot);
            if (stackTmp.func_190926_b() || stackTmp.func_77973_b() != item || !ignoreMeta && meta != Short.MAX_VALUE && stackTmp.func_77960_j() != meta || !ignoreNbt && !ItemStack.func_77970_a((ItemStack)stackTemplate, (ItemStack)stackTmp)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchingStackFoundOnList(NonNullList<ItemStack> list, @Nonnull ItemStack stackTemplate, boolean ignoreMeta, boolean ignoreNbt) {
        Item item = stackTemplate.func_77973_b();
        int meta = stackTemplate.func_77960_j();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ItemStack stackTmp = (ItemStack)list.get(i);
            if (stackTmp.func_190926_b() || stackTmp.func_77973_b() != item || !ignoreMeta && meta != Short.MAX_VALUE && stackTmp.func_77960_j() != meta || !ignoreNbt && !ItemStack.func_77970_a((ItemStack)stackTemplate, (ItemStack)stackTmp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInventoryEmpty(IItemHandler inv) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            if (inv.getStackInSlot(slot).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static int getLargestExistingStackSize(IItemHandler inv) {
        int largestSize = -1;
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b() || stack.func_190916_E() <= largestSize) continue;
            largestSize = stack.func_190916_E();
        }
        return largestSize;
    }

    public static int getMinNonEmptyStackSize(IItemHandler inv) {
        int minSize = -1;
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b() || stack.func_190916_E() >= minSize && minSize >= 0) continue;
            minSize = stack.func_190916_E();
        }
        return minSize;
    }

    public static int getNumberOfMatchingItemsInInventory(IItemHandler inv, @Nonnull ItemStack stackTemplate, boolean useOreDict) {
        int found = 0;
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stackTmp = inv.getStackInSlot(slot);
            if (stackTmp.func_190926_b() || !InventoryUtils.areItemStacksEqual(stackTmp, stackTemplate) && (!useOreDict || !InventoryUtils.areItemStacksOreDictMatch(stackTmp, stackTemplate))) continue;
            found += stackTmp.func_190916_E();
        }
        return found;
    }

    public static boolean checkInventoryHasItems(IItemHandler inv, @Nonnull ItemStack stackTemplate, int amount, boolean useOreDict) {
        int found = 0;
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stackTmp = inv.getStackInSlot(slot);
            if (!stackTmp.func_190926_b() && (InventoryUtils.areItemStacksEqual(stackTmp, stackTemplate) || useOreDict && InventoryUtils.areItemStacksOreDictMatch(stackTmp, stackTemplate))) {
                found += stackTmp.func_190916_E();
            }
            if (found < amount) continue;
            return true;
        }
        return false;
    }

    public static boolean checkInventoryHasAllItems(IItemHandler invStorage, IItemHandler invTemplate, int amountPerStack, boolean useOreDict) {
        Integer amount;
        HashMap<ItemType, Integer> quantities = new HashMap<ItemType, Integer>();
        int invSize = invTemplate.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stackTmp = invTemplate.getStackInSlot(slot);
            if (stackTmp.func_190926_b()) continue;
            ItemType item = new ItemType(stackTmp);
            amount = (Integer)quantities.get(item);
            amount = amount != null ? amount + amountPerStack : amountPerStack;
            quantities.put(item, amount);
        }
        Set items = quantities.keySet();
        for (ItemType item : items) {
            amount = (Integer)quantities.get(item);
            if (amount == null || InventoryUtils.checkInventoryHasItems(invStorage, item.getStack(), amount, useOreDict)) continue;
            return false;
        }
        return true;
    }

    public static Map<ItemType, Integer> getSlotCountPerItem(IItemHandler inv) {
        HashMap<ItemType, Integer> slots = new HashMap<ItemType, Integer>();
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stackTmp = inv.getStackInSlot(slot);
            if (stackTmp.func_190926_b()) continue;
            ItemType item = new ItemType(stackTmp);
            Integer count = (Integer)slots.get(item);
            count = count != null ? count + 1 : 1;
            slots.put(item, (int)count);
        }
        return slots;
    }

    public static NonNullList<ItemStack> createInventorySnapshot(IItemHandler inv) {
        int invSize = inv.getSlots();
        NonNullList items = NonNullList.func_191197_a((int)invSize, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < invSize; ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            items.set(i, (Object)stack.func_77946_l());
        }
        return items;
    }

    public static NonNullList<ItemStack> createInventorySnapshotOfNonEmptySlots(IItemHandler inv) {
        int invSize = inv.getSlots();
        NonNullList items = NonNullList.func_191196_a();
        for (int i = 0; i < invSize; ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            items.add((Object)stack.func_77946_l());
        }
        return items;
    }

    public static void clearInventoryToMatchTemplate(IItemHandler invTarget, IItemHandler invStorage, NonNullList<ItemStack> template) {
        SlotRange rangeStorage = new SlotRange(invStorage);
        int slots = Math.min(invTarget.getSlots(), template.size());
        for (int i = 0; i < slots; ++i) {
            if (InventoryUtils.areItemStacksEqual((ItemStack)template.get(i), invTarget.getStackInSlot(i))) continue;
            InventoryUtils.tryMoveAllItemsWithinSlotRange(invTarget, invStorage, new SlotRange(i, 1), rangeStorage);
        }
    }

    public static boolean restockInventoryBasedOnTemplate(IItemHandler invTarget, IItemHandler invStorage, NonNullList<ItemStack> template, int amountPerStack, boolean emptySlotsOnly, boolean useOreDict) {
        int slots = Math.min(invTarget.getSlots(), template.size());
        int amount = 0;
        boolean allSuccess = true;
        for (int i = 0; i < slots; ++i) {
            ItemStack stackTemplate = (ItemStack)template.get(i);
            if (stackTemplate.func_190926_b()) continue;
            ItemStack stackExisting = invTarget.getStackInSlot(i);
            if (emptySlotsOnly && !stackExisting.func_190926_b()) continue;
            amount = Math.min(amountPerStack, stackTemplate.func_77976_d());
            if (!stackExisting.func_190926_b()) {
                if (!useOreDict && !InventoryUtils.areItemStacksEqual(stackExisting, stackTemplate) || useOreDict && !InventoryUtils.areItemStacksOreDictMatch(stackExisting, stackTemplate)) {
                    allSuccess = false;
                    continue;
                }
                amount = Math.max(amount - stackExisting.func_190916_E(), 0);
            }
            if (amount <= 0) {
                allSuccess = false;
                continue;
            }
            ItemStack stackNew = InventoryUtils.collectItemsFromInventory(invStorage, stackTemplate, amount, false, useOreDict);
            if (stackNew.func_190926_b()) {
                allSuccess = false;
                continue;
            }
            if (stackNew.func_190916_E() < amount) {
                allSuccess = false;
            }
            if (useOreDict && !stackExisting.func_190926_b() && !InventoryUtils.areItemStacksEqual(stackExisting, stackNew)) {
                int size = stackNew.func_190916_E();
                stackNew = stackExisting.func_77946_l();
                stackNew.func_190920_e(size);
            }
            if ((stackNew = invTarget.insertItem(i, stackNew, false)).func_190926_b()) continue;
            InventoryUtils.tryInsertItemStackToInventory(invStorage, stackNew);
        }
        return allSuccess;
    }

    public static void sortInventoryWithinRange(IItemHandlerModifiable inv, SlotRange range) {
        ArrayList<ItemTypeByName> blocks = new ArrayList<ItemTypeByName>();
        ArrayList<ItemTypeByName> items = new ArrayList<ItemTypeByName>();
        int lastSlot = Math.min(range.lastInc, inv.getSlots() - 1);
        for (int i = range.first; i <= lastSlot; ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemTypeByName type = new ItemTypeByName(stack);
            if (stack.func_77973_b() instanceof ItemBlock) {
                if (blocks.contains(type)) continue;
                blocks.add(type);
                continue;
            }
            if (items.contains(type)) continue;
            items.add(type);
        }
        Collections.sort(blocks);
        Collections.sort(items);
        int slots = InventoryUtils.sortInventoryWithinRangeByTypes(inv, blocks, range);
        InventoryUtils.sortInventoryWithinRangeByTypes(inv, items, new SlotRange(range.first + slots, range.lastExc - (range.first + slots)));
    }

    private static int sortInventoryWithinRangeByTypes(IItemHandlerModifiable inv, List<ItemTypeByName> types, SlotRange range) {
        int slot = range.first;
        int slots = 0;
        block0: for (ItemTypeByName type : types) {
            ItemStack stack = type.getStack();
            while (true) {
                int max;
                int n = max = inv instanceof IItemHandlerSize ? ((IItemHandlerSize)inv).getItemStackLimit(slot, stack) : inv.getSlotLimit(slot);
                if (slot >= range.lastInc) {
                    return slots;
                }
                SlotRange rangeTmp = new SlotRange(slot, range.lastExc - slot);
                if ((stack = InventoryUtils.collectItemsFromInventoryFromSlotRange((IItemHandler)inv, stack, rangeTmp, max, false, false)).func_190926_b()) continue block0;
                ItemStack stackTmp = inv.getStackInSlot(slot);
                if (!stackTmp.func_190926_b() && !(stackTmp = InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange((IItemHandler)inv, stackTmp, rangeTmp = new SlotRange(slot + 1, range.lastExc - (slot + 1)))).func_190926_b()) {
                    InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange((IItemHandler)inv, stackTmp, range);
                    InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange((IItemHandler)inv, stack, range);
                    return slots;
                }
                inv.setStackInSlot(slot, stack);
                ++slot;
                ++slots;
            }
        }
        return slots;
    }

    public static boolean tryToEmptySlot(IItemHandler inv, int slot, int maxIterations) {
        for (int i = 0; i < maxIterations && !inv.getStackInSlot(slot).func_190926_b(); ++i) {
            inv.extractItem(slot, 0x100000, false);
        }
        return inv.getStackInSlot(slot).func_190926_b();
    }

    public static enum InvResult {
        MOVED_NOTHING,
        MOVED_SOME,
        MOVED_ALL;

    }

    public static class ItemTypeByName
    extends ItemType
    implements Comparable<ItemTypeByName> {
        public ItemTypeByName(ItemStack stack) {
            super(stack);
        }

        @Override
        public int compareTo(ItemTypeByName other) {
            int meta2;
            String name2;
            if (other == null) {
                throw new NullPointerException();
            }
            String name1 = this.getStack().func_77973_b().getRegistryName().toString();
            int comp = name1.compareToIgnoreCase(name2 = other.getStack().func_77973_b().getRegistryName().toString());
            if (comp != 0) {
                return comp;
            }
            int meta1 = this.getStack().func_77960_j();
            if (meta1 != (meta2 = other.getStack().func_77960_j())) {
                return meta1 < meta2 ? -1 : 1;
            }
            return 0;
        }
    }
}

