/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiMemoryChest;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerLockable;
import fi.dy.masa.enderutilities.inventory.container.ContainerMemoryChest;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperContainer;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperSelective;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;

public class TileEntityMemoryChest
extends TileEntityEnderUtilitiesInventory {
    public static final int GUI_ACTION_TOGGLE_LOCKED = 1;
    private static final int[] INV_SIZES = new int[]{9, 27, 54};
    private ItemStackHandlerLockable itemHandlerLockable;
    private int chestTier;
    private int invSize;

    public TileEntityMemoryChest() {
        super("memory_chest");
        this.initStorage(0);
    }

    private void initStorage(int invSize) {
        this.itemHandlerLockable = new ItemStackHandlerLockable(0, invSize, 64, false, "Items", this);
        this.itemHandlerBase = this.itemHandlerLockable;
        this.itemHandlerExternal = new ItemHandlerWrapperMemoryChestExternal(this.itemHandlerLockable, this);
    }

    public ItemStackHandlerLockable getInventory() {
        return this.itemHandlerLockable;
    }

    @Override
    public IItemHandler getWrappedInventoryForContainer(EntityPlayer player) {
        return new ItemHandlerWrapperContainer(this.itemHandlerLockable, this.itemHandlerLockable);
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.setStorageTier(nbt.func_74771_c("ChestTier"));
        super.readFromNBTCustom(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("ChestTier", (byte)this.chestTier);
        super.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74774_a("tier", (byte)this.chestTier);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        this.setStorageTier(tag.func_74771_c("tier"));
        super.handleUpdateTag(tag);
    }

    public int getStorageTier() {
        return this.chestTier;
    }

    public void setStorageTier(int tier) {
        this.chestTier = MathHelper.func_76125_a((int)tier, (int)0, (int)2);
        this.invSize = INV_SIZES[this.chestTier];
        this.initStorage(this.invSize);
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 1) {
            if (this.ownerData == null) {
                this.ownerData = new OwnerData((Entity)player);
                this.ownerData.setIsPublic(false);
            } else if (player.field_71075_bZ.field_75098_d || this.ownerData.isOwner((Entity)player)) {
                this.setIsPublic(!this.isPublic());
            }
        }
    }

    @Override
    public ContainerMemoryChest getContainer(EntityPlayer player) {
        return new ContainerMemoryChest(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiMemoryChest(this.getContainer(player), this);
    }

    private class ItemHandlerWrapperMemoryChestExternal
    extends ItemHandlerWrapperSelective {
        private final TileEntityMemoryChest temc;

        public ItemHandlerWrapperMemoryChestExternal(IItemHandler baseHandler, TileEntityMemoryChest te) {
            super(baseHandler);
            this.temc = te;
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return this.temc.isPublic() ? super.getStackInSlot(slot) : ItemStack.field_190927_a;
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.temc.isPublic() ? super.insertItem(slot, stack, simulate) : stack;
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.temc.isPublic() ? super.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
        }
    }
}

