/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.base;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.creativetab.CreativeTab;
import fi.dy.masa.enderutilities.reference.ReferenceNames;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemEnderUtilities
extends Item {
    public static final String PRE_BLUE = TextFormatting.BLUE.toString();
    public static final String PRE_GREEN = TextFormatting.GREEN.toString();
    public static final String PRE_WHITE = TextFormatting.WHITE.toString();
    public static final String RST_GRAY = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
    public static final String RST_WHITE = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
    protected final String name;
    protected String commonTooltip = null;
    protected boolean enabled = true;

    public ItemEnderUtilities(String name) {
        this.name = name;
        this.func_77637_a(CreativeTab.ENDER_UTILITIES_TAB);
        this.func_77655_b(name);
        this.addItemOverrides();
    }

    public String getItemNameEnU() {
        return this.name;
    }

    public Item func_77655_b(String name) {
        return super.func_77655_b(ReferenceNames.getDotPrefixedName(name));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)newStack);
    }

    public String getBaseItemDisplayName(ItemStack stack) {
        if (stack.func_82837_s()) {
            String name = stack.func_77978_p().func_74775_l("display").func_74779_i("Name");
            return TextFormatting.ITALIC.toString() + name + TextFormatting.RESET.toString();
        }
        return super.func_77653_i(stack);
    }

    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean verbose) {
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag advanced) {
        ArrayList<String> tmpList = new ArrayList<String>();
        boolean verbose = EnderUtilities.proxy.isShiftKeyDown();
        if (stack.func_77978_p() == null) {
            this.addTooltips(stack, tmpList, verbose);
            if (!verbose && tmpList.size() > 2) {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.holdshiftfordescription", (Object[])new Object[0]));
            } else {
                list.addAll(tmpList);
            }
        }
        tmpList.clear();
        EntityPlayer player = EnderUtilities.proxy.getClientPlayer();
        this.addTooltipLines(stack, player, tmpList, true);
        if (!verbose && tmpList.size() > 2) {
            tmpList.clear();
            this.addTooltipLines(stack, player, tmpList, false);
            if (tmpList.size() > 0) {
                list.add(tmpList.get(0));
            }
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.holdshift", (Object[])new Object[0]));
        } else {
            list.addAll(tmpList);
        }
    }

    public static void addTranslatedTooltip(String key, List<String> list, boolean verbose, Object ... args) {
        String translated = I18n.func_135052_a((String)key, (Object[])args);
        if (!translated.equals(key)) {
            if (translated.contains("|lf")) {
                String[] lines;
                for (String line : lines = translated.split(Pattern.quote("|lf"))) {
                    list.add(line);
                }
            } else {
                list.add(translated);
            }
        }
    }

    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemEnderUtilities.addTranslatedTooltip(this.func_77667_c(stack) + ".tooltips", list, verbose, new Object[0]);
        if (this.commonTooltip != null) {
            ItemEnderUtilities.addTranslatedTooltip(this.commonTooltip, list, verbose, new Object[0]);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ItemEnderUtilities setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void getSubItemsCustom(CreativeTabs tab, NonNullList<ItemStack> items) {
        super.func_150895_a(tab, items);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            this.getSubItemsCustom(tab, items);
        }
    }

    public ResourceLocation[] getItemVariants() {
        return new ResourceLocation[]{ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this)};
    }

    public ModelResourceLocation getModelLocation(ItemStack stack) {
        return null;
    }

    protected void addItemOverrides() {
    }
}

