/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.event.PlayerItemPickupEvent;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerBasic;
import fi.dy.masa.enderutilities.inventory.container.ContainerHandyBag;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemModular;
import fi.dy.masa.enderutilities.inventory.wrapper.PlayerMainInvWrapperNoSync;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemInventoryModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderPart;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.registry.ModRegistry;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class ItemHandyBag
extends ItemInventoryModular {
    public static final int META_TIER_1 = 0;
    public static final int META_TIER_2 = 1;
    public static final int INV_SIZE_TIER_1 = 27;
    public static final int INV_SIZE_TIER_2 = 55;
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_MOVE_ITEMS = 1;
    public static final int GUI_ACTION_SORT_ITEMS = 2;
    public static final int GUI_ACTION_TOGGLE_BLOCK = 3;
    public static final int GUI_ACTION_TOGGLE_UPDATE = 4;
    public static final int GUI_ACTION_TOGGLE_MODES = 5;
    public static final int GUI_ACTION_TOGGLE_SHIFTCLICK = 6;
    public static final int GUI_ACTION_TOGGLE_SHIFTCLICK_DOUBLETAP = 7;
    public static final int GUI_ACTION_OPEN_BAUBLES = 100;

    public ItemHandyBag(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.commonTooltip = "item.enderutilities.handybag.tooltips";
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrent) {
        super.func_77663_a(stack, world, entity, slot, isCurrent);
        if (!world.field_72995_K) {
            if (entity instanceof EntityPlayer) {
                this.restockPlayerInventory(stack, world, (EntityPlayer)entity);
            }
            if (Configs.handyBagEnableItemUpdate) {
                this.updateItems(stack, world, entity, slot);
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.tryMoveItems(world, pos, side, player.func_184586_b(hand), player);
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
            player.field_71070_bA.func_75142_b();
            player.openGui((Object)EnderUtilities.instance, 1002, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "_" + stack.func_77960_j();
    }

    public String func_77653_i(ItemStack stack) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (!moduleStack.func_190926_b() && moduleStack.func_77978_p() != null) {
            String itemName = super.func_77653_i(stack);
            String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
            if (moduleStack.func_82837_s()) {
                String pre = TextFormatting.GREEN.toString() + TextFormatting.ITALIC.toString();
                if (itemName.length() >= 14) {
                    return EUStringUtils.getInitialsWithDots(itemName) + " " + pre + moduleStack.func_82833_r() + rst;
                }
                return itemName + " " + pre + moduleStack.func_82833_r() + rst;
            }
            return itemName;
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void addTooltipLines(ItemStack containerStack, EntityPlayer player, List<String> list, boolean verbose) {
        if (containerStack.func_77978_p() == null) {
            return;
        }
        String preGreen = TextFormatting.GREEN.toString();
        String preRed = TextFormatting.RED.toString();
        String preWhite = TextFormatting.WHITE.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String strPickupMode = I18n.func_135052_a((String)("enderutilities.tooltip.item.pickupmode" + (verbose ? "" : ".short")), (Object[])new Object[0]) + ": ";
        String strRestockMode = I18n.func_135052_a((String)("enderutilities.tooltip.item.restockmode" + (verbose ? "" : ".short")), (Object[])new Object[0]) + ": ";
        PickupMode pickupMode = PickupMode.fromStack(containerStack);
        if (pickupMode == PickupMode.NONE) {
            strPickupMode = strPickupMode + preRed;
        } else if (pickupMode == PickupMode.MATCHING) {
            strPickupMode = strPickupMode + TextFormatting.YELLOW.toString();
        } else if (pickupMode == PickupMode.ALL) {
            strPickupMode = strPickupMode + preGreen;
        }
        strPickupMode = strPickupMode + pickupMode.getDisplayName() + rst;
        RestockMode restockMode = RestockMode.fromStack(containerStack);
        strRestockMode = restockMode == RestockMode.DISABLED ? strRestockMode + preRed : (restockMode == RestockMode.ALL ? strRestockMode + preGreen : strRestockMode + TextFormatting.YELLOW.toString());
        strRestockMode = strRestockMode + restockMode.getDisplayName() + rst;
        if (verbose) {
            list.add(strPickupMode);
            list.add(strRestockMode);
        } else {
            list.add(strPickupMode + " / " + strRestockMode);
        }
        String str = ItemHandyBag.bagIsOpenable(containerStack) ? I18n.func_135052_a((String)"enderutilities.tooltip.item.enabled", (Object[])new Object[0]) + ": " + preGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) : I18n.func_135052_a((String)"enderutilities.tooltip.item.enabled", (Object[])new Object[0]) + ": " + preRed + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]);
        list.add(str);
        int installed = this.getInstalledModuleCount(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (installed > 0) {
            int slotNum = UtilItemModular.getStoredModuleSelection(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            String preBlue = TextFormatting.BLUE.toString();
            String preWhiteIta = preWhite + TextFormatting.ITALIC.toString();
            String strShort = I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedmemorycard.short", (Object[])new Object[0]);
            ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            int max = this.getMaxModules(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            if (!moduleStack.func_190926_b() && moduleStack.func_77973_b() == EnderUtilitiesItems.ENDER_PART) {
                String dName = moduleStack.func_82837_s() ? preWhiteIta + moduleStack.func_82833_r() + rst + " " : "";
                list.add(String.format("%s %s(%s%d%s / %s%d%s)", strShort, dName, preBlue, slotNum + 1, rst, preBlue, max, rst));
                ((ItemEnderPart)moduleStack.func_77973_b()).addTooltipLines(moduleStack, player, list, false);
                return;
            }
            String strNo = I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedmemorycard.notinstalled", (Object[])new Object[0]);
            list.add(String.format("%s %s (%s%d%s / %s%d%s)", strShort, strNo, preBlue, slotNum + 1, rst, preBlue, max, rst));
        } else {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.nomemorycards", (Object[])new Object[0]));
        }
    }

    private static InventoryItemModular getInventoryForBag(ItemStack bagStack, EntityPlayer player) {
        InventoryItemModular bagInv = null;
        bagInv = player.field_71070_bA instanceof ContainerHandyBag && ((ContainerHandyBag)player.field_71070_bA).inventoryItemModular.getModularItemStack() == bagStack ? ((ContainerHandyBag)player.field_71070_bA).inventoryItemModular : new InventoryItemModular(bagStack, player, true, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (!bagInv.isAccessibleBy((Entity)player)) {
            return null;
        }
        return bagInv;
    }

    private void updateItems(ItemStack bagStack, World world, Entity entity, int bagSlot) {
        ItemStack cardStack;
        int moduleSlot;
        EntityPlayer player;
        InventoryItemModular bagInv;
        if (entity instanceof EntityPlayer && (bagInv = ItemHandyBag.getInventoryForBag(bagStack, player = (EntityPlayer)entity)) != null && player.field_71071_by.func_70301_a(bagSlot) == bagStack && (moduleSlot = bagInv.getSelectedModuleIndex()) >= 0 && !(cardStack = bagInv.getModuleInventory().getStackInSlot(moduleSlot)).func_190926_b()) {
            int tmpSlot = InventoryUtils.getFirstEmptySlot((IItemHandler)new PlayerMainInvWrapperNoSync(player.field_71071_by));
            long[] masks = new long[]{0x1FFFFFFL, 2198889037824L, 36026597995708416L};
            long mask = NBTUtils.getLong(cardStack, "HandyBag", "UpdateMask");
            int numSections = bagStack.func_77960_j() == 1 ? 3 : 1;
            int invSize = bagInv.getSlots();
            if (tmpSlot == -1) {
                tmpSlot = bagSlot;
            }
            ItemStack stackInTmpSlot = player.field_71071_by.func_70301_a(tmpSlot);
            boolean isCurrentItem = tmpSlot == player.field_71071_by.field_70461_c;
            for (int section = 0; section < numSections; ++section) {
                if ((mask & masks[section]) == 0L) continue;
                SlotRange range = ItemHandyBag.getSlotRangeForSection(section);
                for (int slot = range.first; slot < range.lastExc && slot < invSize; ++slot) {
                    ItemStack stackTmp;
                    if ((mask & 1L << slot) == 0L || (stackTmp = bagInv.getStackInSlot(slot)).func_190926_b()) continue;
                    ItemStack stackOrig = stackTmp.func_77946_l();
                    player.field_71071_by.func_70299_a(tmpSlot, stackTmp);
                    try {
                        stackTmp.func_77945_a(world, entity, tmpSlot, isCurrentItem);
                    }
                    catch (Throwable t) {
                        EnderUtilities.logger.warn("Exception while updating items inside a Handy Bag!", t);
                    }
                    if (ItemStack.func_77989_b((ItemStack)stackTmp, (ItemStack)stackOrig)) continue;
                    bagInv.setStackInSlot(slot, stackTmp.func_190926_b() ? ItemStack.field_190927_a : stackTmp);
                }
            }
            player.field_71071_by.func_70299_a(tmpSlot, stackInTmpSlot);
        }
    }

    private void restockPlayerInventory(ItemStack stack, World world, EntityPlayer player) {
        InventoryItemModular bagInv;
        RestockMode mode = RestockMode.fromStack(stack);
        if (!world.field_72995_K && mode != RestockMode.DISABLED && (bagInv = ItemHandyBag.getInventoryForBag(stack, player)) != null) {
            IItemHandler wrappedBagInv = ItemHandyBag.getWrappedEnabledInv(stack, bagInv);
            IItemHandlerModifiable playerInv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (mode == RestockMode.HOTBAR) {
                playerInv = new CombinedInvWrapper(new IItemHandlerModifiable[]{new RangedWrapper(playerInv, 0, 9), new PlayerOffhandInvWrapper(player.field_71071_by)});
            }
            InventoryUtils.fillStacksOfMatchingItems(wrappedBagInv, (IItemHandler)playerInv);
            player.field_71070_bA.func_75142_b();
        }
    }

    private EnumActionResult tryMoveItems(World world, BlockPos pos, EnumFacing side, ItemStack stack, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return EnumActionResult.PASS;
        }
        IItemHandler inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        InventoryItemModular bagInv = ItemHandyBag.getInventoryForBag(stack, player);
        if (inv == null || bagInv == null) {
            return EnumActionResult.PASS;
        }
        IItemHandler wrappedBagInv = ItemHandyBag.getWrappedEnabledInv(stack, bagInv);
        RestockMode restockMode = RestockMode.fromStack(stack);
        if (restockMode == RestockMode.HOTBAR || restockMode == RestockMode.ALL) {
            if (!world.field_72995_K) {
                if (restockMode == RestockMode.HOTBAR) {
                    InventoryUtils.tryMoveMatchingItems(wrappedBagInv, inv);
                } else {
                    InventoryUtils.tryMoveAllItems(wrappedBagInv, inv);
                }
                player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.2f, 1.8f);
            }
            return EnumActionResult.SUCCESS;
        }
        PickupMode pickupMode = PickupMode.fromStack(stack);
        if (pickupMode == PickupMode.MATCHING || pickupMode == PickupMode.ALL) {
            if (!world.field_72995_K) {
                if (pickupMode == PickupMode.MATCHING) {
                    InventoryUtils.tryMoveMatchingItems(inv, wrappedBagInv);
                } else {
                    InventoryUtils.tryMoveAllItems(inv, wrappedBagInv);
                }
                player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.2f, 1.8f);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private static ItemStack handleItems(ItemStack itemsIn, ItemStack bagStack, EntityPlayer player) {
        PickupMode pickupMode = PickupMode.fromStack(bagStack);
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (pickupMode != PickupMode.NONE) {
            itemsIn = InventoryUtils.tryInsertItemStackToExistingStacksInInventory(playerInv, itemsIn);
        }
        if (itemsIn.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        InventoryItemModular bagInv = ItemHandyBag.getInventoryForBag(bagStack, player);
        if (bagInv != null) {
            IItemHandler wrappedBagInv = ItemHandyBag.getWrappedEnabledInv(bagStack, bagInv);
            if (pickupMode == PickupMode.ALL || pickupMode == PickupMode.MATCHING && InventoryUtils.getSlotOfFirstMatchingItemStack(wrappedBagInv, itemsIn) != -1) {
                itemsIn = InventoryUtils.tryInsertItemStackToInventory(wrappedBagInv, itemsIn);
            }
        }
        return itemsIn;
    }

    public static boolean onItemPickupEvent(PlayerItemPickupEvent event) {
        if (event.getEntityPlayer().func_130014_f_().field_72995_K) {
            return false;
        }
        boolean pickedUp = false;
        EntityPlayer player = event.getEntityPlayer();
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        List<Integer> bagSlots = InventoryUtils.getSlotNumbersOfMatchingItems(playerInv, EnderUtilitiesItems.HANDY_BAG);
        Iterator<ItemStack> iter = event.drops.iterator();
        while (iter.hasNext()) {
            ItemStack stack = iter.next();
            if (stack.func_190926_b()) {
                iter.remove();
                continue;
            }
            for (int slot : bagSlots) {
                ItemStack bagStack = playerInv.getStackInSlot(slot);
                if (bagStack.func_190926_b() || bagStack.func_77973_b() != EnderUtilitiesItems.HANDY_BAG || !ItemHandyBag.bagIsOpenable(bagStack)) continue;
                ItemStack stackOrig = stack;
                if ((stack = ItemHandyBag.handleItems(stack, bagStack, player)).func_190926_b()) {
                    iter.remove();
                    pickedUp = true;
                    continue;
                }
                if (stackOrig.func_190916_E() == stack.func_190916_E()) continue;
                stackOrig.func_190920_e(stack.func_190916_E());
                pickedUp = true;
            }
        }
        if (pickedUp) {
            player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.MASTER, 0.2f, ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (event.drops.isEmpty()) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    public static boolean onEntityItemPickupEvent(EntityItemPickupEvent event) {
        int origStackSize;
        EntityItem entityItem = event.getItem();
        ItemStack stack = entityItem.func_92059_d();
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_130014_f_().field_72995_K || entityItem.field_70128_L || stack.func_190926_b()) {
            return true;
        }
        ItemStack origStack = ItemStack.field_190927_a;
        int stackSizeLast = origStackSize = stack.func_190916_E();
        boolean ret = false;
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems(playerInv, EnderUtilitiesItems.HANDY_BAG);
        for (int slot : slots) {
            ItemStack bagStack = playerInv.getStackInSlot(slot);
            if (bagStack.func_190926_b() || bagStack.func_77973_b() != EnderUtilitiesItems.HANDY_BAG || !ItemHandyBag.bagIsOpenable(bagStack)) continue;
            if (origStack == ItemStack.field_190927_a) {
                origStack = stack.func_77946_l();
            }
            if ((stack = ItemHandyBag.handleItems(stack, bagStack, player)).func_190926_b() || stack.func_190916_E() != stackSizeLast) {
                if (stack.func_190926_b()) {
                    entityItem.func_70106_y();
                    event.setCanceled(true);
                    ret = true;
                    break;
                }
                ItemStack pickedUpStack = origStack.func_77946_l();
                pickedUpStack.func_190920_e(stackSizeLast - stack.func_190916_E());
                FMLCommonHandler.instance().firePlayerItemPickupEvent(player, entityItem, pickedUpStack);
                player.func_71001_a((Entity)entityItem, origStackSize);
            }
            stackSizeLast = stack.func_190916_E();
        }
        if (!entityItem.field_70128_L && stack.func_190916_E() != origStackSize) {
            entityItem.func_92058_a(stack);
        }
        if (!entityItem.func_174814_R() && (entityItem.field_70128_L || stack.func_190916_E() != origStackSize)) {
            player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.MASTER, 0.2f, ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        return ret;
    }

    private static boolean bagIsOpenable(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return true;
        }
        return !stack.func_77978_p().func_74775_l("HandyBag").func_74767_n("DisableOpen");
    }

    public static ItemStack getOpenableBag(EntityPlayer player) {
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems(playerInv, EnderUtilitiesItems.HANDY_BAG);
        for (int slot : slots) {
            ItemStack stack = playerInv.getStackInSlot(slot);
            if (!ItemHandyBag.bagIsOpenable(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getSizeInventory(ItemStack containerStack) {
        return containerStack.func_77960_j() == 1 ? 55 : 27;
    }

    public static void performGuiAction(EntityPlayer player, int action, int element) {
        if (player.field_71070_bA instanceof ContainerHandyBag) {
            ContainerHandyBag container = (ContainerHandyBag)player.field_71070_bA;
            InventoryItemModular inv = container.inventoryItemModular;
            ItemStack stack = inv.getModularItemStack();
            if (!stack.func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.HANDY_BAG) {
                int max = ((ItemHandyBag)stack.func_77973_b()).getMaxModules(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
                if (action == 0 && element >= 0 && element < max) {
                    UtilItemModular.setModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, element);
                    inv.readFromContainerItemStack();
                } else if (action == 1) {
                    IItemHandlerModifiable playerMainInv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                    PlayerOffhandInvWrapper offhandInv = new PlayerOffhandInvWrapper(player.field_71071_by);
                    CombinedInvWrapper playerInv = new CombinedInvWrapper(new IItemHandlerModifiable[]{playerMainInv, offhandInv});
                    IItemHandler wrappedBagInv = ItemHandyBag.getWrappedEnabledInv(stack, inv);
                    switch (element & Short.MAX_VALUE) {
                        case 0: {
                            if ((element & 0x8000) != 0) {
                                InventoryUtils.tryMoveAllItems((IItemHandler)playerInv, wrappedBagInv);
                                break;
                            }
                            InventoryUtils.tryMoveAllItemsWithinSlotRange((IItemHandler)playerInv, wrappedBagInv, new SlotRange(9, 27), new SlotRange(wrappedBagInv));
                            break;
                        }
                        case 1: {
                            if ((element & 0x8000) != 0) {
                                InventoryUtils.tryMoveMatchingItems((IItemHandler)playerInv, wrappedBagInv);
                                break;
                            }
                            InventoryUtils.tryMoveMatchingItemsWithinSlotRange((IItemHandler)playerInv, wrappedBagInv, new SlotRange(9, 27), new SlotRange(wrappedBagInv));
                            break;
                        }
                        case 2: {
                            InventoryUtils.leaveOneFullStackOfEveryItem((IItemHandler)playerInv, wrappedBagInv, true);
                            break;
                        }
                        case 3: {
                            InventoryUtils.fillStacksOfMatchingItems(wrappedBagInv, (IItemHandler)playerInv);
                            break;
                        }
                        case 4: {
                            InventoryUtils.tryMoveMatchingItems(wrappedBagInv, (IItemHandler)playerInv);
                            break;
                        }
                        case 5: {
                            InventoryUtils.tryMoveAllItems(wrappedBagInv, (IItemHandler)playerInv);
                        }
                    }
                } else if (action == 2 && element >= 0 && element <= 3) {
                    if (element == 3) {
                        IItemHandlerModifiable playerMainInv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                        InventoryUtils.sortInventoryWithinRange(playerMainInv, new SlotRange(9, 27));
                        return;
                    }
                    if (element > 0 && stack.func_77960_j() == 0) {
                        return;
                    }
                    InventoryUtils.sortInventoryWithinRange(inv, ItemHandyBag.getSlotRangeForSection(element));
                } else if (action == 3 && element >= 0 && element <= 2) {
                    ItemHandyBag.setSlotMask(inv, stack, element, "LockMask");
                } else if (action == 4 && element >= 0 && element <= 2) {
                    ItemHandyBag.setSlotMask(inv, stack, element, "UpdateMask");
                } else if (action == 5 && (element & 3) >= 0 && (element & 3) <= 2) {
                    switch (element & 3) {
                        case 0: {
                            NBTUtils.toggleBoolean(stack, "HandyBag", "DisableOpen");
                            break;
                        }
                        case 1: {
                            PickupMode.cycleMode(stack, (element & 0x8000) != 0);
                            break;
                        }
                        case 2: {
                            RestockMode.cycleMode(stack, (element & 0x8000) != 0);
                            break;
                        }
                    }
                } else if (action == 6) {
                    ShiftMode.cycleMode(stack, element != 0);
                } else if (action == 7) {
                    if (ShiftMode.fromStack(stack) == ShiftMode.DOUBLE_TAP) {
                        ShiftMode.toggleDoubleTapEffectiveMode(stack);
                    }
                } else if (action == 100 && ModRegistry.isModLoadedBaubles()) {
                    try {
                        ModContainer baublesContainer = (ModContainer)Loader.instance().getIndexedModList().get("baubles");
                        if (baublesContainer != null) {
                            Object baubles = baublesContainer.getMod();
                            BlockPos pos = player.func_180425_c();
                            player.openGui(baubles, 0, player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        }
                    }
                    catch (Exception e) {
                        EnderUtilities.logger.warn("Failed to open the Baubles GUI from Handy Bag", (Throwable)e);
                    }
                }
            }
        }
    }

    private static void setSlotMask(InventoryItemModular inv, ItemStack bagStack, int bagSection, String tagName) {
        ItemStack cardStack;
        int slot = inv.getSelectedModuleIndex();
        if (slot >= 0 && !(cardStack = inv.getModuleInventory().getStackInSlot(slot)).func_190926_b()) {
            long[] masks = new long[]{0x1FFFFFFL, 2198889037824L, 36026597995708416L};
            long mask = NBTUtils.getLong(cardStack, "HandyBag", tagName);
            NBTUtils.setLong(cardStack, "HandyBag", tagName, mask ^= masks[bagSection]);
            UtilItemModular.setSelectedModuleStackAbs(bagStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, cardStack);
        }
    }

    private static SlotRange getSlotRangeForSection(int section) {
        if (section == 0) {
            return new SlotRange(0, 27);
        }
        if (section == 1) {
            return new SlotRange(27, 14);
        }
        return new SlotRange(41, 14);
    }

    private static IItemHandler getWrappedEnabledInv(ItemStack stack, IItemHandlerModifiable baseInv) {
        if (stack.func_77960_j() != 1) {
            return baseInv;
        }
        long[] masks = new long[]{0x1FFFFFFL, 2198889037824L, 36026597995708416L};
        ItemStack cardStack = UtilItemModular.getSelectedModuleStackAbs(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (cardStack.func_190926_b()) {
            return InventoryUtils.NULL_INV;
        }
        long lockMask = NBTUtils.getLong(cardStack, "HandyBag", "LockMask");
        ItemStackHandlerBasic inv = null;
        for (int i = 0; i < 3; ++i) {
            if ((lockMask & masks[i]) != 0L) continue;
            SlotRange range = ItemHandyBag.getSlotRangeForSection(i);
            inv = inv == null ? new RangedWrapper(baseInv, range.first, range.lastExc) : new CombinedInvWrapper(new IItemHandlerModifiable[]{inv, new RangedWrapper(baseInv, range.first, range.lastExc)});
        }
        return inv != null ? inv : InventoryUtils.NULL_INV;
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 262144)) {
            UtilItemModular.changePrivacyModeOnSelectedModuleAbs(stack, player, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 65536)) {
            PickupMode.cycleMode(stack, HotKeys.EnumKey.keypressActionIsReversed(key));
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 0)) {
            RestockMode.cycleMode(stack, HotKeys.EnumKey.keypressActionIsReversed(key));
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 327680)) {
            NBTUtils.toggleBoolean(stack, "HandyBag", "DisableOpen");
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key));
            return true;
        }
        return false;
    }

    @Override
    public boolean useAbsoluteModuleIndexing(ItemStack stack) {
        return true;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return moduleType.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS) ? this.getMaxModules(containerStack) : 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        int tier;
        IModule imodule;
        if (moduleStack.func_77973_b() instanceof IModule && (imodule = (IModule)moduleStack.func_77973_b()).getModuleType(moduleStack).equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS) && (tier = imodule.getModuleTier(moduleStack)) >= 6 && tier <= 12) {
            return this.getMaxModules(containerStack);
        }
        return 0;
    }

    @Override
    public void getSubItemsCustom(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Item)this, 1, 0));
        list.add((Object)new ItemStack((Item)this, 1, 1));
    }

    @Override
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        ResourceLocation[] variants = new ResourceLocation[36];
        int i = 0;
        for (String strL : new String[]{"false", "true"}) {
            for (String strP : new String[]{"none", "matching", "all"}) {
                for (String strR : new String[]{"disabled", "all", "hotbar"}) {
                    for (String strT : new String[]{"0", "1"}) {
                        String variant = String.format("locked=%s,pickupmode=%s,restockmode=%s,tier=%s", strL, strP, strR, strT);
                        variants[i++] = new ModelResourceLocation(rl, variant);
                    }
                }
            }
        }
        return variants;
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        String variant = "locked=" + (ItemHandyBag.bagIsOpenable(stack) ? "false" : "true") + ",pickupmode=" + PickupMode.fromStack(stack).getVariantName() + ",restockmode=" + RestockMode.fromStack(stack).getName() + ",tier=" + MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)1);
        return new ModelResourceLocation("enderutilities:item_" + this.name, variant);
    }

    public static enum ShiftMode {
        TO_BAG("enderutilities.gui.label.handybag.shiftclick.tobag"),
        INV_HOTBAR("enderutilities.gui.label.handybag.shiftclick.invhotbar"),
        DOUBLE_TAP("enderutilities.gui.label.handybag.shiftclick.doubletapshift");

        private final String unlocName;

        private ShiftMode(String unlocName) {
            this.unlocName = unlocName;
        }

        public String getUnlocName() {
            return this.unlocName;
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)this.getUnlocName(), (Object[])new Object[0]);
        }

        public static ShiftMode fromId(int id) {
            return id >= 0 && id < ShiftMode.values().length ? ShiftMode.values()[id] : TO_BAG;
        }

        public static ShiftMode fromStack(ItemStack bagStack) {
            return ShiftMode.fromId(ShiftMode.getModeId(bagStack) & 3);
        }

        public static void cycleMode(ItemStack bagStack, boolean reverse) {
            int rawMode = ShiftMode.getModeId(bagStack);
            int id = (rawMode & 3) + (reverse ? -1 : 1);
            if (id < 0) {
                id = ShiftMode.values().length - 1;
            } else if (id >= ShiftMode.values().length) {
                id = 0;
            }
            rawMode = rawMode & 0x80 | id;
            ShiftMode.setModeId(bagStack, rawMode);
        }

        public static void toggleDoubleTapEffectiveMode(ItemStack bagStack) {
            byte rawMode = (byte)(ShiftMode.getModeId(bagStack) ^ 0x80);
            ShiftMode.setModeId(bagStack, rawMode);
        }

        public static ShiftMode getEffectiveMode(ItemStack bagStack) {
            int rawMode = ShiftMode.getModeId(bagStack);
            ShiftMode mode = ShiftMode.fromId(rawMode & 3);
            if (mode == DOUBLE_TAP) {
                return (rawMode & 0x80) != 0 ? INV_HOTBAR : TO_BAG;
            }
            return mode;
        }

        private static int getModeId(ItemStack bagStack) {
            return NBTUtils.getByte(bagStack, "HandyBag", "ShiftMode");
        }

        private static void setModeId(ItemStack bagStack, int id) {
            NBTUtils.setByte(bagStack, "HandyBag", "ShiftMode", (byte)id);
        }
    }

    public static enum RestockMode {
        DISABLED("disabled"),
        ALL("all"),
        HOTBAR("hotbar");

        private final String name;

        private RestockMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)("enderutilities.tooltip.item." + this.getName()), (Object[])new Object[0]);
        }

        public static RestockMode fromStack(ItemStack bagStack) {
            int id = RestockMode.getModeId(bagStack);
            return id >= 0 && id < RestockMode.values().length ? RestockMode.values()[id] : DISABLED;
        }

        public static void cycleMode(ItemStack bagStack, boolean reverse) {
            int id = RestockMode.getModeId(bagStack) + (reverse ? -1 : 1);
            if (id < 0) {
                id = RestockMode.values().length - 1;
            } else if (id >= RestockMode.values().length) {
                id = 0;
            }
            RestockMode.setModeId(bagStack, id);
        }

        private static int getModeId(ItemStack bagStack) {
            ItemStack cardStack = UtilItemModular.getSelectedModuleStackAbs(bagStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            if (!cardStack.func_190926_b()) {
                return NBTUtils.getByte(cardStack, "HandyBag", "RestockMode");
            }
            return DISABLED.ordinal();
        }

        private static void setModeId(ItemStack bagStack, int id) {
            ItemStack cardStack = UtilItemModular.getSelectedModuleStackAbs(bagStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            if (!cardStack.func_190926_b()) {
                NBTUtils.setByte(cardStack, "HandyBag", "RestockMode", (byte)id);
            }
        }
    }

    public static enum PickupMode {
        NONE(0, "enderutilities.tooltip.item.disabled", "none"),
        MATCHING(1, "enderutilities.tooltip.item.matching", "matching"),
        ALL(2, "enderutilities.tooltip.item.all", "all");

        private final String displayName;
        private final String variantName;

        private PickupMode(int id, String displayName, String variantName) {
            this.displayName = displayName;
            this.variantName = variantName;
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)this.displayName, (Object[])new Object[0]);
        }

        public String getVariantName() {
            return this.variantName;
        }

        public static PickupMode fromStack(ItemStack bagStack) {
            int id = PickupMode.getModeId(bagStack);
            return id >= 0 && id < PickupMode.values().length ? PickupMode.values()[id] : NONE;
        }

        public static void cycleMode(ItemStack bagStack, boolean reverse) {
            int id = PickupMode.getModeId(bagStack) + (reverse ? -1 : 1);
            if (id < 0) {
                id = PickupMode.values().length - 1;
            } else if (id >= PickupMode.values().length) {
                id = 0;
            }
            PickupMode.setModeId(bagStack, id);
        }

        private static int getModeId(ItemStack bagStack) {
            ItemStack cardStack = UtilItemModular.getSelectedModuleStackAbs(bagStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            if (!cardStack.func_190926_b()) {
                return NBTUtils.getByte(cardStack, "HandyBag", "PickupMode");
            }
            return NONE.ordinal();
        }

        private static void setModeId(ItemStack bagStack, int id) {
            ItemStack cardStack = UtilItemModular.getSelectedModuleStackAbs(bagStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            if (!cardStack.func_190926_b()) {
                NBTUtils.setByte(cardStack, "HandyBag", "PickupMode", (byte)id);
            }
        }
    }
}

