/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.IContainerItem;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerCustomSlotClick;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemModular;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerArmor;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerBaubles;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.inventory.slot.SlotModuleModularItem;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.registry.ModRegistry;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerInventorySwapper
extends ContainerCustomSlotClick
implements IContainerItem {
    private static BaublesInvProviderBase baublesProvider = new BaublesInvProviderBase();
    public final InventoryItemModular inventoryItemModular;
    private ItemStack modularStackLast = ItemStack.field_190927_a;
    private MergeSlotRange moduleSlots = new MergeSlotRange(0, 0);
    private MergeSlotRange playerBaublesSlots = new MergeSlotRange(0, 0);
    private MergeSlotRange swapperBaublesSlots = new MergeSlotRange(0, 0);
    private final boolean baublesLoaded;
    private final int xOffset;

    public ContainerInventorySwapper(EntityPlayer player, ItemStack containerStack) {
        super(player, new InventoryItemModular(containerStack, player, false, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS));
        this.inventoryItemModular = (InventoryItemModular)this.inventory;
        this.inventoryItemModular.setHostInventory((IItemHandler)this.playerInv);
        this.baublesLoaded = ModRegistry.isModLoadedBaubles();
        this.xOffset = this.baublesLoaded ? 20 : 0;
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(31 + this.xOffset, 167);
        this.addOffhandSlot(8 + this.xOffset, 129);
    }

    @Override
    protected void addPlayerInventorySlots(int posX, int posY) {
        super.addPlayerInventorySlots(posX, posY);
        posX = 8 + this.xOffset;
        posY = 57;
        this.playerArmorSlots = new MergeSlotRange(this.field_75151_b.size(), 4);
        for (int i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerArmor(this, (IItemHandler)this.playerInv, i, 39 - i, posX, posY + i * 18));
        }
        if (this.baublesLoaded) {
            this.playerBaublesSlots = new MergeSlotRange(this.field_75151_b.size(), 7);
            this.addMergeSlotRangePlayerToExt(this.field_75151_b.size(), 7);
            IItemHandler inv = baublesProvider.getBaublesInventory(this.player);
            posX = 8;
            for (int i = 0; i < 7; ++i) {
                this.func_75146_a((Slot)new SlotItemHandlerBaubles(this, inv, i, posX, posY + i * 18));
            }
        }
    }

    @Override
    protected void addCustomInventorySlots() {
        int i;
        int customInvStart = this.field_75151_b.size();
        int posX = 31 + this.xOffset;
        int posY = 57;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, i * 9 + j + 9, posX + j * 18, posY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, i, posX + i * 18, posY + 58));
        }
        this.addMergeSlotRangePlayerToExt(this.field_75151_b.size(), 4);
        posY = 37;
        for (i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerArmor(this, this.inventory, i, 39 - i, posX + i * 18, posY));
        }
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, 40, posX + 72, posY){

            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
        if (this.baublesLoaded) {
            posX = 218;
            posY = 57;
            this.swapperBaublesSlots = new MergeSlotRange(this.field_75151_b.size(), 7);
            for (i = 0; i < 7; ++i) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, 41 + i, posX, posY + i * 18));
            }
        }
        posX = 121 + this.xOffset;
        posY = 15;
        int moduleSlots = this.inventoryItemModular.getModuleInventory().getSlots();
        for (int i2 = 0; i2 < moduleSlots; ++i2) {
            this.func_75146_a((Slot)new SlotModuleModularItem(this.inventoryItemModular.getModuleInventory(), i2, posX + i2 * 18, posY, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, this));
        }
        this.addMergeSlotRangePlayerToExt(this.field_75151_b.size() - moduleSlots, moduleSlots);
        this.moduleSlots = new MergeSlotRange(this.field_75151_b.size() - moduleSlots, moduleSlots);
        this.customInventorySlots = new MergeSlotRange(customInvStart, this.field_75151_b.size() - customInvStart);
    }

    public MergeSlotRange getModuleSlots() {
        return this.moduleSlots;
    }

    public MergeSlotRange getPlayerBaublesSlots() {
        return this.playerBaublesSlots;
    }

    public MergeSlotRange getSwapperBaublesSlots() {
        return this.swapperBaublesSlots;
    }

    @Override
    public ItemStack getContainerItem() {
        return this.inventoryItemModular.getModularItemStack();
    }

    @Override
    public void func_75142_b() {
        ItemStack modularStack;
        if (!this.player.func_130014_f_().field_72995_K && (modularStack = this.inventoryItemModular.getModularItemStack()) != this.modularStackLast) {
            this.inventoryItemModular.readFromContainerItemStack();
            this.modularStackLast = modularStack;
        }
        super.func_75142_b();
    }

    @Override
    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        ItemStack stack = this.getContainerItem();
        if (clickType == ClickType.CLONE && dragType == 2 && !stack.func_190926_b() && (this.playerMainSlotsIncHotbar.contains(slotNum) || this.playerArmorSlots.contains(slotNum) || this.playerOffhandSlots.contains(slotNum) || this.playerBaublesSlots.contains(slotNum))) {
            int invSlotNum;
            int n = invSlotNum = this.func_75139_a(slotNum) != null ? this.func_75139_a(slotNum).getSlotIndex() : -1;
            if (this.playerBaublesSlots.contains(slotNum)) {
                invSlotNum += 41;
            }
            if (invSlotNum == -1) {
                return ItemStack.field_190927_a;
            }
            byte selected = NBTUtils.getByte(stack, "InventorySwpapper", "SelectedPreset");
            long mask = NBTUtils.getLong(stack, "InventorySwpapper", "Preset_" + selected);
            NBTUtils.setLong(stack, "InventorySwpapper", "Preset_" + selected, mask ^= 1L << invSlotNum);
            return ItemStack.field_190927_a;
        }
        stack = super.func_184996_a(slotNum, dragType, clickType, player);
        this.func_75142_b();
        return stack;
    }

    public static void setBaublesInvProvider(BaublesInvProviderBase baublesProviderIn) {
        baublesProvider = baublesProviderIn;
    }

    public static BaublesInvProviderBase getBaublesInvProvider() {
        return baublesProvider;
    }

    public static class BaublesInvProviderBase {
        public IItemHandler getBaublesInventory(EntityPlayer player) {
            return null;
        }
    }
}

