/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui.client.base;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.gui.client.base.ScrollBar;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonHoverText;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerLockable;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerCustomSlotClick;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiEnderUtilities
extends GuiContainer {
    protected static final int GUI_ACTION_SLOT_MIDDLE_CLICK = 1;
    protected final ContainerEnderUtilities container;
    protected final EntityPlayer player;
    protected final ResourceLocation guiTextureWidgets;
    protected ResourceLocation guiTexture;
    protected int backgroundU;
    protected int backgroundV;
    protected InfoArea infoArea;

    public GuiEnderUtilities(ContainerEnderUtilities container, int xSize, int ySize, String textureName) {
        super((Container)container);
        this.container = container;
        this.player = container.player;
        this.field_146999_f = xSize;
        this.field_147000_g = ySize;
        this.guiTexture = ReferenceTextures.getGuiTexture(textureName);
        this.guiTextureWidgets = ReferenceTextures.getGuiTexture("gui.widgets");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onMouseInputEventPre(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (event.getGui() instanceof GuiEnderUtilities) {
            try {
                event.getGui().func_146274_d();
                event.setCanceled(true);
            }
            catch (IOException e) {
                EnderUtilities.logger.warn("Exception while executing handleMouseInput() on {}", (Object)event.getGui().getClass().getName());
            }
        }
    }

    @SubscribeEvent
    public static void onPotionShiftEvent(GuiScreenEvent.PotionShiftEvent event) {
        if (event.getGui() instanceof GuiEnderUtilities) {
            event.setCanceled(true);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float gameTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, gameTicks);
        this.drawTooltips(mouseX, mouseY);
    }

    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, this.backgroundU, this.backgroundV, this.field_146999_f, this.field_147000_g);
        if (this.infoArea != null) {
            this.infoArea.render(this, this.guiTextureWidgets);
        }
        this.bindTexture(this.guiTexture);
    }

    protected void drawTooltips(int mouseX, int mouseY) {
        int selectedSlot;
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            if (!(button instanceof GuiButtonHoverText) || !button.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
            this.drawHoveringText(((GuiButtonHoverText)button).getHoverStrings(), mouseX, mouseY, this.field_146289_q);
        }
        if (this.container instanceof ContainerCustomSlotClick && (selectedSlot = ((ContainerCustomSlotClick)this.container).getSelectedSlot()) != -1) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindTexture(this.guiTextureWidgets);
            Slot slot = this.container.func_75139_a(selectedSlot);
            this.func_73729_b(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 102, 90, 18, 18);
        }
        if (this.infoArea != null && this.infoArea.isMouseOver(mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            this.drawHoveringText(this.infoArea.getInfoLines(), mouseX, mouseY, this.field_146289_q);
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int l = 0; l < this.field_146292_n.size(); ++l) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
            if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
            if (mouseButton != 0) {
                guibutton.func_146113_a(this.field_146297_k.func_147118_V());
            }
            this.actionPerformedWithButton(guibutton, mouseButton);
        }
    }

    public void func_146274_d() throws IOException {
        int dWheel = Mouse.getEventDWheel();
        if (dWheel != 0) {
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            for (int i = 0; i < this.field_146292_n.size(); ++i) {
                GuiButton button = (GuiButton)this.field_146292_n.get(i);
                if (!button.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                this.actionPerformedWithButton(button, 10 + dWheel / 120);
                break;
            }
        } else {
            super.func_146274_d();
        }
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (type == ClickType.CLONE && (GuiEnderUtilities.func_146272_n() || GuiEnderUtilities.func_146271_m() || GuiEnderUtilities.func_175283_s())) {
            if (slotIn != null) {
                slotId = slotIn.field_75222_d;
            }
            int action = 0x2000 | HotKeys.getActiveModifierMask();
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, BlockPos.field_177992_a, 1, action, slotId));
        } else {
            super.func_184098_a(slotIn, slotId, mouseButton, type);
        }
    }

    protected void actionPerformedWithButton(GuiButton guiButton, int mouseButton) throws IOException {
    }

    public void scrollbarAction(int scrollbarId, ScrollBar.ScrollbarAction action, int position) {
    }

    protected void bindTexture(ResourceLocation rl) {
        this.field_146297_k.func_110434_K().func_110577_a(rl);
    }

    protected void drawLockedSlotBackgrounds(ItemStackHandlerLockable inv) {
        this.bindTexture(this.guiTextureWidgets);
        int invSize = inv.getSlots();
        for (int slotNum = 0; slotNum < invSize; ++slotNum) {
            Slot slot = this.field_147002_h.func_75139_a(slotNum);
            if (!inv.isSlotLocked(slotNum)) continue;
            int x = this.field_147003_i + slot.field_75223_e;
            int y = this.field_147009_r + slot.field_75221_f;
            int v = 18;
            ItemStack stackSlot = inv.getStackInSlot(slotNum);
            if (stackSlot.func_190926_b()) {
                v = 36;
            } else if (!InventoryUtils.areItemStacksEqual(stackSlot, inv.getTemplateStackInSlot(slotNum))) {
                v = 72;
            }
            this.func_73729_b(x - 1, y - 1, 102, v, 18, 18);
        }
    }

    protected void drawTemplateStacks(ItemStackHandlerLockable inv) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        int invSize = inv.getSlots();
        for (int slotNum = 0; slotNum < invSize; ++slotNum) {
            ItemStack stack;
            Slot slot = this.field_147002_h.func_75139_a(slotNum);
            if (!inv.isSlotLocked(slotNum) || !inv.getStackInSlot(slotNum).func_190926_b() || (stack = inv.getTemplateStackInSlot(slotNum)).func_190926_b()) continue;
            int x = this.field_147003_i + slot.field_75223_e;
            int y = this.field_147009_r + slot.field_75221_f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146296_j.func_180450_b(stack, x, y);
        }
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    public static class InfoArea {
        private final int posX;
        private final int posY;
        private final int width;
        private final int height;
        private final String infoText;
        private final Object[] args;
        private int u;
        private int v;

        public InfoArea(int x, int y, int width, int height, String infoTextKey, Object ... args) {
            this.posX = x;
            this.posY = y;
            this.width = width;
            this.height = height;
            this.infoText = infoTextKey;
            this.args = args;
            this.u = 134;
            if (width == 11) {
                this.v = 66;
            } else if (width == 18) {
                this.v = 48;
            }
        }

        public void setUV(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public List<String> getInfoLines() {
            ArrayList<String> lines = new ArrayList<String>();
            ItemEnderUtilities.addTranslatedTooltip(this.infoText, lines, false, this.args);
            return lines;
        }

        public boolean isMouseOver(int mouseX, int mouseY, int guiLeft, int guiTop) {
            return mouseX >= guiLeft + this.posX && mouseX < guiLeft + this.posX + this.width && mouseY >= guiTop + this.posY && mouseY < guiTop + this.posY + this.height;
        }

        public void render(GuiEnderUtilities gui, ResourceLocation texture) {
            gui.bindTexture(texture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.func_73729_b(gui.field_147003_i + this.posX, gui.field_147009_r + this.posY, this.u, this.v, this.width, this.height);
        }
    }
}

