/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.ItemNullifier;
import fi.dy.masa.enderutilities.util.ItemType;
import gnu.trove.map.hash.TIntObjectHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ModelNullifierBaked
implements IBakedModel {
    private static ModelLoader MODEL_LOADER;
    private static Map<ModelResourceLocation, IModel> STATE_MODELS;
    private static Map<IRegistryDelegate<Item>, Int2ObjectMap<ModelResourceLocation>> LOCATIONS;
    private static Map<Item, ItemMeshDefinition> SHAPERS;
    private static final Map<NullifierState, IBakedModel> NULLIFIER_MODEL_CACHE;
    private static final Map<ItemType, IBakedModel> ITEM_MODEL_CACHE;
    private static final ImmutableList<BakedQuad> EMPTY_LIST;
    private final IBakedModel modelBase;
    private final IBakedModel modelLocked;
    private final IModelState modelState;
    private final VertexFormat format;
    private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private final TextureAtlasSprite particle;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformMap;
    private final Map<EnumFacing, ImmutableList<BakedQuad>> quads = new HashMap<EnumFacing, ImmutableList<BakedQuad>>();

    private ModelNullifierBaked(IModel baseModel, IModel lockedModel, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.modelState = state;
        this.modelBase = baseModel.bake(state, format, bakedTextureGetter);
        this.modelLocked = lockedModel.bake(state, format, bakedTextureGetter);
        this.format = format;
        this.bakedTextureGetter = bakedTextureGetter;
        this.particle = bakedTextureGetter.apply(new ResourceLocation("enderutilities:items/nullifier"));
        this.transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
    }

    private ModelNullifierBaked(ModelNullifierBaked nullifierModel, boolean locked, ItemStack containedStack) {
        this.modelState = nullifierModel.modelState;
        this.modelBase = nullifierModel.modelBase;
        this.modelLocked = nullifierModel.modelLocked;
        this.format = nullifierModel.format;
        this.bakedTextureGetter = nullifierModel.bakedTextureGetter;
        this.particle = nullifierModel.particle;
        this.transformMap = nullifierModel.transformMap;
        this.addQuads(nullifierModel, locked, containedStack);
    }

    public boolean func_177555_b() {
        return this.modelBase.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.modelBase.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.modelBase.func_188618_c();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.modelBase.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return ModelNullifierBakedOverrideHandler.INSTANCE;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.modelBase.func_177554_e();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transformMap, (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        ImmutableList<BakedQuad> list = this.quads.get(side);
        return list != null ? list : EMPTY_LIST;
    }

    private void addQuads(ModelNullifierBaked nullifierModel, boolean locked, ItemStack containedStack) {
        ItemType type;
        IBakedModel itemModel = null;
        IBakedModel textModel = null;
        if (!containedStack.func_190926_b() && (itemModel = ITEM_MODEL_CACHE.get(type = new ItemType(containedStack, true))) == null) {
            IModel iModel = this.getItemModel(containedStack);
            if (iModel != null && !iModel.getClass().getName().equals("net.minecraftforge.client.model.FancyMissingModel")) {
                TRSRTransformation trn = new TRSRTransformation(new Vector3f(-0.5f, -0.5f, -0.5f), null, null, null);
                TRSRTransformation trr = TRSRTransformation.from((ModelRotation)ModelRotation.X0_Y180);
                TRSRTransformation trp = new TRSRTransformation(new Vector3f(0.5f, 0.5f, 0.5f), null, null, null);
                TRSRTransformation trs = new TRSRTransformation(null, null, new Vector3f(0.6f, 0.6f, 0.6f), null);
                TRSRTransformation tr = trn.compose(trr).compose(trp).compose(trs);
                ModelStateComposition state = new ModelStateComposition(this.modelState, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)tr));
                itemModel = iModel.bake((IModelState)state, this.format, this.bakedTextureGetter);
            } else {
                Minecraft mc = Minecraft.func_71410_x();
                itemModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(containedStack);
                itemModel = itemModel.func_188617_f().handleItemState(itemModel, containedStack, (World)mc.field_71441_e, (EntityLivingBase)mc.field_71439_g);
            }
            ITEM_MODEL_CACHE.put(type, itemModel);
        }
        this.addQuadsForSide(null, nullifierModel, itemModel, textModel, locked);
        for (EnumFacing side : EnumFacing.values()) {
            this.addQuadsForSide(side, nullifierModel, itemModel, textModel, locked);
        }
    }

    @Nullable
    private IModel getItemModel(ItemStack stack) {
        ItemMeshDefinition mesh;
        this.reflectMaps();
        Item item = stack.func_77973_b();
        ModelResourceLocation mrl = null;
        Int2ObjectMap<ModelResourceLocation> map = LOCATIONS.get(item.delegate);
        if (map != null) {
            mrl = (ModelResourceLocation)map.get(stack.func_77960_j());
        }
        if (mrl == null && (mesh = SHAPERS.get(item)) != null) {
            mrl = mesh.func_178113_a(stack);
        }
        if (mrl != null) {
            try {
                return ModelLoaderRegistry.getModel((ResourceLocation)mrl);
            }
            catch (Exception e) {
                return STATE_MODELS.get(mrl);
            }
        }
        return null;
    }

    private void reflectMaps() {
        if (LOCATIONS == null || SHAPERS == null) {
            try {
                ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
                Field locs = ReflectionHelper.findField(ItemModelMesherForge.class, (String[])new String[]{"locations"});
                try {
                    Map mapObj = (Map)locs.get(mesher);
                    Iterator iter = mapObj.values().iterator();
                    if (iter.hasNext()) {
                        Object o = iter.next();
                        if (o instanceof Int2ObjectMap) {
                            LOCATIONS = mapObj;
                        } else if (o instanceof TIntObjectHashMap) {
                            Map map = mapObj;
                            LOCATIONS = new HashMap<IRegistryDelegate<Item>, Int2ObjectMap<ModelResourceLocation>>();
                            for (Map.Entry entry : map.entrySet()) {
                                Int2ObjectOpenHashMap mrlMap = new Int2ObjectOpenHashMap();
                                TIntObjectHashMap oldMap = (TIntObjectHashMap)entry.getValue();
                                for (int key : oldMap.keys()) {
                                    ModelResourceLocation mrl = (ModelResourceLocation)oldMap.get(key);
                                    if (mrl == null) continue;
                                    mrlMap.put(key, (Object)mrl);
                                }
                                LOCATIONS.put((IRegistryDelegate<Item>)entry.getKey(), (Int2ObjectMap<ModelResourceLocation>)mrlMap);
                            }
                        }
                    }
                }
                catch (Exception mapObj) {
                    // empty catch block
                }
                Field shapers = ReflectionHelper.findField(ItemModelMesher.class, (String[])new String[]{"field_178092_c", "shapers"});
                SHAPERS = (Map)shapers.get(mesher);
                Field models = ReflectionHelper.findField(ModelLoader.class, (String[])new String[]{"stateModels"});
                STATE_MODELS = (Map)models.get(MODEL_LOADER);
            }
            catch (Exception e) {
                EnderUtilities.logger.warn("ModelNullifierBaked: Failed to reflect model maps", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public static void onModelbakeEvent(ModelBakeEvent event) {
        MODEL_LOADER = event.getModelLoader();
    }

    private void addQuadsForSide(EnumFacing side, ModelNullifierBaked nullifierModel, IBakedModel itemModel, IBakedModel textModel, boolean locked) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)nullifierModel.modelBase.func_188616_a(null, side, 0L));
        if (locked) {
            builder.addAll((Iterable)nullifierModel.modelLocked.func_188616_a(null, side, 0L));
        }
        if (itemModel != null) {
            builder.addAll((Iterable)itemModel.func_188616_a(null, side, 0L));
        }
        this.quads.put(side, (ImmutableList<BakedQuad>)builder.build());
    }

    static {
        NULLIFIER_MODEL_CACHE = new HashMap<NullifierState, IBakedModel>();
        ITEM_MODEL_CACHE = new HashMap<ItemType, IBakedModel>();
        EMPTY_LIST = ImmutableList.of();
    }

    public static class ModelLoaderNullifier
    implements ICustomModelLoader {
        private static final ResourceLocation FAKE_LOCATION = new ResourceLocation("enderutilities", "models/block/custom/nullifier");

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.equals((Object)FAKE_LOCATION);
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return new ModelNullifier();
        }

        public void func_110549_a(IResourceManager resourceManager) {
            NULLIFIER_MODEL_CACHE.clear();
            ITEM_MODEL_CACHE.clear();
        }
    }

    private static class ModelNullifier
    implements IModel {
        public static final ResourceLocation BASE_MODEL = new ResourceLocation("enderutilities", "item/nullifier_base");
        public static final ResourceLocation LOCKED_MODEL = new ResourceLocation("enderutilities", "item/standard_item");
        public static final String TEX_BASE = "enderutilities:items/nullifier";
        public static final String TEX_LOCKED = "enderutilities:items/item_overlay_locked";

        private ModelNullifier() {
        }

        public IModelState getDefaultState() {
            return TRSRTransformation.identity();
        }

        public Collection<ResourceLocation> getDependencies() {
            return Lists.newArrayList((Object[])new ResourceLocation[]{BASE_MODEL, LOCKED_MODEL});
        }

        public Collection<ResourceLocation> getTextures() {
            ArrayList textures = Lists.newArrayList();
            textures.add(new ResourceLocation(TEX_BASE));
            textures.add(new ResourceLocation(TEX_LOCKED));
            return textures;
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            IModel baseModel = null;
            IModel lockedModel = null;
            try {
                baseModel = ModelLoaderRegistry.getModel((ResourceLocation)BASE_MODEL);
                lockedModel = ModelLoaderRegistry.getModel((ResourceLocation)LOCKED_MODEL);
                lockedModel = lockedModel.retexture(ImmutableMap.of((Object)"layer0", (Object)TEX_LOCKED));
            }
            catch (Exception e) {
                EnderUtilities.logger.warn("Failed to load a model for the Nullifier!");
            }
            return new ModelNullifierBaked(baseModel, lockedModel, state, format, bakedTextureGetter);
        }
    }

    private static class NullifierState {
        private final ItemType containedItem;
        private final boolean locked;

        public NullifierState(ItemStack nullifierStack) {
            this.locked = !ItemNullifier.isNullifierEnabled(nullifierStack);
            ItemStack containedStack = ItemNullifier.getSelectedStack(nullifierStack);
            this.containedItem = containedStack.func_190926_b() ? null : new ItemType(containedStack, true);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.containedItem == null ? 0 : this.containedItem.hashCode());
            result = 31 * result + (this.locked ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NullifierState other = (NullifierState)obj;
            if (this.containedItem == null ? other.containedItem != null : !this.containedItem.equals(other.containedItem)) {
                return false;
            }
            return this.locked == other.locked;
        }
    }

    private static final class ModelNullifierBakedOverrideHandler
    extends ItemOverrideList {
        public static final ModelNullifierBakedOverrideHandler INSTANCE = new ModelNullifierBakedOverrideHandler();

        private ModelNullifierBakedOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModelIn, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
            ModelNullifierBaked originalModel = (ModelNullifierBaked)originalModelIn;
            NullifierState state = new NullifierState(stack);
            IBakedModel model = (IBakedModel)NULLIFIER_MODEL_CACHE.get(state);
            if (model == null) {
                model = new ModelNullifierBaked(originalModel, state.locked, ItemNullifier.getSelectedStack(stack));
                NULLIFIER_MODEL_CACHE.put(state, model);
            }
            return model;
        }
    }
}

