/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block.base;

import fi.dy.masa.enderutilities.creativetab.CreativeTab;
import fi.dy.masa.enderutilities.item.block.ItemBlockEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.EntityUtils;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockEnderUtilities
extends Block {
    public static final EnumFacing DEFAULT_FACING = EnumFacing.NORTH;
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyDirection FACING_H = BlockHorizontal.field_185512_D;
    protected String blockName;
    protected String[] unlocalizedNames;
    protected String[] tooltipNames;
    protected boolean enabled = true;
    public PropertyDirection propFacing = FACING_H;

    public BlockEnderUtilities(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(material);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.setHarvestLevel("pickaxe", harvestLevel);
        this.func_149647_a(CreativeTab.ENDER_UTILITIES_TAB);
        this.func_149672_a(SoundType.field_185851_d);
        this.blockName = name;
        this.unlocalizedNames = this.generateUnlocalizedNames();
        this.tooltipNames = this.generateTooltipNames();
    }

    public String getBlockName() {
        return this.blockName;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    protected String[] generateUnlocalizedNames() {
        return new String[]{this.blockName};
    }

    protected String[] generateTooltipNames() {
        return this.generateUnlocalizedNames();
    }

    public String[] getUnlocalizedNames() {
        return this.unlocalizedNames;
    }

    public String[] getTooltipNames() {
        return this.tooltipNames;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BlockEnderUtilities setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ItemBlock createItemBlock() {
        return new ItemBlockEnderUtilities(this);
    }

    public void setPlacementProperties(World world, BlockPos pos, @Nonnull ItemStack stack, @Nonnull NBTTagCompound tag) {
        TileEntityEnderUtilities te;
        if (stack.func_77978_p() == null && (te = BlockEnderUtilities.getTileEntitySafely((IBlockAccess)world, pos, TileEntityEnderUtilities.class)) != null) {
            te.setPlacementProperties(world, pos, stack, tag);
        }
    }

    public void scheduleBlockUpdate(World world, BlockPos pos, IBlockState state, int delay, boolean force) {
        if (force || !world.func_184145_b(pos, state.func_177230_c())) {
            world.func_175684_a(pos, state.func_177230_c(), delay);
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos).func_185907_a(Rotation.CLOCKWISE_90);
        world.func_180501_a(pos, state, 3);
        return true;
    }

    public <T> Map<T, AxisAlignedBB> getHilightBoxMap() {
        return Collections.emptyMap();
    }

    public <T> T getPointedElementId(World world, BlockPos pos, EnumFacing side, Entity entity) {
        this.updateBlockHilightBoxes(world, pos, side);
        return EntityUtils.getPointedBox(EntityUtils.getEyesVec(entity), entity.func_70040_Z(), 6.0, this.getHilightBoxMap());
    }

    public void updateBlockHilightBoxes(World world, BlockPos pos, EnumFacing facing) {
    }

    @Nullable
    public static <T extends TileEntity> T getTileEntitySafely(IBlockAccess world, BlockPos pos, Class<T> tileClass) {
        TileEntity te;
        if (world instanceof ChunkCache) {
            ChunkCache chunkCache = (ChunkCache)world;
            te = chunkCache.func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK);
        } else {
            te = world.func_175625_s(pos);
        }
        if (tileClass.isInstance(te)) {
            return (T)((TileEntity)tileClass.cast(te));
        }
        return null;
    }
}

