/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities;

import fi.dy.masa.enderutilities.capabilities.EnderUtilitiesCapabilities;
import fi.dy.masa.enderutilities.config.ConfigReader;
import fi.dy.masa.enderutilities.gui.EnderUtilitiesGUIHandler;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.proxy.CommonProxy;
import fi.dy.masa.enderutilities.registry.ModRegistry;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import fi.dy.masa.enderutilities.util.PlacementProperties;
import fi.dy.masa.enderutilities.util.datafixer.TileEntityID;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="enderutilities", name="Ender Utilities", version="0.7.11", certificateFingerprint="2b03e1423915a189b8094816baa18f239d576dff", guiFactory="fi.dy.masa.enderutilities.config.EnderUtilitiesGuiFactory", updateJSON="https://raw.githubusercontent.com/maruohon/enderutilities/master/update.json", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:forge@[14.23.3.2694,);")
public class EnderUtilities {
    public static final int DATA_FIXER_VERSION = 922;
    @Mod.Instance(value="enderutilities")
    public static EnderUtilities instance;
    @SidedProxy(clientSide="fi.dy.masa.enderutilities.proxy.ClientProxy", serverSide="fi.dy.masa.enderutilities.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigReader.loadConfigsFromFile(event.getSuggestedConfigurationFile());
        ModRegistry.checkLoadedMods();
        proxy.registerEventHandlers();
        proxy.registerEntities();
        proxy.registerKeyBindings();
        proxy.registerRenderers();
        EnderUtilitiesCapabilities.register();
        PacketHandler.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new EnderUtilitiesGUIHandler());
    }

    @Mod.EventHandler
    public void onServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        ModFixs dataFixer = proxy.getDataFixer();
        TileEntityID renames = new TileEntityID();
        dataFixer.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)renames);
        dataFixer.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)renames);
    }

    @Mod.EventHandler
    public void onServerStartingEvent(FMLServerStartingEvent event) {
        ConfigReader.reLoadAllConfigs(true);
        ChunkLoading.getInstance().init();
        EnergyBridgeTracker.readFromDisk();
        PlacementProperties.getInstance().readFromDisk();
    }

    @Mod.EventHandler
    public void onFingerPrintViolation(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            logger.warn("*********************************************************************************************");
            logger.warn("*****                                    WARNING                                        *****");
            logger.warn("*****                                                                                   *****");
            logger.warn("*****   The signature of the mod file '{}' does not match the expected fingerprint!     *****", (Object)event.getSource().getName());
            logger.warn("*****   This might mean that the mod file has been tampered with!                       *****");
            logger.warn("*****   If you did not download the mod {} directly from Curse/CurseForge,       *****", (Object)"Ender Utilities");
            logger.warn("*****   or using one of the well known launchers, and you did not                       *****");
            logger.warn("*****   modify the mod file at all yourself, then it's possible,                        *****");
            logger.warn("*****   that it may contain malware or other unwanted things!                           *****");
            logger.warn("*********************************************************************************************");
        }
    }

    static {
        logger = LogManager.getLogger((String)"enderutilities");
    }
}

