/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.GuiInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;

public class OperatorAppendix
extends SectionAppendix {
    private final IOperator operator;

    public OperatorAppendix(IInfoBook infoBook, IOperator operator) {
        super(infoBook);
        this.operator = operator;
    }

    protected int getOffsetY() {
        return 5;
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeight() {
        return 30 + this.operator.getInputTypes().length * 8;
    }

    protected void drawElement(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = 5;
        gui.drawOuterBorder(x - 1, y - 1 - yOffset, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(L10NHelpers.localize((String)"operator.operators.integrateddynamics.name", (Object[])new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, Helpers.RGBToInt((int)120, (int)20, (int)30));
        String operatorName = L10NHelpers.localize((String)this.operator.getUnlocalizedName(), (Object[])new Object[0]);
        gui.drawScaledCenteredString(L10NHelpers.localize((String)operatorName, (Object[])new Object[0]) + " (" + this.operator.getSymbol() + ")", x, y + 8, width, 1.0f, gui.getBannerWidth(), 0);
        boolean wasUnicode = gui.getFontRenderer().func_82883_a();
        gui.getFontRenderer().func_78264_a(true);
        IValueType[] inputTypes = this.operator.getInputTypes();
        int offsetY = 14;
        for (int i = 0; i < inputTypes.length; ++i) {
            gui.getFontRenderer().func_78276_b(L10NHelpers.localize((String)"gui.integrateddynamics.input", (Object[])new Object[]{i + 1 + ": " + inputTypes[i].getDisplayColorFormat() + L10NHelpers.localize((String)inputTypes[i].getUnlocalizedName(), (Object[])new Object[0])}), x, y + offsetY, 0);
            offsetY += 8;
        }
        String outputTypeName = L10NHelpers.localize((String)this.operator.getOutputType().getUnlocalizedName(), (Object[])new Object[0]);
        gui.getFontRenderer().func_78276_b(L10NHelpers.localize((String)"gui.integrateddynamics.output", (Object[])new Object[]{this.operator.getOutputType().getDisplayColorFormat() + outputTypeName}), x, y + offsetY, 0);
        gui.getFontRenderer().func_78264_a(wasUnicode);
    }

    protected void postDrawElement(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        GlStateManager.func_179094_E();
        if (mx >= x && my >= y && mx <= x + this.getWidth() && my <= y + gui.getFontRenderer().field_78288_b) {
            ArrayList lines = Lists.newArrayList();
            this.operator.loadTooltip(lines, true);
            gui.func_146283_a((List)lines, mx, my);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    public void preBakeElement(InfoSection infoSection) {
    }

    public void bakeElement(InfoSection infoSection) {
    }
}

