/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.item.ItemStack;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.capability.valueinterface.ValueInterfaceConfig;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;

public abstract class TileActiveVariableBase<E>
extends TileCableConnectableInventory
implements IDirtyMarkListener,
IVariableFacade.IValidator,
INetworkEventListener<E> {
    protected IVariableFacade variableStored = null;
    @NBTPersist
    private List<L10NHelpers.UnlocalizedString> errors = Lists.newLinkedList();

    public TileActiveVariableBase(int inventorySize, String inventoryName) {
        super(inventorySize, inventoryName, 1);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.addCapabilityInternal(ValueInterfaceConfig.CAPABILITY, () -> {
            IVariable<?> variable;
            INetwork network = this.getNetwork();
            IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(network);
            if (network == null || partNetwork == null) {
                throw new EvaluationException("No valid network was found");
            }
            if (this.hasVariable() && (variable = this.getVariable(partNetwork)) != null) {
                return Optional.of(variable.getValue());
            }
            return Optional.empty();
        });
    }

    public abstract int getSlotRead();

    public boolean hasVariable() {
        return !this.func_70301_a(this.getSlotRead()).func_190926_b();
    }

    protected void updateReadVariable(boolean sendVariablesUpdateEvent) {
        INetwork network = this.getNetwork();
        IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(network);
        int lastVariabledId = this.variableStored == null ? -1 : this.variableStored.getId();
        int variableId = -1;
        if (!this.func_70301_a(this.getSlotRead()).func_190926_b() && NetworkHelpers.shouldWork()) {
            ItemStack itemStack = this.func_70301_a(this.getSlotRead());
            IVariableFacadeHandlerRegistry handler = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
            this.variableStored = handler.handle(itemStack);
            if (this.variableStored != null) {
                variableId = this.variableStored.getId();
            }
        } else {
            this.variableStored = null;
        }
        this.errors.clear();
        if (partNetwork == null) {
            this.addError(new L10NHelpers.UnlocalizedString("general.integrateddynamics.error.no_network", new Object[0]));
        } else if (this.variableStored != null) {
            this.preValidate(this.variableStored);
            try {
                this.variableStored.validate(partNetwork, this, ValueTypes.CATEGORY_ANY);
            }
            catch (IllegalArgumentException e) {
                this.addError(new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]));
            }
        }
        if (sendVariablesUpdateEvent && partNetwork != null && lastVariabledId != variableId) {
            network.getEventBus().post(new VariableContentsUpdatedEvent(network));
        }
        this.sendUpdate();
    }

    protected void preValidate(IVariableFacade variableStored) {
    }

    public void onDirty() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateReadVariable(true);
        }
    }

    public IVariable<?> getVariable(IPartNetwork network) {
        if (this.variableStored == null || !this.getErrors().isEmpty()) {
            return null;
        }
        try {
            return this.variableStored.getVariable(network);
        }
        catch (IllegalArgumentException e) {
            this.addError(new L10NHelpers.UnlocalizedString(e.getMessage(), new Object[0]));
            return null;
        }
    }

    @Override
    public void addError(L10NHelpers.UnlocalizedString error) {
        this.errors.add(error);
    }

    @Override
    public boolean hasEventSubscriptions() {
        return true;
    }

    @Override
    public Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return Sets.newHashSet((Object[])new Class[]{VariableContentsUpdatedEvent.class});
    }

    @Override
    public void onEvent(INetworkEvent event, E networkElement) {
        if (event instanceof VariableContentsUpdatedEvent) {
            this.updateReadVariable(false);
        }
    }

    @Override
    public void afterNetworkReAlive() {
        super.afterNetworkReAlive();
        this.updateReadVariable(true);
    }

    public List<L10NHelpers.UnlocalizedString> getErrors() {
        return this.errors;
    }
}

