/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyMaterialized;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeListProxyMaterializedFactory
implements IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<IValueType<IValue>, IValue, ValueTypeListProxyMaterialized<IValueType<IValue>, IValue>> {
    private static final String ELEMENT_DELIMITER = ";";
    private static final String ELEMENT_DELIMITER_SPLITREGEX = "(?<!\\\\);";
    private static final String ELEMENT_DELIMITER_ESCAPED = "\\\\;";

    @Override
    public String getName() {
        return "materialized";
    }

    @Override
    public String serialize(ValueTypeListProxyMaterialized<IValueType<IValue>, IValue> values) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        StringBuilder sb = new StringBuilder();
        Object valueType = values.getValueType();
        try {
            if (valueType.isCategory() && values.getLength() > 0) {
                valueType = values.get(0).getType();
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        sb.append(valueType.getUnlocalizedName());
        for (IValue value : values) {
            sb.append(ELEMENT_DELIMITER);
            sb.append(ValueHelpers.serializeRaw(value).replaceAll(ELEMENT_DELIMITER, ELEMENT_DELIMITER_ESCAPED));
        }
        return sb.toString();
    }

    @Override
    public ValueTypeListProxyMaterialized<IValueType<IValue>, IValue> deserialize(String value) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        String[] split = value.split(ELEMENT_DELIMITER_SPLITREGEX);
        if (split.length < 1) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized materialized list proxy value '%s'.", value));
        }
        String valueTypeName = split[0];
        IValueType valueType = ValueTypes.REGISTRY.getValueType(valueTypeName);
        if (valueType == null) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized materialized list proxy value because the value type by name '%s' was not found.", valueTypeName));
        }
        String[] values = new String[split.length - 1];
        System.arraycopy(split, 1, values, 0, split.length - 1);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String serializedValue : values) {
            Object deserializedValue = valueType.deserialize(serializedValue.replaceAll(ELEMENT_DELIMITER_ESCAPED, ELEMENT_DELIMITER));
            builder.add(deserializedValue);
        }
        return new ValueTypeListProxyMaterialized<IValueType<IValue>, IValue>(valueType, (List<IValue>)builder.build());
    }
}

