/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.network;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import org.cyclops.integrateddynamics.api.part.PartPos;

public interface IPositionedAddonsNetwork {
    public Collection<PrioritizedPartPos> getPositions(int var1);

    public Collection<PrioritizedPartPos> getPositions();

    public PositionsIterator getPositionIterator(int var1);

    public void setPositionIterator(@Nullable PositionsIterator var1, int var2);

    public PositionsIterator createPositionIterator(int var1);

    public void onPositionIteratorCreated(PositionsIterator var1);

    public boolean addPosition(PartPos var1, int var2, int var3);

    public void removePosition(PartPos var1);

    public boolean isPositionDisabled(PartPos var1);

    public void disablePosition(PartPos var1);

    public void enablePosition(PartPos var1);

    public static class PositionsIterator
    implements Iterator<PrioritizedPartPos> {
        private boolean valid = true;
        private final Collection<PrioritizedPartPos> collection;
        private final Iterator<PrioritizedPartPos> it;
        private int steps;
        private final Set<PositionsIterator> children;
        private final IPositionedAddonsNetwork positionedAddonsNetwork;
        private PrioritizedPartPos[] toAppend = new PrioritizedPartPos[0];
        private int toAppendStep = 0;

        public PositionsIterator(Collection<PrioritizedPartPos> collection, IPositionedAddonsNetwork positionedAddonsNetwork) {
            this.collection = collection;
            this.it = this.collection.iterator();
            this.steps = 0;
            this.children = Collections.newSetFromMap(new WeakHashMap());
            this.positionedAddonsNetwork = positionedAddonsNetwork;
        }

        public void invalidate() {
            this.valid = false;
            this.children.forEach(PositionsIterator::invalidate);
        }

        @Override
        public boolean hasNext() {
            return this.valid && (this.it.hasNext() || this.toAppendStep < this.toAppend.length);
        }

        @Override
        public PrioritizedPartPos next() {
            ++this.steps;
            if (this.steps >= this.collection.size()) {
                this.steps %= this.collection.size();
            }
            return this.it.hasNext() ? this.it.next() : this.toAppend[this.toAppendStep++];
        }

        protected void setToAppend(PrioritizedPartPos[] toAppend) {
            this.toAppend = toAppend;
        }

        public PositionsIterator cloneState() {
            PositionsIterator child = new PositionsIterator(this.collection, this.positionedAddonsNetwork);
            this.positionedAddonsNetwork.onPositionIteratorCreated(child);
            this.children.add(child);
            PrioritizedPartPos[] toAppend = new PrioritizedPartPos[this.steps];
            for (int step = 0; step < this.steps; ++step) {
                toAppend[step] = child.next();
            }
            child.setToAppend(toAppend);
            return child;
        }
    }

    public static class PrioritizedPartPos
    implements Comparable<PrioritizedPartPos> {
        private final PartPos partPos;
        private final int priority;

        private PrioritizedPartPos(PartPos partPos, int priority) {
            this.partPos = partPos;
            this.priority = priority;
        }

        @Override
        public int compareTo(PrioritizedPartPos o) {
            int compPriority = -Integer.compare(this.getPriority(), o.getPriority());
            if (compPriority == 0) {
                int compPos = this.getPartPos().getPos().compareTo(o.getPartPos().getPos());
                if (compPos == 0) {
                    EnumFacing thisSide = this.getPartPos().getSide();
                    EnumFacing otherSide = o.getPartPos().getSide();
                    return thisSide == null ? -1 : (otherSide == null ? 1 : thisSide.compareTo((Enum)otherSide));
                }
                return compPos;
            }
            return compPriority;
        }

        public static PrioritizedPartPos of(PartPos pos, int priority) {
            return new PrioritizedPartPos(pos, priority);
        }

        public PartPos getPartPos() {
            return this.partPos;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

