/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.ASMEventHandler;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.Placebo;
import shadows.placebo.util.FastShapelessRecipe;

public class PlaceboDebug {
    public static void debug() {
        ArrayList<FastShapelessRecipe> lest = new ArrayList<FastShapelessRecipe>();
        for (IRecipe iRecipe : ForgeRegistries.RECIPES) {
            if (iRecipe.getClass() != ShapelessRecipes.class) continue;
            FastShapelessRecipe res = new FastShapelessRecipe(iRecipe.func_193358_e(), iRecipe.func_77571_b(), (NonNullList<Ingredient>)iRecipe.func_192400_c());
            res.setRegistryName(iRecipe.getRegistryName());
            lest.add(res);
        }
        for (IRecipe iRecipe : lest) {
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)iRecipe);
        }
    }

    public static void dumpEventHandlers() {
        try {
            ConcurrentHashMap map = (ConcurrentHashMap)ReflectionHelper.getPrivateValue(EventBus.class, (Object)MinecraftForge.EVENT_BUS, (String[])new String[]{"listeners"});
            for (Object o : map.keySet()) {
                for (IEventListener iel : (ArrayList)map.get(o)) {
                    String desc = "";
                    if (iel instanceof ASMEventHandler) {
                        desc = desc + ReflectionHelper.getPrivateValue(ASMEventHandler.class, (Object)((ASMEventHandler)iel), (String[])new String[]{"readable"});
                        Placebo.LOG.info("Found event handler: " + desc);
                        continue;
                    }
                    Placebo.LOG.info("Class " + o.getClass().getName() + " has event handler, but it is not an ASMEventHandler!");
                }
            }
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            Placebo.LOG.error("Failed to dump event handlers!");
        }
    }
}

