/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.gui.components;

import com.feed_the_beast.ftbguides.gui.components.ComponentPanel;
import com.feed_the_beast.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.ftbguides.gui.components.IGuideComponentWidget;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringJoiner;
import java.util.List;

public class CodeblockGuideComponent
extends GuideComponent {
    public final List<String> text;

    public CodeblockGuideComponent(List<String> txt) {
        this.text = txt;
    }

    @Override
    public String toString() {
        return StringJoiner.with((char)'\n').join(this.text);
    }

    @Override
    public boolean isEmpty() {
        for (String s : this.text) {
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public IGuideComponentWidget createWidget(ComponentPanel parent) {
        return new CodeblockWidget(parent, this);
    }

    private static class CodeblockWidget
    extends Widget
    implements IGuideComponentWidget {
        public static final Icon CODE_BACKGROUND = Color4I.rgba((int)612066612);
        public final CodeblockGuideComponent component;
        public final String[] text;

        public CodeblockWidget(ComponentPanel parent, CodeblockGuideComponent t) {
            super((Panel)parent);
            this.component = t;
            this.text = this.component.toString().split("\n");
            Theme theme = this.getGui().getTheme();
            this.setWidth(0);
            for (String s : this.text) {
                this.setWidth(Math.max(this.width, theme.getStringWidth(s)));
            }
            this.setHeight(this.text.length * 10);
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            CODE_BACKGROUND.draw(x, y, w, h);
            for (int i = 0; i < this.text.length; ++i) {
                theme.drawString(this.text[i], x, y + 10 * i);
            }
        }
    }
}

