/*
 * Decompiled with CFR 0.152.
 */
package io.sommers.packmode.compat.gamestages;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.sommers.packmode.PMConfig;
import io.sommers.packmode.PackMode;
import io.sommers.packmode.api.PackModeAPI;
import io.sommers.packmode.api.PackModeChangedEvent;
import io.sommers.packmode.compat.Compat;
import java.util.ArrayList;
import java.util.Map;
import joptsimple.internal.Strings;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class GameStagesCompat
extends Compat {
    private Map<String, String[]> packModeToGameStages = Maps.newHashMap();

    @Override
    public void preInit() {
        String[] packModes;
        MinecraftForge.EVENT_BUS.register((Object)this);
        Configuration configuration = PMConfig.getConfiguration();
        ConfigCategory gameStagesCategory = configuration.getCategory("GameStages Mappings");
        gameStagesCategory.setComment("The GameStages that will get added when a PackMode is set. (Happens Immediately with no Restart");
        for (String packMode : packModes = PMConfig.getAcceptedModes()) {
            Property gameStageMapping = configuration.get(gameStagesCategory.getName(), packMode, new String[0]);
            this.packModeToGameStages.put(packMode, gameStageMapping.getStringList());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void gameStageChangeOnPackMode(PackModeChangedEvent event) {
        PackMode.proxy.getPlayers().parallelStream().filter(entityPlayer -> entityPlayer instanceof EntityPlayerMP).map(entityPlayer -> (EntityPlayerMP)entityPlayer).forEach(entityPlayerMP -> this.handleGameStages((EntityPlayerMP)entityPlayerMP, event.getNextRestartPackMode(), true));
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            this.handleGameStages((EntityPlayerMP)event.player, PackModeAPI.getInstance().getNextRestartPackMode(), false);
        }
    }

    public void handleGameStages(EntityPlayerMP entityPlayer, String packMode, boolean sendMessage) {
        IStageData stageData = GameStageHelper.getPlayerData((EntityPlayer)entityPlayer);
        ArrayList addedStages = Lists.newArrayList();
        ArrayList removedStages = Lists.newArrayList();
        for (Map.Entry<String, String[]> entry : this.packModeToGameStages.entrySet()) {
            for (String gameStage : entry.getValue()) {
                if (entry.getKey().equals(packMode)) {
                    if (stageData.hasStage(gameStage)) continue;
                    stageData.addStage(gameStage);
                    addedStages.add(gameStage);
                    continue;
                }
                if (!stageData.hasStage(gameStage)) continue;
                stageData.removeStage(gameStage);
                removedStages.add(gameStage);
            }
        }
        if (!addedStages.isEmpty() || !removedStages.isEmpty()) {
            GameStageHelper.syncPlayer((EntityPlayerMP)entityPlayer);
        }
        if (sendMessage) {
            if (!addedStages.isEmpty()) {
                entityPlayer.func_146105_b((ITextComponent)new TextComponentString("GameStages added: " + Strings.join((Iterable)addedStages, (String)",")), true);
            }
            if (!removedStages.isEmpty()) {
                entityPlayer.func_146105_b((ITextComponent)new TextComponentString("GameStages removed: " + Strings.join((Iterable)removedStages, (String)",")), true);
            }
        }
    }
}

