/*
 * Decompiled with CFR 0.152.
 */
package io.sommers.packmode.api;

import com.google.common.collect.ImmutableList;
import io.sommers.packmode.api.PackModeChangedEvent;
import java.util.List;
import java.util.Objects;
import joptsimple.internal.Strings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PackModeAPI {
    private static PackModeAPI instance;
    private final String currentPackMode;
    private final List<String> packModes;
    private String nextRestartPackMode;

    private PackModeAPI(String currentPackMode, List<String> packModes) {
        this.currentPackMode = currentPackMode;
        this.nextRestartPackMode = currentPackMode;
        this.packModes = ImmutableList.copyOf(packModes);
    }

    public static PackModeAPI getInstance() {
        return Objects.requireNonNull(instance, "PackMode API not created yet!");
    }

    public static void createInstance(String currentPackMode, List<String> packModes) {
        if (instance != null) {
            throw new IllegalStateException("PackMode API was created more than once!");
        }
        if (!packModes.contains(currentPackMode)) {
            throw new IllegalArgumentException("Pack Mode " + currentPackMode + " is not contained in " + Strings.join(packModes, (String)" , "));
        }
        instance = new PackModeAPI(currentPackMode, packModes);
    }

    public String getCurrentPackMode() {
        return this.currentPackMode;
    }

    public List<String> getPackModes() {
        return this.packModes;
    }

    public String getNextRestartPackMode() {
        return this.nextRestartPackMode;
    }

    public boolean isValidPackMode(String packMode) {
        return this.packModes.contains(packMode);
    }

    public void setNextRestartPackMode(String nextRestartPackMode) {
        if (!this.isValidPackMode(nextRestartPackMode)) {
            throw new IllegalArgumentException("Pack Mode " + nextRestartPackMode + " is not contained in " + Strings.join(this.getPackModes(), (String)" , "));
        }
        this.nextRestartPackMode = nextRestartPackMode;
        MinecraftForge.EVENT_BUS.post((Event)new PackModeChangedEvent(nextRestartPackMode));
    }
}

