/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.handlers;

import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.io.IOUtils;

public class FileHandler {
    public static File rootConfigFolder;
    public static File brandon3055Folder;
    public static File mcDirectory;
    private static final Set<Character> ILLEGAL_CHARACTERS;
    public static final Predicate<String> FILE_NAME_VALIDATOR;

    public static void init(FMLPreInitializationEvent event) {
        rootConfigFolder = event.getModConfigurationDirectory();
        brandon3055Folder = new File(rootConfigFolder, "brandon3055");
        if (!brandon3055Folder.exists() && brandon3055Folder.mkdirs()) {
            LogHelperBC.error("Could not create config directory! Things are probably going to break!");
        }
        mcDirectory = rootConfigFolder.getParentFile();
    }

    public static void downloadFile(String sourceUrl, File output) throws IOException {
        URL url = new URL(sourceUrl);
        if (!output.exists() && !output.createNewFile()) {
            throw new IOException("Could not create file, Reason unknown");
        }
        InputStream is = FileHandler.openURLStream(url);
        FileOutputStream os = new FileOutputStream(output);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    public static InputStream openURLStream(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        return urlConnection.getInputStream();
    }

    public static JsonObject readObj(File file) throws IOException {
        JsonReader reader = new JsonReader((Reader)new FileReader(file));
        JsonParser parser = new JsonParser();
        reader.setLenient(true);
        JsonElement element = parser.parse(reader);
        IOUtils.closeQuietly((Closeable)reader);
        return element.getAsJsonObject();
    }

    public static void writeJson(JsonObject obj, File file) throws IOException {
        JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
        writer.setIndent("  ");
        Streams.write((JsonElement)obj, (JsonWriter)writer);
        writer.flush();
        IOUtils.closeQuietly((Closeable)writer);
    }

    static {
        ILLEGAL_CHARACTERS = Sets.newHashSet((Object[])new Character[]{Character.valueOf('/'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\t'), Character.valueOf('\u0000'), Character.valueOf('\f'), Character.valueOf('`'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\\'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf('\"'), Character.valueOf(':')});
        FILE_NAME_VALIDATOR = s -> {
            if (s == null || s.isEmpty()) {
                return false;
            }
            for (char c : s.toCharArray()) {
                if (!ILLEGAL_CHARACTERS.contains(Character.valueOf(c))) continue;
                return false;
            }
            return true;
        };
    }
}

