/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.old;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.GuiMarkdownElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.IPartBuilder;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.Part;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.PartContainer;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class PartContainerTable
extends PartContainer {
    private static Pattern optionExtract = Pattern.compile("(?<=\u00a7table\\[)([^]]*)(?=])");
    public LinkedList<LinkedList<LinkedList<Part>>> partsRows = new LinkedList();
    public LinkedList<LinkedList<Integer>> cellHeights = new LinkedList();
    public LinkedList<ColumnData> columnData = new LinkedList();
    public LinkedList<Integer> rowHeights = new LinkedList();
    boolean headers = false;
    public int tableWidth = 0;
    public boolean renderCells = false;
    public int cellColour = -16777216;
    public int headerColour = -16711681;
    public GuiAlign.Vertical vertAlign = GuiAlign.Vertical.TOP;

    public PartContainerTable(GuiMarkdownElement element) {
        super(element);
    }

    @Override
    public void parseMarkdown(LinkedList<String> markdownLines) {
        if (markdownLines.size() < 2) {
            return;
        }
        String tag = markdownLines.removeFirst();
        Matcher optionMatcher = optionExtract.matcher(tag);
        if (!optionMatcher.find()) {
            markdownLines.addFirst("[Broken Table. Invalid table tag]");
            return;
        }
        String options = optionMatcher.group();
        String parseError = this.readOptions(options);
        if (parseError != null) {
            markdownLines.addFirst("[Broken Table. " + parseError + "]");
            return;
        }
        if (this.checkDelimiter(markdownLines.getFirst())) {
            markdownLines.removeFirst();
        } else if (this.checkDelimiter(markdownLines.get(1))) {
            markdownLines.remove(1);
            this.headers = true;
        } else {
            markdownLines.addFirst("[Broken Table. Invalid table no Delimiter found!]");
            return;
        }
        int divSum = 0;
        int availableWidth = this.tableWidth;
        boolean dynamic = false;
        for (ColumnData data : this.columnData) {
            if (data.fixedWidth) {
                availableWidth -= data.colWidth;
                continue;
            }
            divSum += data.divN;
            dynamic = true;
        }
        if (!dynamic) {
            this.tableWidth -= availableWidth - 1;
        }
        int offset = 0;
        for (ColumnData data : this.columnData) {
            if (data.fixedWidth) {
                offset += data.colWidth;
                if (this.renderCells) {
                    data.colWidth -= 4;
                }
                data.colOffset = offset;
                continue;
            }
            int width = (int)((double)data.divN / (double)divSum * (double)availableWidth);
            data.colOffset = offset;
            data.colWidth = width;
            if (this.renderCells) {
                data.colWidth -= 4;
            }
            offset += width;
        }
        while (markdownLines.size() > 0 && this.parseNextTableRow(markdownLines)) {
            markdownLines.removeFirst();
        }
    }

    private String readOptions(String options) {
        String align;
        this.tableWidth = this.xSize();
        if (options.toLowerCase().contains("width")) {
            try {
                String widthString = Part.readOption(options, "width", "-1px");
                int w = Part.parseSize(this.xSize(), widthString);
                this.tableWidth = MathHelper.clip((int)w, (int)64, (int)this.xSize());
            }
            catch (NumberFormatException e) {
                return "Invalid width value! Must be a number";
            }
        }
        if ((align = Part.readOption(options, "align", "left")).toLowerCase().equals("center")) {
            this.align = GuiAlign.CENTER;
        } else if (align.toLowerCase().equals("right")) {
            this.align = GuiAlign.RIGHT;
        }
        String vertAlign = Part.readOption(options, "vertical_align", "top");
        if (vertAlign.toLowerCase().equals("middle")) {
            this.vertAlign = GuiAlign.Vertical.MIDDLE;
        } else if (vertAlign.toLowerCase().equals("bottom")) {
            this.vertAlign = GuiAlign.Vertical.BOTTOM;
        }
        this.renderCells = Part.readOption(options, "render", "true").equals("true");
        try {
            this.cellColour = 0xFF000000 | Part.readColour(Part.readOption(options, "cell_colour", "0x000000"));
        }
        catch (NumberFormatException e) {
            return "Invalid cell colour Value! Valid formats are 0xRRGGBB or #RRGGBB (hex) or Red,Green,Blue (RGB)";
        }
        try {
            this.headerColour = 0xFF000000 | Part.readColour(Part.readOption(options, "heading_colour", "0x00FFFF"));
        }
        catch (NumberFormatException e) {
            return "Invalid heading colour Value! Valid formats are 0xRRGGBB or #RRGGBB (hex) or Red,Green,Blue (RGB)";
        }
        return null;
    }

    private boolean checkDelimiter(String line) {
        String[] divs;
        LinkedList<ColumnData> awMaps = new LinkedList<ColumnData>();
        if ((line = line.trim()).length() < 2) {
            return false;
        }
        if (line.startsWith("|")) {
            line = line.substring(1);
        }
        block2: for (String div : divs = line.split("\\|")) {
            boolean leftColon = false;
            if ((div = div.trim()).length() == 0) {
                return false;
            }
            if (div.startsWith(":")) {
                leftColon = true;
                if ((div = div.substring(1)).length() == 0) {
                    return false;
                }
            }
            if (div.startsWith("n")) {
                boolean rightBinding = false;
                if (div.endsWith(":")) {
                    div = div.substring(0, div.length() - 1);
                    rightBinding = true;
                }
                try {
                    awMaps.add(new ColumnData(GuiAlign.fromBindings(leftColon, rightBinding), Integer.parseInt(div.substring(1)), true));
                    continue;
                }
                catch (Exception e) {
                    LogHelperBC.error("Error reading Delimiter with fixed column width. " + e.getMessage());
                    return false;
                }
            }
            for (int index = 0; index < div.length(); ++index) {
                char charAt = div.charAt(index);
                if (charAt != '-' && charAt != ' ' && charAt != ':') {
                    return false;
                }
                if (charAt == ' ' && index + 1 < div.length()) {
                    return false;
                }
                if (charAt != ' ' && charAt != ':' && index + 1 != div.length()) continue;
                awMaps.add(new ColumnData(GuiAlign.fromBindings(leftColon, charAt == ':'), Math.max(index, 1)));
                continue block2;
            }
        }
        this.columnData = awMaps;
        return true;
    }

    private boolean parseNextTableRow(LinkedList<String> markdownLines) {
        int builderYPos;
        String line = markdownLines.getFirst();
        if (line.startsWith("|") && line.length() > 1) {
            line = line.substring(1);
        }
        if (!line.contains("|")) {
            return false;
        }
        String[] cols = line.split("\\|");
        int colLeft = this.xPos();
        if (this.align == GuiAlign.CENTER) {
            colLeft += this.xSize() / 2 - this.tableWidth / 2;
        } else if (this.align == GuiAlign.RIGHT) {
            colLeft += this.xSize() - this.tableWidth;
        }
        int rowYPos = builderYPos = this.yPos() + this.ySize();
        int tableHeight = 0;
        int totalCols = this.columnData.size();
        LinkedList<LinkedList<Part>> row = new LinkedList<LinkedList<Part>>();
        LinkedList<Integer> rowCellHeights = new LinkedList<Integer>();
        this.partsRows.add(row);
        for (int colIndex = 0; colIndex < cols.length && colIndex < totalCols; ++colIndex) {
            String col = cols[colIndex];
            ColumnData data = this.columnData.get(colIndex);
            if (col.startsWith(" ") && col.length() > 1) {
                col = col.substring(1);
            }
            if (col.endsWith(" ") && col.length() > 1) {
                col = col.substring(0, col.length() - 1);
            }
            LinkedList<Part> cellParts = new LinkedList<Part>();
            row.add(cellParts);
            this.fontRenderer.func_78265_b();
            BCFontRenderer.setStileToggleMode(true);
            int nextPart = col.length();
            int xPos = colLeft;
            int maxYPos = builderYPos;
            block1: while (col.length() > 0) {
                for (IPartBuilder builder : GuiMarkdownElement.partBuilders) {
                    int i = builder.matches(col);
                    if (i == 0) {
                        builder.finalXPos = xPos;
                        builder.finalYPos = builderYPos;
                        int builderStartY = builderYPos;
                        col = builder.build(this.fontRenderer, col, nextPart, this.fontRenderer, this, cellParts, colLeft, colLeft + data.colWidth, xPos, builderYPos, maxYPos);
                        GuiMarkdownElement.profiler.endSection();
                        nextPart = col.length();
                        xPos = builder.finalXPos;
                        builderYPos = builder.finalYPos;
                        if (builderStartY + builder.builtHeight <= maxYPos) continue block1;
                        maxYPos = builderStartY + builder.builtHeight;
                        continue block1;
                    }
                    if (i <= 0 || i >= nextPart) continue;
                    nextPart = i;
                }
            }
            rowCellHeights.add(maxYPos - rowYPos);
            if (maxYPos > tableHeight) {
                tableHeight = maxYPos;
            }
            BCFontRenderer.setStileToggleMode(false);
            colLeft += data.colWidth;
        }
        if (this.renderCells) {
            tableHeight += 2;
        }
        this.rowHeights.add(tableHeight - rowYPos);
        this.cellHeights.add(rowCellHeights);
        if (tableHeight > this.maxYPos()) {
            this.setYSize(tableHeight - this.yPos());
        }
        return true;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        int tableXPos = this.xPos();
        if (this.align == GuiAlign.CENTER) {
            tableXPos += this.xSize() / 2 - this.tableWidth / 2;
        } else if (this.align == GuiAlign.RIGHT) {
            tableXPos += this.xSize() - this.tableWidth;
        }
        int renderYPos = this.yPos();
        int rowYPos = this.yPos();
        if (this.renderCells) {
            this.drawColouredRect(tableXPos, this.yPos(), this.tableWidth, 1.0, this.cellColour);
            rowYPos = renderYPos += 2;
        }
        for (int rowIndex = 0; rowIndex < this.partsRows.size(); ++rowIndex) {
            LinkedList<LinkedList<Part>> rowCells = this.partsRows.get(rowIndex);
            int prevHeight = 0;
            int colLeft = tableXPos;
            int rowHeight = this.rowHeights.get(rowIndex);
            if (this.renderCells) {
                if (rowIndex == 0 && this.headers) {
                    this.drawColouredRect(colLeft + 1, this.yPos() + 1, this.tableWidth - 1, rowHeight - 1, this.headerColour);
                }
                this.drawColouredRect(colLeft, this.yPos(), 1.0, this.ySize(), this.cellColour);
                colLeft += 2;
            }
            for (int colIndex = 0; colIndex < rowCells.size(); ++colIndex) {
                LinkedList<Part> cellParts = rowCells.get(colIndex);
                ColumnData data = this.columnData.get(colIndex);
                int cellHeight = this.cellHeights.get(rowIndex).get(colIndex);
                if (this.renderCells) {
                    cellHeight += 2;
                }
                int yOffset = this.vertAlign == GuiAlign.Vertical.MIDDLE ? (rowHeight - cellHeight) / 2 : (this.vertAlign == GuiAlign.Vertical.BOTTOM ? rowHeight - cellHeight : 0);
                int xPos = colLeft;
                this.fontRenderer.func_78265_b();
                BCFontRenderer.setStileToggleMode(true);
                int maxWidth = data.colWidth;
                int alignOffset = 0;
                for (int i = 0; i < cellParts.size(); ++i) {
                    Part part = cellParts.get(i);
                    if (xPos + part.width > colLeft + maxWidth) {
                        xPos = colLeft;
                        renderYPos += prevHeight;
                        prevHeight = 0;
                    }
                    if (xPos == colLeft && data.align != GuiAlign.LEFT) {
                        int width = 0;
                        for (int j = i; j < cellParts.size(); ++j) {
                            Part p = cellParts.get(j);
                            if (width + p.width > maxWidth) {
                                if (width != 0) break;
                                width = p.width;
                                break;
                            }
                            width += p.width;
                        }
                        alignOffset = data.align == GuiAlign.CENTER ? (maxWidth - width) / 2 : maxWidth - width;
                    }
                    part.lastXPos = xPos + alignOffset;
                    part.lastYPos = renderYPos;
                    part.render(this.fontRenderer, xPos + alignOffset, renderYPos + yOffset, mouseX, mouseY, (Integer)this.colourProvider.getColour(), this.shadow, partialTicks);
                    prevHeight = Math.max(part.height, prevHeight);
                    xPos += part.width;
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BCFontRenderer.setStileToggleMode(false);
                colLeft += data.colWidth;
                if (this.renderCells) {
                    colLeft += 4;
                    if (colIndex + 1 == rowCells.size()) {
                        this.drawColouredRect(tableXPos + this.tableWidth - 1, this.yPos(), 1.0, this.ySize(), this.cellColour);
                    } else {
                        this.drawColouredRect(colLeft - 2, this.yPos(), 1.0, this.ySize(), this.cellColour);
                    }
                }
                renderYPos = rowYPos;
            }
            renderYPos = rowYPos += rowHeight;
            if (!this.renderCells) continue;
            this.drawColouredRect(tableXPos, rowYPos - 2, this.tableWidth, 1.0, this.cellColour);
        }
    }

    public static class ColumnData {
        public int colOffset = 0;
        public int colWidth = 0;
        public int divN = 0;
        boolean fixedWidth = false;
        public GuiAlign align;

        public ColumnData(GuiAlign align, int divN) {
            this.divN = divN;
            this.align = align;
        }

        public ColumnData(GuiAlign align, int colWidth, boolean fixedWidth) {
            this.colWidth = colWidth;
            this.align = align;
            this.fixedWidth = fixedWidth;
        }
    }
}

