/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MarkerElement;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class TextElement
extends MDElementBase<TextElement> {
    private String text;
    public Supplier<Integer> colour = null;
    public boolean shadow = false;
    private double textScale;

    public TextElement(String text, int heading) {
        this.boundless = true;
        this.text = text;
        this.hasSubParts = true;
        if (heading == 0) {
            this.textScale = 1.0;
        } else {
            heading = 7 - heading;
            this.textScale = 1.0 + (double)heading / 3.0;
        }
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        if (layout.getWidth() < 5) {
            return;
        }
        this.toRemove.addAll(this.subParts);
        this.subParts.clear();
        double fHeight = (double)(this.fontRenderer.field_78288_b + 1) * this.textScale;
        String text = this.text;
        boolean newln = false;
        while (text.length() > 0) {
            int avalibleWidth = layout.getWidth() - layout.getCaretXOffset();
            int nextSplit = this.fontRenderer.func_78259_e(text, (int)Math.ceil((double)avalibleWidth / this.textScale));
            if (nextSplit == 0 && avalibleWidth == layout.getWidth()) {
                nextSplit = 1;
            }
            if (nextSplit == 0) {
                layout.newLine(0);
                MarkerElement marker = new MarkerElement(MarkerElement.Type.NEW_LINE);
                this.subParts.add(marker);
                newln = true;
                continue;
            }
            String nextPart = text.substring(0, nextSplit);
            nextPart = nextPart.replace("\n", "");
            if (newln && nextPart.length() > 1 && nextPart.startsWith(" ")) {
                nextPart = nextPart.substring(1);
            }
            text = text.substring(nextSplit);
            double nextWidth = (double)this.fontRenderer.func_78256_a(nextPart) * this.textScale;
            TextElementPart part = new TextElementPart(nextPart, this.textScale, this.shadow, this.colour);
            part.setSize((int)Math.ceil(nextWidth), (int)Math.ceil(fHeight));
            this.addChild(part);
            this.subParts.add(part);
            part.layoutElement(layout, lineElement);
            newln = false;
        }
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.fontRenderer.func_78265_b();
        BCFontRenderer.setStileToggleMode(true);
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        BCFontRenderer.setStileToggleMode(false);
        this.fontRenderer.func_78265_b();
    }

    private static class TextElementPart
    extends MDElementBase<TextElementPart> {
        private final String text;
        private final double scale;
        private boolean shadow;
        private Supplier<Integer> colour;

        public TextElementPart(String text, double scale, boolean shadow, Supplier<Integer> colour) {
            this.text = text;
            this.scale = scale;
            this.shadow = shadow;
            this.colour = colour;
        }

        @Override
        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            if (this.scale > 1.0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)this.xPos(), (float)this.yPos(), (float)0.0f);
                GlStateManager.func_179139_a((double)this.scale, (double)this.scale, (double)1.0);
                this.fontRenderer.func_175065_a(this.text, 0.0f, 0.0f, this.colour.get(), this.shadow);
                GlStateManager.func_179121_F();
            } else {
                this.fontRenderer.func_175065_a(this.text, this.xPos(), this.yPos(), this.colour.get(), this.shadow);
            }
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }
}

