/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.utils.BCProfiler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ProcessHandlerClient {
    private static List<IProcess> processes = new ArrayList<IProcess>();
    private static List<IProcess> newProcesses = new ArrayList<IProcess>();
    private static List<IProcess> persistentProcesses = new ArrayList<IProcess>();
    private static List<IProcess> newPersistentProcesses = new ArrayList<IProcess>();
    private static final List<Runnable> syncTasks = new ArrayList<Runnable>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ProcessHandlerClient());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            IProcess process;
            BCProfiler.TICK.start("process_handler");
            ProcessHandlerClient.sync();
            Iterator<IProcess> i = processes.iterator();
            while (i.hasNext()) {
                process = i.next();
                if (process.isDead()) {
                    i.remove();
                    continue;
                }
                process.updateProcess();
            }
            if (!newProcesses.isEmpty()) {
                processes.addAll(newProcesses);
                newProcesses.clear();
            }
            i = persistentProcesses.iterator();
            while (i.hasNext()) {
                process = i.next();
                if (process.isDead()) {
                    i.remove();
                    continue;
                }
                process.updateProcess();
            }
            if (!newPersistentProcesses.isEmpty()) {
                persistentProcesses.addAll(newPersistentProcesses);
                newPersistentProcesses.clear();
            }
            BCProfiler.TICK.stop();
        }
    }

    @SubscribeEvent
    public void onWorldClose(WorldEvent.Unload event) {
        processes.clear();
        newProcesses.clear();
    }

    public static void addProcess(IProcess process) {
        newProcesses.add(process);
    }

    public static void addPersistentProcess(IProcess process) {
        newPersistentProcesses.add(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync() {
        if (!syncTasks.isEmpty()) {
            ArrayList<Runnable> tasks;
            List<Runnable> list = syncTasks;
            synchronized (list) {
                tasks = new ArrayList<Runnable>(syncTasks);
                syncTasks.removeAll(tasks);
            }
            for (Runnable task : tasks) {
                task.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncTask(Runnable task) {
        List<Runnable> list = syncTasks;
        synchronized (list) {
            syncTasks.add(task);
        }
    }
}

