/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.XUMachineGenerators;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.machine.BlockMachine;
import com.rwtema.extrautils2.machine.TileMachine;
import com.rwtema.extrautils2.network.SpecialChat;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.IPowerSubType;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.render.IVertexBuffer;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.tile.tesr.ITESRHook;
import com.rwtema.extrautils2.transfernodes.FacingHelper;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class TileRainbowGenerator
extends TilePower
implements ITickable,
ITESRHook,
IPowerSubType {
    public static final int perTick = 25000000;
    public static final Machine[] GENERATORS = new Machine[]{XUMachineGenerators.CULINARY_GENERATOR, XUMachineGenerators.DEATH_GENERATOR, XUMachineGenerators.DRAGON_GENERATOR, XUMachineGenerators.ENCHANT_GENERATOR, XUMachineGenerators.ENDER_GENERATOR, XUMachineGenerators.FURNACE_GENERATOR, XUMachineGenerators.ICE_GENERATOR, XUMachineGenerators.LAVA_GENERATOR, XUMachineGenerators.NETHERSTAR_GENERATOR, XUMachineGenerators.OVERCLOCK_GENERATOR, XUMachineGenerators.PINK_GENERATOR, XUMachineGenerators.POTION_GENERATOR, XUMachineGenerators.REDSTONE_GENERATOR, XUMachineGenerators.SLIME_GENERATOR, XUMachineGenerators.SURVIVALIST_GENERATOR, XUMachineGenerators.TNT_GENERATOR};
    private static final ResourceLocation rainbowGenerators = new ResourceLocation("extrautils2", "rainbowGenerators");
    static final Collection<ResourceLocation> rainbowGeneratorsCollection = ImmutableList.of((Object)rainbowGenerators);
    public boolean providing;
    private int extractBuffer = 0;
    public IEnergyStorage INFINISTORAGE = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!TileRainbowGenerator.this.providing || maxExtract <= 0) {
                return 0;
            }
            int toExtract = Math.min(maxExtract, TileRainbowGenerator.this.extractBuffer);
            if (!simulate) {
                TileRainbowGenerator.this.extractBuffer = TileRainbowGenerator.this.extractBuffer - toExtract;
            }
            return toExtract;
        }

        public int getEnergyStored() {
            return TileRainbowGenerator.this.providing ? 25000000 : 0;
        }

        public int getMaxEnergyStored() {
            return 25000000;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    };

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        IPower iPower;
        Collection s;
        if (worldIn.field_72995_K) {
            return true;
        }
        PowerManager.PowerFreq freq = PowerManager.instance.getPowerFreqRaw(this.frequency);
        if (freq == null || (s = freq.getSubTypes(rainbowGenerators)) == null) {
            return true;
        }
        int n = 1;
        Iterator iterator = s.iterator();
        while (iterator.hasNext() && (iPower = (IPower)iterator.next()) != this) {
            ++n;
        }
        ArrayList<Machine> missingGenerators = new ArrayList<Machine>();
        ArrayList<Machine> unPoweredGenerators = new ArrayList<Machine>();
        TObjectIntHashMap numMissingGenerators = new TObjectIntHashMap();
        block1: for (Machine generator : GENERATORS) {
            Collection subTypes = freq.getSubTypes(generator.location);
            if (subTypes == null) {
                missingGenerators.add(generator);
                continue;
            }
            int k = 0;
            for (TileMachine subType : subTypes) {
                if (!subType.isProcessing() || ++k < n) continue;
                continue block1;
            }
            numMissingGenerators.put((Object)generator, n - k);
            unPoweredGenerators.add(generator);
        }
        if (missingGenerators.isEmpty() && unPoweredGenerators.isEmpty()) {
            SpecialChat.sendChat(playerIn, Lang.chat("The Generator Spectrum is complete!", new Object[0]).func_150258_a("\n").func_150257_a((ITextComponent)Lang.chat("Sending %s RF energy per tick", StringHelper.format(25000000))));
        } else {
            BlockMachine blockMachine = (BlockMachine)XU2Entries.machineEntry.value;
            ITextComponent textComponent = null;
            if (!missingGenerators.isEmpty()) {
                textComponent = Lang.chat("%s generators are missing:", missingGenerators.size()).func_150258_a("\n");
                for (int i = 0; i < missingGenerators.size(); ++i) {
                    Machine missingGenerator = (Machine)missingGenerators.get(i);
                    if (i > 0) {
                        textComponent = textComponent.func_150258_a("\n-");
                    }
                    textComponent = textComponent.func_150258_a("-").func_150257_a(blockMachine.createStack(missingGenerator).func_151000_E());
                }
            }
            if (!unPoweredGenerators.isEmpty()) {
                ITextComponent t = Lang.chat("%s generators are not running:", unPoweredGenerators.size()).func_150258_a("\n");
                textComponent = textComponent == null ? t : textComponent.func_150258_a("\n").func_150257_a(t);
                for (int i = 0; i < unPoweredGenerators.size(); ++i) {
                    Machine unPoweredGenerator = (Machine)unPoweredGenerators.get(i);
                    if (i > 0) {
                        textComponent = textComponent.func_150258_a("\n");
                    }
                    textComponent = textComponent.func_150258_a("-").func_150257_a(blockMachine.createStack(unPoweredGenerator).func_151000_E());
                    if (n <= 1) continue;
                    textComponent = textComponent.func_150258_a(" (x").func_150258_a(Integer.toString(numMissingGenerators.get((Object)unPoweredGenerator))).func_150258_a(")");
                }
            }
            SpecialChat.sendChat(playerIn, textComponent);
        }
        return true;
    }

    @Override
    public float getPower() {
        return Float.NaN;
    }

    @Override
    public void onPowerChanged() {
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.extractBuffer = 0;
        if (!this.active) {
            if (this.providing) {
                this.markForUpdate();
            }
            this.providing = false;
        } else {
            Collection subTypes;
            IPower iPower;
            Collection s;
            PowerManager.PowerFreq freq = PowerManager.instance.getPowerFreqRaw(this.frequency);
            if (freq == null || (s = freq.getSubTypes(rainbowGenerators)) == null) {
                if (this.providing) {
                    this.markForUpdate();
                }
                this.providing = false;
                return;
            }
            int n = 1;
            Machine[] machineArray = s.iterator();
            while (machineArray.hasNext() && (iPower = (IPower)machineArray.next()) != this) {
                ++n;
            }
            for (Machine generator : GENERATORS) {
                subTypes = freq.getSubTypes(generator.location);
                if (subTypes != null && subTypes.size() >= n) continue;
                if (this.providing) {
                    this.markForUpdate();
                }
                this.providing = false;
                return;
            }
            block2: for (Machine generator : GENERATORS) {
                subTypes = freq.getSubTypes(generator.location);
                int k = 0;
                if (subTypes != null) {
                    for (TileMachine subType : subTypes) {
                        if (!subType.isProcessing() || ++k < n) continue;
                        continue block2;
                    }
                }
                if (this.providing) {
                    this.markForUpdate();
                }
                this.providing = false;
                return;
            }
            if (!this.providing) {
                this.markForUpdate();
            }
            this.providing = true;
            this.extractBuffer = 25000000;
            block4: for (int pass = 0; pass < 2; ++pass) {
                for (EnumFacing facing : FacingHelper.randOrders[this.field_145850_b.field_73012_v.nextInt(12)]) {
                    IEnergyStorage storage;
                    TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                    if (tileEntity == null || (storage = CapGetter.energyReceiver.getInterface((ICapabilityProvider)tileEntity, facing.func_176734_d())) == null || !storage.canReceive()) continue;
                    if (pass == 0) {
                        int i = storage.receiveEnergy(this.extractBuffer, true);
                        this.extractBuffer -= storage.receiveEnergy(i >> 2 | 1, false);
                    } else {
                        this.extractBuffer -= storage.receiveEnergy(this.extractBuffer, false);
                    }
                    if (this.extractBuffer > 0) continue;
                    this.extractBuffer = 0;
                    break block4;
                }
            }
        }
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return this.INFINISTORAGE;
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        super.addToDescriptionPacket(packet);
        packet.writeBoolean(this.providing);
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        super.handleDescriptionPacket(packet);
        this.providing = packet.readBoolean();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 && this.providing;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isGlobalRenderer() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IBlockAccess world, BlockPos pos, double x, double y, double z, float partialTicks, int destroyStage, IVertexBuffer renderer, BlockRendererDispatcher blockRenderer) {
        if (this.providing) {
            Vector3f[] vecs = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
            Random rand = new Random(425L + (long)pos.hashCode());
            Matrix4f matrix = new Matrix4f();
            matrix.setIdentity();
            Vector4f b = new Vector4f();
            Vector4f c = new Vector4f();
            Vector4f d = new Vector4f();
            for (int i = 0; i < 32; ++i) {
                for (Vector3f vec : vecs) {
                    QuadHelper.rotate((float)Math.PI * 2 * rand.nextFloat() + MCTimer.renderTimer / 360.0f, vec, matrix, matrix);
                }
                float r = (1.0f + rand.nextFloat() * 2.5f) * 5.0f;
                QuadHelper.rotate(MCTimer.renderTimer / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f), matrix, matrix);
                b.set(0.0f, 0.126f * r, 0.5f * r, 1.0f);
                c.set(0.0f, -0.126f * r, 0.5f * r, 1.0f);
                d.set(0.0f, 0.0f, 0.6f * r, 1.0f);
                matrix.transform((Tuple4f)b);
                matrix.transform((Tuple4f)c);
                matrix.transform((Tuple4f)d);
                int rgb = Color.HSBtoRGB((float)i / 16.0f, 1.0f, 1.0f);
                float col_r = ColorHelper.getRF(rgb);
                float col_g = ColorHelper.getGF(rgb);
                float col_b = ColorHelper.getBF(rgb);
                renderer.pos((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f).color(col_r, col_g, col_b, 0.9f).endVertex();
                renderer.pos((float)pos.func_177958_n() + 0.5f + b.x, (float)pos.func_177956_o() + 0.5f + b.y, (float)pos.func_177952_p() + 0.5f + b.z).color(col_r, col_g, col_b, 0.01f).endVertex();
                renderer.pos((float)pos.func_177958_n() + 0.5f + d.x, (float)pos.func_177956_o() + 0.5f + d.y, (float)pos.func_177952_p() + 0.5f + d.z).color(col_r, col_g, col_b, 0.01f).endVertex();
                renderer.pos((float)pos.func_177958_n() + 0.5f + c.x, (float)pos.func_177956_o() + 0.5f + c.y, (float)pos.func_177952_p() + 0.5f + c.z).color(col_r, col_g, col_b, 0.01f).endVertex();
            }
        }
    }

    @Override
    public void preRender(int destroyStage) {
        RenderHelper.func_74518_a();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179132_a((boolean)false);
    }

    @Override
    public void postRender(int destroyStage) {
        GlStateManager.func_179098_w();
        RenderHelper.func_74519_b();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getDrawMode() {
        return 7;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public VertexFormat getVertexFormat() {
        return DefaultVertexFormats.field_181706_f;
    }

    @Override
    public Collection<ResourceLocation> getTypes() {
        return rainbowGeneratorsCollection;
    }

    static {
        MinecraftForge.EVENT_BUS.register(TileRainbowGenerator.class);
    }
}

