/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.compatibility;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.itemhandler.IItemHandlerCompat;
import com.rwtema.extrautils2.itemhandler.XUCrafter;
import com.rwtema.extrautils2.machine.MechEnchantmentRecipe;
import com.rwtema.extrautils2.utils.datastructures.ArrayAccess;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.IItemHandler;

public class CompatHelper {
    public static void setSlot(Slot slot, EntityPlayer par1EntityPlayer, ItemStack itemstack1) {
        slot.func_190901_a(par1EntityPlayer, itemstack1);
    }

    public static boolean canPlaceBlockHere(World world, Block block, BlockPos loc, boolean p_175716_3_, EnumFacing side, Entity entity, ItemStack pickBlock1) {
        return world.func_190527_a(block, loc, p_175716_3_, side, entity);
    }

    public static boolean activateBlock(Block block, World world, BlockPos newPos, IBlockState blockState, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return block.func_180639_a(world, newPos, blockState, player, hand, facing, hitX, hitY, hitZ);
    }

    public static BlockPos getCenterBlock(ChunkPos p, int y) {
        return p.func_180331_a(8, y, 8);
    }

    public static EnumEnchantmentType addEnchantmentType(String name) {
        return EnumHelper.addEnchantmentType((String)name, item -> false);
    }

    public static void notifyNeighborsOfStateChange(World worldIn, BlockPos pos, Block blockType) {
        worldIn.func_175685_c(pos, blockType, true);
    }

    public static void registerEntity(Class<? extends Entity> clazz, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, String name, int id) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("extrautils2", name), clazz, (String)name, (int)id, (Object)ExtraUtils2.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public static <E> ArrayAccess<E> getArray10List11(List<E> list) {
        return new ArrayAccess.WrapList<E>(list);
    }

    public static Set<BiomeDictionary.Type> getTypesForBiome(Biome biome) {
        return BiomeDictionary.getTypes((Biome)biome);
    }

    public static EnumActionResult interactOn(EntityPlayer player, Entity p_190775_1_, EnumHand p_190775_2_, ItemStack stack) {
        return player.func_190775_a(p_190775_1_, p_190775_2_);
    }

    public static void addPotionEffect(World world, BlockPos blockPos, PotionType invisibility) {
        world.func_175718_b(2002, blockPos, PotionUtils.func_185183_a((PotionType)invisibility));
    }

    public static Class<? extends Enum<?>> getBannerEnumClass() {
        return BannerPattern.class;
    }

    @Nonnull
    public static ChunkGeneratorEnd getChunkProviderEnd(WorldServer world) {
        return new ChunkGeneratorEnd((World)world, true, world.func_72905_C(), BlockPos.field_177992_a){

            public Chunk func_185932_a(int x, int z) {
                Chunk chunk = super.func_185932_a(x, z);
                for (ExtendedBlockStorage extendedBlockStorage : chunk.func_76587_i()) {
                    if (extendedBlockStorage == null || extendedBlockStorage.func_76661_k() != null) continue;
                    extendedBlockStorage.func_76659_c(new NibbleArray());
                }
                return chunk;
            }
        };
    }

    public static boolean BiomeHasType(Biome biome, BiomeDictionary.Type type) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type);
    }

    public static Event.Result canSpawnEvent(WorldServer worldServerIn, EntityLiving entityliving, float x, float y, float z) {
        return ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)worldServerIn, (float)x, (float)y, (float)z, (boolean)false);
    }

    public static boolean isBiomeOfType(Biome biome, BiomeDictionary.Type type) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type);
    }

    public static float getBrightness(Entity entity) {
        return entity.func_70013_c();
    }

    public static List<ItemStack> getRemainingItems(XUCrafter crafter, World world) {
        return CraftingManager.func_180303_b((InventoryCrafting)crafter, (World)world);
    }

    public static void removeIncompatibleEnchantments(List<MechEnchantmentRecipe.EnchantmentEntry> list1, Enchantment finalEnchantment) {
        list1.removeIf(enchantmentEntry -> !finalEnchantment.func_191560_c(enchantmentEntry.enchantment));
    }

    public static boolean hasSky(World world) {
        return world.field_73011_w.func_191066_m();
    }

    public static String getName(String id) {
        EntityEntry value = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
        return I18n.func_74838_a((String)(value != null ? value.getName() : "entity.generic.name"));
    }

    public static IItemHandlerCompat wrapItemHandlerCompat(final IItemHandler handler) {
        if (handler instanceof IItemHandlerCompat) {
            return (IItemHandlerCompat)handler;
        }
        return new IItemHandlerCompat(){

            @Override
            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }

            @Override
            public int getSlots() {
                return handler.getSlots();
            }

            @Override
            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            @Override
            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return handler.insertItem(slot, stack, simulate);
            }

            @Override
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(slot, amount, simulate);
            }
        };
    }

    public <E> NonNullList<E> toNonNullList(List<E> list) {
        if (list instanceof NonNullList) {
            return (NonNullList)list;
        }
        NonNullList list1 = NonNullList.func_191196_a();
        list1.addAll(list);
        return list1;
    }
}

