/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.tools;

import com.direwolf20.buildinggadgets.Config;
import com.direwolf20.buildinggadgets.ModBlocks;
import com.direwolf20.buildinggadgets.items.BuildingTool;
import com.direwolf20.buildinggadgets.items.CopyPasteTool;
import com.direwolf20.buildinggadgets.items.ExchangerTool;
import com.direwolf20.buildinggadgets.items.FakeBuilderWorld;
import com.direwolf20.buildinggadgets.tools.BlockMap;
import com.direwolf20.buildinggadgets.tools.BuildingModes;
import com.direwolf20.buildinggadgets.tools.ExchangingModes;
import com.direwolf20.buildinggadgets.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.tools.PasteToolBufferBuilder;
import com.direwolf20.buildinggadgets.tools.ToolDireBuffer;
import com.direwolf20.buildinggadgets.tools.VectorTools;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.lwjgl.opengl.GL14;

public class ToolRenders {
    private static final FakeBuilderWorld fakeWorld = new FakeBuilderWorld();

    public static void renderBuilderOverlay(RenderWorldLastEvent evt, EntityPlayer player, ItemStack stack) {
        RayTraceResult lookingAt = VectorTools.getLookingAt(player);
        IBlockState state = Blocks.field_150350_a.func_176223_P();
        ArrayList<BlockPos> coordinates = GadgetUtils.getAnchor(stack);
        if (lookingAt != null || coordinates.size() > 0) {
            World world = player.field_70170_p;
            IBlockState startBlock = Blocks.field_150350_a.func_176223_P();
            if (lookingAt != null) {
                startBlock = world.func_180495_p(lookingAt.func_178782_a());
            }
            if (startBlock != ModBlocks.effectBlock.func_176223_P()) {
                ItemStack heldItem = player.func_184614_ca();
                if (!(heldItem.func_77973_b() instanceof BuildingTool) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof BuildingTool)) {
                    return;
                }
                IBlockState renderBlockState = GadgetUtils.getToolBlock(heldItem);
                Minecraft mc = Minecraft.func_71410_x();
                mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                if (renderBlockState == Blocks.field_150350_a.func_176223_P()) {
                    return;
                }
                if (coordinates.size() == 0) {
                    coordinates = BuildingModes.getBuildOrders(world, player, lookingAt.func_178782_a(), lookingAt.field_178784_b, heldItem);
                }
                ItemStack itemStack = renderBlockState.func_177230_c().canSilkHarvest(world, new BlockPos(0, 0, 0), renderBlockState, player) ? InventoryManipulation.getSilkTouchDrop(renderBlockState) : renderBlockState.func_177230_c().getPickBlock(renderBlockState, null, world, new BlockPos(0, 0, 0), player);
                int hasBlocks = InventoryManipulation.countItem(itemStack, player);
                hasBlocks += InventoryManipulation.countPaste(player);
                int hasEnergy = 0;
                hasEnergy = Config.poweredByFE ? ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() : stack.func_77958_k() - stack.func_77952_i();
                if (player.field_71075_bZ.field_75098_d) {
                    hasEnergy = 1000000;
                }
                BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
                BlockRenderLayer origLayer = MinecraftForgeClient.getRenderLayer();
                HashSet<BlockPos> coords = new HashSet<BlockPos>(coordinates);
                fakeWorld.setWorldAndState(player.field_70170_p, renderBlockState, coords);
                double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)evt.getPartialTicks();
                double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)evt.getPartialTicks();
                double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)evt.getPartialTicks();
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)32771, (int)32772);
                ArrayList<BlockPos> sortedCoordinates = BuildingModes.sortByDistance(coordinates, player);
                for (BlockPos coordinate : sortedCoordinates) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
                    GlStateManager.func_179109_b((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
                    GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
                    if (fakeWorld.func_175624_G() != WorldType.field_180272_g) {
                        try {
                            state = renderBlockState.func_185899_b((IBlockAccess)fakeWorld, coordinate);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    dispatcher.func_175016_a(state, 1.0f);
                    GlStateManager.func_179121_F();
                }
                for (BlockPos coordinate : coordinates) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
                    GlStateManager.func_179109_b((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)-0.005f, (float)-0.005f, (float)0.005f);
                    GlStateManager.func_179152_a((float)1.01f, (float)1.01f, (float)1.01f);
                    GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
                    hasEnergy = Config.poweredByFE ? (hasEnergy -= Config.energyCostBuilder) : --hasEnergy;
                    if (--hasBlocks < 0 || hasEnergy < 0) {
                        dispatcher.func_175016_a(Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.RED), 1.0f);
                    }
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179112_b((int)770, (int)771);
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)origLayer);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
    }

    public static void renderExchangerOverlay(RenderWorldLastEvent evt, EntityPlayer player, ItemStack stack) {
        int range = GadgetUtils.getToolRange(stack);
        ExchangerTool.toolModes mode = ExchangerTool.getToolMode(stack);
        RayTraceResult lookingAt = VectorTools.getLookingAt(player);
        IBlockState state = Blocks.field_150350_a.func_176223_P();
        ArrayList<BlockPos> coordinates = GadgetUtils.getAnchor(stack);
        if (lookingAt != null || coordinates.size() > 0) {
            World world = player.field_70170_p;
            IBlockState startBlock = Blocks.field_150350_a.func_176223_P();
            if (lookingAt != null) {
                startBlock = world.func_180495_p(lookingAt.func_178782_a());
            }
            if (startBlock != ModBlocks.effectBlock.func_176223_P()) {
                ItemStack heldItem = player.func_184614_ca();
                if (!(heldItem.func_77973_b() instanceof ExchangerTool) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof ExchangerTool)) {
                    return;
                }
                IBlockState renderBlockState = GadgetUtils.getToolBlock(heldItem);
                Minecraft mc = Minecraft.func_71410_x();
                mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                if (renderBlockState == Blocks.field_150350_a.func_176223_P()) {
                    return;
                }
                if (coordinates.size() == 0) {
                    coordinates = ExchangingModes.getBuildOrders(world, player, lookingAt.func_178782_a(), lookingAt.field_178784_b, stack);
                }
                ItemStack itemStack = renderBlockState.func_177230_c().canSilkHarvest(world, new BlockPos(0, 0, 0), renderBlockState, player) ? InventoryManipulation.getSilkTouchDrop(renderBlockState) : renderBlockState.func_177230_c().getPickBlock(renderBlockState, null, world, new BlockPos(0, 0, 0), player);
                int hasBlocks = InventoryManipulation.countItem(itemStack, player);
                hasBlocks += InventoryManipulation.countPaste(player);
                int hasEnergy = 0;
                hasEnergy = Config.poweredByFE ? ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() : stack.func_77958_k() - stack.func_77952_i();
                if (player.field_71075_bZ.field_75098_d) {
                    hasEnergy = 1000000;
                }
                BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
                BlockRenderLayer origLayer = MinecraftForgeClient.getRenderLayer();
                HashSet<BlockPos> coords = new HashSet<BlockPos>(coordinates);
                fakeWorld.setWorldAndState(player.field_70170_p, renderBlockState, coords);
                double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)evt.getPartialTicks();
                double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)evt.getPartialTicks();
                double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)evt.getPartialTicks();
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)32771, (int)32772);
                for (BlockPos coordinate : coordinates) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
                    GlStateManager.func_179109_b((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)-0.005f, (float)-0.005f, (float)0.005f);
                    GlStateManager.func_179152_a((float)1.01f, (float)1.01f, (float)1.01f);
                    GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
                    if (fakeWorld.func_175624_G() != WorldType.field_180272_g) {
                        try {
                            state = renderBlockState.func_185899_b((IBlockAccess)fakeWorld, coordinate);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    dispatcher.func_175016_a(state, 1.0f);
                    GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    dispatcher.func_175016_a(Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.WHITE), 1.0f);
                    GlStateManager.func_179121_F();
                }
                for (BlockPos coordinate : coordinates) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
                    GlStateManager.func_179109_b((float)coordinate.func_177958_n(), (float)coordinate.func_177956_o(), (float)coordinate.func_177952_p());
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)-0.01f, (float)-0.01f, (float)0.01f);
                    GlStateManager.func_179152_a((float)1.02f, (float)1.02f, (float)1.02f);
                    GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
                    hasEnergy = Config.poweredByFE ? (hasEnergy -= Config.energyCostExchanger) : (hasEnergy -= 2);
                    if (--hasBlocks < 0 || hasEnergy < 0) {
                        dispatcher.func_175016_a(Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.RED), 1.0f);
                    }
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179112_b((int)770, (int)771);
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)origLayer);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
    }

    public static void renderPasteOverlay(RenderWorldLastEvent evt, EntityPlayer player, ItemStack stack) {
        String UUID2 = CopyPasteTool.getUUID(stack);
        World world = player.field_70170_p;
        if (CopyPasteTool.getToolMode(stack) == CopyPasteTool.toolModes.Paste) {
            ToolDireBuffer toolDireBuffer;
            BlockPos startPos = CopyPasteTool.getAnchor(stack);
            if (startPos == null) {
                startPos = VectorTools.getPosLookingAt(player);
                if (startPos == null) {
                    return;
                }
                startPos = startPos.func_177984_a();
            }
            if ((toolDireBuffer = PasteToolBufferBuilder.getBufferFromMap(UUID2)) == null) {
                return;
            }
            ArrayList<BlockMap> blockMapList = CopyPasteTool.getBlockMapList(PasteToolBufferBuilder.getTagFromUUID(UUID2));
            if (toolDireBuffer.func_178989_h() == 0 || blockMapList.size() == 0) {
                return;
            }
            IBlockState startBlock = world.func_180495_p(startPos);
            if (startBlock == ModBlocks.effectBlock.func_176223_P()) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)evt.getPartialTicks();
            double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)evt.getPartialTicks();
            double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)evt.getPartialTicks();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)32771, (int)32772);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            GlStateManager.func_179109_b((float)startPos.func_177958_n(), (float)startPos.func_177956_o(), (float)startPos.func_177952_p());
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
            GlStateManager.func_179109_b((float)5.0E-4f, (float)5.0E-4f, (float)-5.0E-4f);
            GlStateManager.func_179152_a((float)0.999f, (float)0.999f, (float)0.999f);
            PasteToolBufferBuilder.draw(player, doubleX, doubleY, doubleZ, startPos, UUID2);
            GlStateManager.func_179121_F();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        } else {
            BlockPos startPos = CopyPasteTool.getStartPos(stack);
            BlockPos endPos = CopyPasteTool.getEndPos(stack);
            if (startPos == null || endPos == null) {
                return;
            }
            ArrayList<BlockMap> blockMapList = CopyPasteTool.getBlockMapList(PasteToolBufferBuilder.getTagFromUUID(UUID2));
            if (blockMapList.size() == 0) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)evt.getPartialTicks();
            double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)evt.getPartialTicks();
            double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)evt.getPartialTicks();
            int x = startPos.func_177958_n() <= endPos.func_177958_n() ? startPos.func_177958_n() : endPos.func_177958_n();
            int y = startPos.func_177956_o() <= endPos.func_177956_o() ? startPos.func_177956_o() : endPos.func_177956_o();
            int z = startPos.func_177952_p() <= endPos.func_177952_p() ? startPos.func_177952_p() : endPos.func_177952_p();
            int dx = startPos.func_177958_n() > endPos.func_177958_n() ? startPos.func_177958_n() + 1 : endPos.func_177958_n() + 1;
            int dy = startPos.func_177956_o() > endPos.func_177956_o() ? startPos.func_177956_o() + 1 : endPos.func_177956_o() + 1;
            int dz = startPos.func_177952_p() > endPos.func_177952_p() ? startPos.func_177952_p() + 1 : endPos.func_177952_p() + 1;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            ToolRenders.renderBox(tessellator, bufferbuilder, x, y, z, dx, dy, dz, 255, 223, 127);
            GlStateManager.func_187441_d((float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
    }

    private static void renderBox(Tessellator tessellator, BufferBuilder bufferBuilder, double startX, double startY, double startZ, double endX, double endY, double endZ, int R, int G, int B) {
        GlStateManager.func_187441_d((float)2.0f);
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181666_a((float)G, (float)G, (float)G, 0.0f).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181669_b(G, B, B, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, startZ).func_181669_b(B, B, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181669_b(B, G, B, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(startX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, endZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, endY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181669_b(G, G, G, R).func_181675_d();
        bufferBuilder.func_181662_b(endX, startY, startZ).func_181666_a((float)G, (float)G, (float)G, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
    }
}

