/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.tools;

import com.direwolf20.buildinggadgets.items.CopyPasteTool;
import com.direwolf20.buildinggadgets.tools.BlockMap;
import com.direwolf20.buildinggadgets.tools.ToolDireBuffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PasteToolBufferBuilder {
    private static Map<String, NBTTagCompound> tagMap = new HashMap<String, NBTTagCompound>();
    private static Map<String, ToolDireBuffer> bufferMap = new HashMap<String, ToolDireBuffer>();

    public static int getCopyCounter(String UUID2) {
        if (tagMap.containsKey(UUID2)) {
            return tagMap.get(UUID2).func_74762_e("copycounter");
        }
        return -1;
    }

    public static void clearMaps() {
        tagMap = new HashMap<String, NBTTagCompound>();
        bufferMap = new HashMap<String, ToolDireBuffer>();
    }

    public static void addToMap(String UUID2, NBTTagCompound tag) {
        tagMap.put(UUID2, tag);
    }

    public static NBTTagCompound getTagFromUUID(String UUID2) {
        if (tagMap.containsKey(UUID2)) {
            return tagMap.get(UUID2);
        }
        return null;
    }

    public static ToolDireBuffer getBufferFromMap(String UUID2) {
        if (bufferMap.containsKey(UUID2)) {
            return bufferMap.get(UUID2);
        }
        return null;
    }

    public static void addMapToBuffer(String UUID2) {
        long time = System.nanoTime();
        ArrayList<BlockMap> blockMapList = CopyPasteTool.getBlockMapList(tagMap.get(UUID2));
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        ToolDireBuffer bufferBuilder = new ToolDireBuffer(0x200000);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BlockMap blockMap : blockMapList) {
            IBlockState renderBlockState = blockMap.state;
            IBakedModel model = dispatcher.func_184389_a(renderBlockState);
            dispatcher.func_175019_b().func_187497_c((IBlockAccess)Minecraft.func_71410_x().field_71441_e, model, renderBlockState, new BlockPos(blockMap.xOffset, blockMap.yOffset, blockMap.zOffset), (BufferBuilder)bufferBuilder, false, 0L);
        }
        bufferBuilder.func_178977_d();
        bufferMap.put(UUID2, bufferBuilder);
        System.out.printf("Created %d Vertexes for %d blocks in %.2f ms%n", bufferBuilder.func_178989_h(), blockMapList.size(), (double)(System.nanoTime() - time) * 1.0E-6);
    }

    public static void draw(EntityPlayer player, double x, double y, double z, BlockPos startPos, String UUID2) {
        long time = System.nanoTime();
        ToolDireBuffer bufferBuilder = bufferMap.get(UUID2);
        bufferBuilder.func_181674_a((float)(x - (double)startPos.func_177958_n()), (float)(y + (double)player.func_70047_e() - (double)startPos.func_177956_o()), (float)(z - (double)startPos.func_177952_p()));
        if (bufferBuilder.func_178989_h() > 0) {
            VertexFormat vertexformat = bufferBuilder.func_178973_g();
            int i = vertexformat.func_177338_f();
            ByteBuffer bytebuffer = bufferBuilder.func_178966_f();
            List list = vertexformat.func_177343_g();
            for (int j = 0; j < list.size(); ++j) {
                VertexFormatElement vertexformatelement = (VertexFormatElement)list.get(j);
                VertexFormatElement.EnumUsage vertexformatelement$enumusage = vertexformatelement.func_177375_c();
                int k = vertexformatelement.func_177367_b().func_177397_c();
                int l = vertexformatelement.func_177369_e();
                bytebuffer.position(vertexformat.func_181720_d(j));
                vertexformatelement.func_177375_c().preDraw(vertexformat, j, i, bytebuffer);
            }
            GlStateManager.func_187439_f((int)bufferBuilder.func_178979_i(), (int)0, (int)bufferBuilder.func_178989_h());
            int j1 = list.size();
            for (int i1 = 0; i1 < j1; ++i1) {
                VertexFormatElement vertexformatelement1 = (VertexFormatElement)list.get(i1);
                VertexFormatElement.EnumUsage vertexformatelement$enumusage1 = vertexformatelement1.func_177375_c();
                int k1 = vertexformatelement1.func_177369_e();
                vertexformatelement1.func_177375_c().postDraw(vertexformat, i1, i, bytebuffer);
            }
        }
    }

    public static boolean isUpdateNeeded(String UUID2, ItemStack stack) {
        return CopyPasteTool.getCopyCounter(stack) != PasteToolBufferBuilder.getCopyCounter(UUID2) || PasteToolBufferBuilder.getTagFromUUID(UUID2) == null;
    }
}

