/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.tools;

import com.direwolf20.buildinggadgets.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.tools.UniqueItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public class BlockMapIntState {
    public Map<Short, IBlockState> IntStateMap = new HashMap<Short, IBlockState>();
    public Map<IBlockState, UniqueItem> IntStackMap = new HashMap<IBlockState, UniqueItem>();

    public Map<Short, IBlockState> getIntStateMap() {
        return this.IntStateMap;
    }

    public Map<IBlockState, UniqueItem> getIntStackMap() {
        return this.IntStackMap;
    }

    public void addToMap(IBlockState mapState) {
        if (this.findSlot(mapState) == -1) {
            short nextSlot = (short)this.IntStateMap.size();
            nextSlot = (short)(nextSlot + 1);
            this.IntStateMap.put(nextSlot, mapState);
        }
    }

    public void addToStackMap(UniqueItem uniqueItem, IBlockState blockState) {
        if (this.findStackSlot(uniqueItem) != blockState) {
            this.IntStackMap.put(blockState, uniqueItem);
        }
    }

    public Short findSlot(IBlockState mapState) {
        for (Map.Entry<Short, IBlockState> entry : this.IntStateMap.entrySet()) {
            if (entry.getValue() != mapState) continue;
            return entry.getKey();
        }
        return (short)-1;
    }

    public IBlockState findStackSlot(UniqueItem uniqueItem) {
        for (Map.Entry<IBlockState, UniqueItem> entry : this.IntStackMap.entrySet()) {
            if (entry.getValue().item != uniqueItem.item || entry.getValue().meta != uniqueItem.meta) continue;
            return entry.getKey();
        }
        return null;
    }

    public IBlockState getStateFromSlot(Short slot) {
        return this.IntStateMap.get(slot);
    }

    public UniqueItem getStackFromSlot(IBlockState blockState) {
        return this.IntStackMap.get(blockState);
    }

    public Map<Short, IBlockState> getIntStateMapFromNBT(NBTTagList tagList) {
        this.IntStateMap = new HashMap<Short, IBlockState>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            this.IntStateMap.put(compound.func_74765_d("mapSlot"), NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("mapState")));
        }
        return this.IntStateMap;
    }

    public NBTTagList putIntStateMapIntoNBT() {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<Short, IBlockState> entry : this.IntStateMap.entrySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagCompound state = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)state, (IBlockState)entry.getValue());
            compound.func_74777_a("mapSlot", entry.getKey().shortValue());
            compound.func_74782_a("mapState", (NBTBase)state);
            tagList.func_74742_a((NBTBase)compound);
        }
        return tagList;
    }

    public Map<IBlockState, UniqueItem> getIntStackMapFromNBT(NBTTagList tagList) {
        this.IntStackMap = new HashMap<IBlockState, UniqueItem>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            this.IntStackMap.put(GadgetUtils.compoundToState(compound.func_74775_l("state")), new UniqueItem(Item.func_150899_d((int)compound.func_74762_e("item")), compound.func_74762_e("meta")));
        }
        return this.IntStackMap;
    }

    public NBTTagList putIntStackMapIntoNBT() {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<IBlockState, UniqueItem> entry : this.IntStackMap.entrySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("item", Item.func_150891_b((Item)entry.getValue().item));
            compound.func_74768_a("meta", entry.getValue().meta);
            compound.func_74782_a("state", (NBTBase)GadgetUtils.stateToCompound(entry.getKey()));
            tagList.func_74742_a((NBTBase)compound);
        }
        return tagList;
    }

    public static UniqueItem blockStateToUniqueItem(IBlockState state, EntityPlayer player, BlockPos pos) {
        ItemStack itemStack;
        try {
            itemStack = state.func_177230_c().getPickBlock(state, null, player.field_70170_p, pos, player);
        }
        catch (Exception e) {
            itemStack = InventoryManipulation.getSilkTouchDrop(state);
        }
        if (itemStack == null || itemStack.equals(Items.field_190931_a)) {
            itemStack = InventoryManipulation.getSilkTouchDrop(state);
        }
        if (!itemStack.equals(Items.field_190931_a)) {
            UniqueItem uniqueItem = new UniqueItem(itemStack.func_77973_b(), itemStack.func_77960_j());
            return uniqueItem;
        }
        return null;
    }
}

