/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.items;

import com.direwolf20.buildinggadgets.Config;
import com.direwolf20.buildinggadgets.ModItems;
import com.direwolf20.buildinggadgets.blocks.ConstructionBlock;
import com.direwolf20.buildinggadgets.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.entities.BlockBuildEntity;
import com.direwolf20.buildinggadgets.items.GenericGadget;
import com.direwolf20.buildinggadgets.network.PacketBlockMap;
import com.direwolf20.buildinggadgets.network.PacketHandler;
import com.direwolf20.buildinggadgets.tools.BlacklistBlocks;
import com.direwolf20.buildinggadgets.tools.BlockMap;
import com.direwolf20.buildinggadgets.tools.BlockMapIntState;
import com.direwolf20.buildinggadgets.tools.BlockMapWorldSave;
import com.direwolf20.buildinggadgets.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.tools.UniqueItem;
import com.direwolf20.buildinggadgets.tools.VectorTools;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CopyPasteTool
extends GenericGadget {
    public CopyPasteTool() {
        this.setRegistryName("copypastetool");
        this.func_77655_b("buildinggadgets.copypastetool");
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public static void setAnchor(ItemStack stack, BlockPos anchorPos) {
        GadgetUtils.writePOSToNBT(stack, anchorPos, "anchor");
    }

    public static BlockPos getAnchor(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "anchor");
    }

    public static String getUUID(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        String uuid = tagCompound.func_74779_i("UUID");
        if (tagCompound == null || uuid == "") {
            if (CopyPasteTool.getStartPos(stack) == null && CopyPasteTool.getEndPos(stack) == null) {
                return null;
            }
            UUID uid = UUID.randomUUID();
            tagCompound.func_74778_a("UUID", uid.toString());
            stack.func_77982_d(tagCompound);
            uuid = uid.toString();
        }
        return uuid;
    }

    public static String getOwner(ItemStack stack) {
        return stack.func_77978_p().func_74779_i("owner");
    }

    public static void setOwner(ItemStack stack, String owner) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        tagCompound.func_74778_a("owner", owner);
        stack.func_77982_d(tagCompound);
    }

    public static Integer getCopyCounter(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("copycounter");
    }

    public static void incrementCopyCounter(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        tagCompound.func_74768_a("copycounter", tagCompound.func_74762_e("copycounter") + 1);
        stack.func_77982_d(tagCompound);
    }

    public static void setLastBuild(ItemStack stack, BlockPos anchorPos, Integer dim) {
        GadgetUtils.writePOSToNBT(stack, anchorPos, "lastBuild", dim);
    }

    public static BlockPos getLastBuild(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "lastBuild");
    }

    public static Integer getLastBuildDim(ItemStack stack) {
        return GadgetUtils.getDIMFromNBT(stack, "lastBuild");
    }

    public static void setStartPos(ItemStack stack, BlockPos startPos) {
        GadgetUtils.writePOSToNBT(stack, startPos, "startPos");
    }

    public static BlockPos getStartPos(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "startPos");
    }

    public static void setEndPos(ItemStack stack, BlockPos startPos) {
        GadgetUtils.writePOSToNBT(stack, startPos, "endPos");
    }

    public static BlockPos getEndPos(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "endPos");
    }

    public static ArrayList<BlockMap> getBlockMapList(NBTTagCompound tagCompound) {
        NBTTagList MapIntStateTag;
        ArrayList<BlockMap> blockMap = new ArrayList<BlockMap>();
        BlockPos startBlock = GadgetUtils.getPOSFromNBT(tagCompound, "startPos");
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if ((MapIntStateTag = (NBTTagList)tagCompound.func_74781_a("mapIntState")) == null) {
            MapIntStateTag = new NBTTagList();
        }
        BlockMapIntState MapIntState = new BlockMapIntState();
        MapIntState.getIntStateMapFromNBT(MapIntStateTag);
        int[] posIntArray = tagCompound.func_74759_k("posIntArray");
        int[] stateIntArray = tagCompound.func_74759_k("stateIntArray");
        for (int i = 0; i < posIntArray.length; ++i) {
            int p = posIntArray[i];
            BlockPos pos = GadgetUtils.relIntToPos(startBlock, p);
            short IntState = (short)stateIntArray[i];
            blockMap.add(new BlockMap(pos, MapIntState.getStateFromSlot(IntState), (byte)((p & 0xFF0000) >> 16), (byte)((p & 0xFF00) >> 8), (byte)(p & 0xFF)));
        }
        return blockMap;
    }

    public static ArrayList<BlockMap> getBlockMapList(NBTTagCompound tagCompound, BlockPos startBlock) {
        NBTTagList MapIntStateTag;
        ArrayList<BlockMap> blockMap = new ArrayList<BlockMap>();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if ((MapIntStateTag = (NBTTagList)tagCompound.func_74781_a("mapIntState")) == null) {
            MapIntStateTag = new NBTTagList();
        }
        BlockMapIntState MapIntState = new BlockMapIntState();
        MapIntState.getIntStateMapFromNBT(MapIntStateTag);
        int[] posIntArray = tagCompound.func_74759_k("posIntArray");
        int[] stateIntArray = tagCompound.func_74759_k("stateIntArray");
        for (int i = 0; i < posIntArray.length; ++i) {
            int p = posIntArray[i];
            BlockPos pos = GadgetUtils.relIntToPos(startBlock, p);
            short IntState = (short)stateIntArray[i];
            blockMap.add(new BlockMap(pos, MapIntState.getStateFromSlot(IntState), (byte)((p & 0xFF0000) >> 16), (byte)((p & 0xFF00) >> 8), (byte)(p & 0xFF)));
        }
        return blockMap;
    }

    public static BlockMapIntState getBlockMapIntState(NBTTagCompound tagCompound) {
        NBTTagList MapIntStackTag;
        NBTTagList MapIntStateTag;
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if ((MapIntStateTag = (NBTTagList)tagCompound.func_74781_a("mapIntState")) == null) {
            MapIntStateTag = new NBTTagList();
        }
        if ((MapIntStackTag = (NBTTagList)tagCompound.func_74781_a("mapIntStack")) == null) {
            MapIntStackTag = new NBTTagList();
        }
        BlockMapIntState MapIntState = new BlockMapIntState();
        MapIntState.getIntStateMapFromNBT(MapIntStateTag);
        MapIntState.getIntStackMapFromNBT(MapIntStackTag);
        return MapIntState;
    }

    public static void setToolMode(ItemStack stack, toolModes mode) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74778_a("mode", mode.name());
        stack.func_77982_d(tagCompound);
    }

    public static toolModes getToolMode(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        toolModes mode = toolModes.Copy;
        if (tagCompound == null) {
            CopyPasteTool.setToolMode(stack, mode);
            return mode;
        }
        try {
            mode = toolModes.valueOf(tagCompound.func_74779_i("mode"));
        }
        catch (Exception e) {
            CopyPasteTool.setToolMode(stack, mode);
        }
        return mode;
    }

    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag b) {
        super.func_77624_a(stack, player, list, b);
        list.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.gadget.mode", (Object[])new Object[0]) + ": " + (Object)((Object)CopyPasteTool.getToolMode(stack)));
        if (Config.poweredByFE) {
            IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            list.add(TextFormatting.WHITE + I18n.func_135052_a((String)"tooltip.gadget.energy", (Object[])new Object[0]) + ": " + GadgetUtils.withSuffix(energy.getEnergyStored()) + "/" + GadgetUtils.withSuffix(energy.getMaxEnergyStored()));
        }
    }

    public void setMode(EntityPlayer player, ItemStack heldItem, int modeInt) {
        toolModes mode = toolModes.values()[modeInt];
        CopyPasteTool.setToolMode(heldItem, mode);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.toolmode", new Object[0]).func_150261_e() + ": " + mode.name()), true);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (CopyPasteTool.getToolMode(stack) == toolModes.Copy) {
                if (player.func_70093_af()) {
                    if (CopyPasteTool.getStartPos(stack) != null) {
                        this.copyBlocks(stack, player, world, CopyPasteTool.getStartPos(stack), pos);
                    } else {
                        CopyPasteTool.setEndPos(stack, pos);
                    }
                } else if (CopyPasteTool.getEndPos(stack) != null) {
                    this.copyBlocks(stack, player, world, pos, CopyPasteTool.getEndPos(stack));
                } else {
                    CopyPasteTool.setStartPos(stack, pos);
                }
            } else if (CopyPasteTool.getToolMode(stack) == toolModes.Paste) {
                this.buildBlockMap(world, pos.func_177984_a(), stack, player);
            }
            NBTTagCompound tagCompound = stack.func_77978_p();
            ByteBuf buf = Unpooled.buffer((int)16);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tagCompound);
            System.out.println(buf.readableBytes());
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (CopyPasteTool.getToolMode(stack) == toolModes.Copy) {
                BlockPos pos = VectorTools.getPosLookingAt(player);
                if (pos == null) {
                    CopyPasteTool.setStartPos(stack, null);
                    CopyPasteTool.setEndPos(stack, null);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                if (player.func_70093_af()) {
                    if (CopyPasteTool.getStartPos(stack) != null) {
                        this.copyBlocks(stack, player, world, CopyPasteTool.getStartPos(stack), pos);
                    } else {
                        CopyPasteTool.setEndPos(stack, pos);
                    }
                } else if (CopyPasteTool.getEndPos(stack) != null) {
                    this.copyBlocks(stack, player, world, pos, CopyPasteTool.getEndPos(stack));
                } else {
                    CopyPasteTool.setStartPos(stack, pos);
                }
            } else if (CopyPasteTool.getToolMode(stack) == toolModes.Paste) {
                if (CopyPasteTool.getAnchor(stack) == null) {
                    BlockPos pos = VectorTools.getPosLookingAt(player);
                    if (pos == null) {
                        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                    }
                    this.buildBlockMap(world, pos.func_177984_a(), stack, player);
                } else {
                    this.buildBlockMap(world, CopyPasteTool.getAnchor(stack).func_177984_a(), stack, player);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void rotateBlocks(ItemStack stack, EntityPlayer player) {
        if (CopyPasteTool.getToolMode(stack) != toolModes.Paste) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ArrayList<Object> blockMapList = new ArrayList();
        BlockMapWorldSave worldSave = BlockMapWorldSave.get(player.field_70170_p);
        NBTTagCompound tagCompound = worldSave.getCompoundFromUUID(CopyPasteTool.getUUID(stack));
        BlockPos startPos = CopyPasteTool.getStartPos(stack);
        blockMapList = CopyPasteTool.getBlockMapList(tagCompound);
        ArrayList<Integer> posIntArrayList = new ArrayList<Integer>();
        ArrayList<Integer> stateIntArrayList = new ArrayList<Integer>();
        BlockMapIntState blockMapIntState = new BlockMapIntState();
        for (BlockMap blockMap : blockMapList) {
            BlockPos tempPos = blockMap.pos;
            int px = tempPos.func_177958_n() - startPos.func_177958_n();
            int pz = tempPos.func_177952_p() - startPos.func_177952_p();
            int nx = -pz;
            int nz = px;
            BlockPos newPos = new BlockPos(startPos.func_177958_n() + nx, tempPos.func_177956_o(), startPos.func_177952_p() + nz);
            IBlockState rotatedState = blockMap.state.func_185907_a(Rotation.CLOCKWISE_90);
            posIntArrayList.add(GadgetUtils.relPosToInt(startPos, newPos));
            blockMapIntState.addToMap(rotatedState);
            stateIntArrayList.add(Integer.valueOf(blockMapIntState.findSlot(rotatedState).shortValue()));
            UniqueItem uniqueItem = BlockMapIntState.blockStateToUniqueItem(rotatedState, player, tempPos);
            blockMapIntState.addToStackMap(uniqueItem, rotatedState);
        }
        int[] posIntArray = posIntArrayList.stream().mapToInt(i -> i).toArray();
        int[] nArray = stateIntArrayList.stream().mapToInt(i -> i).toArray();
        tagCompound.func_74782_a("mapIntState", (NBTBase)blockMapIntState.putIntStateMapIntoNBT());
        tagCompound.func_74782_a("mapIntStack", (NBTBase)blockMapIntState.putIntStackMapIntoNBT());
        tagCompound.func_74783_a("posIntArray", posIntArray);
        tagCompound.func_74783_a("stateIntArray", nArray);
        CopyPasteTool.incrementCopyCounter(stack);
        tagCompound.func_74768_a("copycounter", CopyPasteTool.getCopyCounter(stack).intValue());
        worldSave.addToMap(CopyPasteTool.getUUID(stack), tagCompound);
        worldSave.markForSaving();
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketBlockMap(tagCompound), (EntityPlayerMP)player);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.rotated", new Object[0]).func_150261_e()), true);
    }

    public void copyBlocks(ItemStack stack, EntityPlayer player, World world, BlockPos startPos, BlockPos endPos) {
        if (startPos != null && endPos != null && this.findBlocks(world, startPos, endPos, stack, player)) {
            CopyPasteTool.setStartPos(stack, startPos);
            CopyPasteTool.setEndPos(stack, endPos);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.copied", new Object[0]).func_150261_e()), true);
        }
    }

    public boolean findBlocks(World world, BlockPos start, BlockPos end, ItemStack stack, EntityPlayer player) {
        CopyPasteTool.setLastBuild(stack, null, 0);
        int startX = start.func_177958_n();
        int startY = start.func_177956_o();
        int startZ = start.func_177952_p();
        int endX = end.func_177958_n();
        int endY = end.func_177956_o();
        int endZ = end.func_177952_p();
        if (Math.abs(startX - endX) >= 125 || Math.abs(startY - endY) >= 125 || Math.abs(startZ - endZ) >= 125) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.toobigarea", new Object[0]).func_150261_e()), true);
            return false;
        }
        int iStartX = startX < endX ? startX : endX;
        int iStartY = startY < endY ? startY : endY;
        int iStartZ = startZ < endZ ? startZ : endZ;
        int iEndX = startX < endX ? endX : startX;
        int iEndY = startY < endY ? endY : startY;
        int iEndZ = startZ < endZ ? endZ : startZ;
        BlockMapWorldSave worldSave = BlockMapWorldSave.get(world);
        NBTTagCompound tagCompound = new NBTTagCompound();
        ArrayList<Integer> posIntArrayList = new ArrayList<Integer>();
        ArrayList<Integer> stateIntArrayList = new ArrayList<Integer>();
        BlockMapIntState blockMapIntState = new BlockMapIntState();
        int blockCount = 0;
        for (int x = iStartX; x <= iEndX; ++x) {
            for (int y = iStartY; y <= iEndY; ++y) {
                for (int z = iStartZ; z <= iEndZ; ++z) {
                    BlockPos tempPos = new BlockPos(x, y, z);
                    IBlockState tempState = world.func_180495_p(tempPos);
                    if (tempState == Blocks.field_150350_a.func_176223_P() || world.func_175625_s(tempPos) != null && !(world.func_175625_s(tempPos) instanceof ConstructionBlockTileEntity) || tempState.func_177230_c().func_149688_o(tempState).func_76224_d() || BlacklistBlocks.checkBlacklist(tempState.func_177230_c())) continue;
                    TileEntity te = world.func_175625_s(tempPos);
                    IBlockState assignState = InventoryManipulation.getSpecificStates(tempState, world, player, tempPos);
                    IBlockState actualState = assignState.func_177230_c().func_176221_a(assignState, (IBlockAccess)world, tempPos);
                    if (te instanceof ConstructionBlockTileEntity) {
                        actualState = ((ConstructionBlockTileEntity)te).getActualBlockState();
                    }
                    posIntArrayList.add(GadgetUtils.relPosToInt(start, tempPos));
                    blockMapIntState.addToMap(actualState);
                    stateIntArrayList.add(Integer.valueOf(blockMapIntState.findSlot(actualState).shortValue()));
                    UniqueItem uniqueItem = BlockMapIntState.blockStateToUniqueItem(actualState, player, tempPos);
                    blockMapIntState.addToStackMap(uniqueItem, actualState);
                    if (++blockCount <= 32768) continue;
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.toomanyblocks", new Object[0]).func_150261_e()), true);
                    return false;
                }
            }
        }
        tagCompound.func_74782_a("mapIntState", (NBTBase)blockMapIntState.putIntStateMapIntoNBT());
        tagCompound.func_74782_a("mapIntStack", (NBTBase)blockMapIntState.putIntStackMapIntoNBT());
        int[] posIntArray = posIntArrayList.stream().mapToInt(i -> i).toArray();
        int[] stateIntArray = stateIntArrayList.stream().mapToInt(i -> i).toArray();
        tagCompound.func_74783_a("posIntArray", posIntArray);
        tagCompound.func_74783_a("stateIntArray", stateIntArray);
        tagCompound.func_74782_a("startPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)start));
        tagCompound.func_74782_a("endPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)end));
        tagCompound.func_74768_a("dim", player.field_71093_bK);
        tagCompound.func_74778_a("UUID", CopyPasteTool.getUUID(stack));
        tagCompound.func_74778_a("owner", player.func_70005_c_());
        CopyPasteTool.incrementCopyCounter(stack);
        tagCompound.func_74768_a("copycounter", CopyPasteTool.getCopyCounter(stack).intValue());
        worldSave.addToMap(CopyPasteTool.getUUID(stack), tagCompound);
        worldSave.markForSaving();
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketBlockMap(tagCompound), (EntityPlayerMP)player);
        return true;
    }

    public void buildBlockMap(World world, BlockPos startPos, ItemStack stack, EntityPlayer player) {
        long time = System.nanoTime();
        BlockPos anchorPos = CopyPasteTool.getAnchor(stack);
        ArrayList<Object> blockMapList = new ArrayList();
        BlockMapWorldSave worldSave = BlockMapWorldSave.get(world);
        NBTTagCompound tagCompound = worldSave.getCompoundFromUUID(CopyPasteTool.getUUID(stack));
        Map<IBlockState, UniqueItem> IntStackMap = CopyPasteTool.getBlockMapIntState(tagCompound).getIntStackMap();
        if (anchorPos == null) {
            blockMapList = CopyPasteTool.getBlockMapList(tagCompound, startPos);
            CopyPasteTool.setLastBuild(stack, startPos, player.field_71093_bK);
        } else {
            blockMapList = CopyPasteTool.getBlockMapList(tagCompound, anchorPos);
            CopyPasteTool.setLastBuild(stack, anchorPos, player.field_71093_bK);
        }
        for (BlockMap blockMap : blockMapList) {
            CopyPasteTool.placeBlock(world, blockMap.pos, player, blockMap.state, IntStackMap);
        }
        CopyPasteTool.setAnchor(stack, null);
    }

    public static void placeBlock(World world, BlockPos pos, EntityPlayer player, IBlockState state, Map<IBlockState, UniqueItem> IntStackMap) {
        boolean useItemSuccess;
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            return;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof CopyPasteTool) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof CopyPasteTool)) {
            return;
        }
        UniqueItem uniqueItem = IntStackMap.get(state);
        if (uniqueItem == null) {
            return;
        }
        ItemStack itemStack = new ItemStack(uniqueItem.item, 1, uniqueItem.meta);
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, state, 0);
        int neededItems = 0;
        for (ItemStack drop : drops) {
            if (!drop.func_77973_b().equals(itemStack.func_77973_b())) continue;
            ++neededItems;
        }
        if (neededItems == 0) {
            neededItems = 1;
        }
        if (!world.func_175660_a(player, pos)) {
            return;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        if (ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blockSnapshot, (EnumFacing)EnumFacing.UP, (EnumHand)EnumHand.MAIN_HAND).isCanceled()) {
            return;
        }
        ItemStack constructionPaste = new ItemStack((Item)ModItems.constructionPaste);
        boolean useConstructionPaste = false;
        if (InventoryManipulation.countItem(itemStack, player) < neededItems) {
            if (InventoryManipulation.countPaste(player) < neededItems) {
                return;
            }
            itemStack = constructionPaste.func_77946_l();
            useConstructionPaste = true;
        }
        if (Config.poweredByFE) {
            if (!GadgetUtils.useEnergy(heldItem, Config.energyCostBuilder, player)) {
                return;
            }
        } else {
            if (heldItem.func_77952_i() >= heldItem.func_77958_k()) {
                return;
            }
            heldItem.func_77972_a(1, (EntityLivingBase)player);
        }
        if (useItemSuccess = useConstructionPaste ? InventoryManipulation.usePaste(player, neededItems) : InventoryManipulation.useItem(itemStack, player, neededItems)) {
            world.func_72838_d((Entity)new BlockBuildEntity(world, pos, (EntityLivingBase)player, state, 1, state, useConstructionPaste));
        }
    }

    public static void anchorBlocks(EntityPlayer player, ItemStack stack) {
        BlockPos currentAnchor = CopyPasteTool.getAnchor(stack);
        if (currentAnchor == null) {
            RayTraceResult lookingAt = VectorTools.getLookingAt(player);
            if (lookingAt == null) {
                return;
            }
            currentAnchor = lookingAt.func_178782_a().func_177984_a();
            CopyPasteTool.setAnchor(stack, currentAnchor);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorrender", new Object[0]).func_150261_e()), true);
        } else {
            CopyPasteTool.setAnchor(stack, null);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorremove", new Object[0]).func_150261_e()), true);
        }
    }

    public static void undoBuild(EntityPlayer player, ItemStack heldItem) {
        long time = System.nanoTime();
        BlockMapWorldSave worldSave = BlockMapWorldSave.get(player.field_70170_p);
        NBTTagCompound tagCompound = worldSave.getCompoundFromUUID(CopyPasteTool.getUUID(heldItem));
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        BlockPos startPos = CopyPasteTool.getLastBuild(heldItem);
        if (startPos == null) {
            return;
        }
        Integer dimension = CopyPasteTool.getLastBuildDim(heldItem);
        ItemStack silkTool = heldItem.func_77946_l();
        silkTool.func_77966_a(Enchantments.field_185306_r, 1);
        ArrayList<BlockMap> blockMapList = CopyPasteTool.getBlockMapList(tagCompound, startPos);
        boolean success = true;
        for (BlockMap blockMap : blockMapList) {
            double distance = blockMap.pos.func_185332_f(player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
            boolean sameDim = player.field_71093_bK == dimension;
            IBlockState currentBlock = world.func_180495_p(blockMap.pos);
            BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(world, blockMap.pos, currentBlock, player);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)e);
            if (distance < 64.0 && !cancelled && sameDim) {
                if (currentBlock.func_177230_c() != blockMap.state.func_177230_c() && !(currentBlock.func_177230_c() instanceof ConstructionBlock) || !(currentBlock.func_177230_c().func_176195_g(currentBlock, world, blockMap.pos) >= 0.0f)) continue;
                currentBlock.func_177230_c().func_180657_a(world, player, blockMap.pos, currentBlock, world.func_175625_s(blockMap.pos), silkTool);
                world.func_72838_d((Entity)new BlockBuildEntity(world, blockMap.pos, (EntityLivingBase)player, currentBlock, 2, currentBlock, false));
                continue;
            }
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.undofailed", new Object[0]).func_150261_e()), true);
            success = false;
        }
        if (success) {
            CopyPasteTool.setLastBuild(heldItem, null, 0);
        }
    }

    public static enum toolModes {
        Copy,
        Paste;

        private static toolModes[] vals;

        public toolModes next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = toolModes.values();
        }
    }
}

