/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.commands;

import com.direwolf20.buildinggadgets.network.PacketBlockMap;
import com.direwolf20.buildinggadgets.network.PacketHandler;
import com.direwolf20.buildinggadgets.tools.BlockMapWorldSave;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DeleteBlockMapsCommand
extends CommandBase {
    private final List<String> aliases = Lists.newArrayList((Object[])new String[]{"buildinggadgets", "DeleteBlockMaps", "deleteblockmaps"});

    @Nonnull
    public String func_71517_b() {
        return "DeleteBlockMaps";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "DeleteBlockMaps <player>";
    }

    @Nonnull
    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length > 0 && !sender.func_70003_b(4, this.func_71517_b())) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Only OPS can use this command with an argument."));
            return;
        }
        BlockMapWorldSave worldSave = BlockMapWorldSave.get(sender.func_130014_f_());
        Map<String, NBTTagCompound> tagMap = worldSave.getTagMap();
        HashMap<String, NBTTagCompound> newMap = new HashMap<String, NBTTagCompound>(tagMap);
        String searchName = args.length == 0 ? sender.func_70005_c_() : args[0];
        int counter = 0;
        for (Map.Entry<String, NBTTagCompound> entry : tagMap.entrySet()) {
            NBTTagCompound tagCompound = entry.getValue();
            if (!tagCompound.func_74779_i("owner").equals(searchName) && !searchName.equals("*")) continue;
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Deleted stored map for " + tagCompound.func_74779_i("owner") + " with UUID:" + tagCompound.func_74779_i("UUID")));
            ++counter;
            newMap.remove(entry.getKey());
        }
        if (counter > 0) {
            worldSave.setTagMap(newMap);
            worldSave.markForSaving();
            if (searchName.equals(sender.func_70005_c_())) {
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketBlockMap(new NBTTagCompound()), (EntityPlayerMP)sender);
                System.out.println("Sending BlockMap Packet");
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + "Deleted " + counter + " blockmaps in world data."));
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }
}

