/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.InvUtils;
import com.feed_the_beast.ftblib.lib.util.misc.DataStorage;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.api.YabbaConfigEvent;
import com.latmod.yabba.item.upgrade.ItemUpgradeHopper;
import com.latmod.yabba.item.upgrade.ItemUpgradeRedstone;
import com.latmod.yabba.tile.IItemBarrel;
import com.latmod.yabba.tile.TileAdvancedBarrelBase;
import com.latmod.yabba.tile.TileItemBarrelConnector;
import com.latmod.yabba.util.UpgradeInst;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileItemBarrel
extends TileAdvancedBarrelBase
implements ITickable,
IItemBarrel {
    private ItemStack storedItem = ItemStack.field_190927_a;
    private int itemCount = 0;
    private String cachedItemName;
    private String cachedItemCount;
    private int prevItemCount = -1;
    private int prevItemCountForNet = -1;

    @Override
    public void markBarrelDirty(boolean majorChange) {
        if (majorChange) {
            this.prevItemCount = -1;
            this.prevItemCountForNet = -1;
        }
        super.markBarrelDirty(majorChange);
    }

    @Override
    public void func_145836_u() {
        super.func_145836_u();
        this.cachedItemName = null;
        this.cachedItemCount = null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : super.getCapability(capability, facing));
    }

    @Override
    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        if (this.itemCount > 0) {
            nbt.func_74768_a("Count", this.itemCount);
        }
        if (type == EnumSaveType.NET_UPDATE) {
            if (this.prevItemCountForNet != 0) {
                nbt.func_74768_a("PrevCount", this.prevItemCountForNet);
            }
            if (this.prevItemCountForNet != -1) {
                return;
            }
        }
        super.writeData(nbt, type);
        if (!this.storedItem.func_190926_b()) {
            this.storedItem.func_190920_e(1);
            nbt.func_74782_a("Item", (NBTBase)this.storedItem.serializeNBT());
        }
    }

    @Override
    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        this.setRawItemCount(nbt.func_74762_e("Count"));
        this.prevItemCountForNet = -1;
        this.prevItemCount = -1;
        if (type == EnumSaveType.NET_UPDATE) {
            this.prevItemCount = this.prevItemCountForNet = nbt.func_74762_e("PrevCount");
            this.cachedItemCount = null;
            if (this.prevItemCount != -1) {
                return;
            }
        }
        super.readData(nbt, type);
        ItemStack itemStack = this.storedItem = nbt.func_74764_b("Item") ? new ItemStack(nbt.func_74775_l("Item")) : ItemStack.field_190927_a;
        if (this.storedItem.func_190926_b()) {
            this.storedItem = ItemStack.field_190927_a;
        }
        this.func_145836_u();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TileItemBarrelConnector.markAllDirty(this.field_174879_c, this.field_145850_b.field_73011_w.getDimension());
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TileItemBarrelConnector.markAllDirty(this.field_174879_c, this.field_145850_b.field_73011_w.getDimension());
        }
    }

    public void func_73660_a() {
        this.prevItemCountForNet = this.prevItemCount;
        if (!this.field_145850_b.field_72995_K && this.hasUpgrade(YabbaItems.UPGRADE_HOPPER) && this.field_145850_b.func_82737_E() % 8L == (long)(this.field_174879_c.hashCode() & 7)) {
            TileEntity tileUp;
            TileEntity tileDown;
            int maxItems;
            ItemUpgradeHopper.Data data = (ItemUpgradeHopper.Data)this.getUpgradeData(YabbaItems.UPGRADE_HOPPER);
            boolean ender = false;
            int n = maxItems = ender ? 64 : 1;
            if (this.itemCount > 0 && data.down.getBoolean() && (tileDown = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.DOWN))) != null && tileDown.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                InvUtils.transferItems((IItemHandler)this, (IItemHandler)((IItemHandler)tileDown.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)), (int)Math.min(maxItems, this.itemCount), (Predicate)CommonUtils.alwaysTruePredicate());
            }
            if (data.up.getBoolean() && (tileUp = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.UP))) != null && tileUp.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
                InvUtils.transferItems((IItemHandler)((IItemHandler)tileUp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)), (IItemHandler)this, (int)Math.min(maxItems, this.getFreeSpace()), (Predicate)CommonUtils.alwaysTruePredicate());
            }
            if (data.collect.getBoolean()) {
                AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 1, 0), this.field_174879_c.func_177982_a(1, 2, 1));
                if (ender) {
                    aabb = aabb.func_72321_a(5.0, 5.0, 5.0);
                }
                for (EntityItem item : this.field_145850_b.func_175647_a(EntityItem.class, aabb, null)) {
                    ItemStack stack = this.insertItem(0, item.func_92059_d().func_77946_l(), false);
                    if (stack.func_190926_b()) {
                        item.func_70106_y();
                        continue;
                    }
                    item.func_92058_a(stack);
                }
            }
        }
        if (this.prevItemCount == -1 || this.prevItemCount != this.itemCount) {
            if (this.field_145850_b != null) {
                if (!this.field_145850_b.field_72995_K) {
                    this.func_145836_u();
                }
                this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
                if (!this.field_145850_b.field_72995_K || this.prevItemCount == -1) {
                    BlockUtils.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IBlockState)this.getBlockState());
                }
                if (this.hasUpgrade(YabbaItems.UPGRADE_REDSTONE_OUT)) {
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
                }
            }
            this.prevItemCount = this.itemCount;
        }
    }

    @Override
    public String getItemDisplayName() {
        if (this.cachedItemName == null) {
            this.cachedItemName = this.storedItem.func_190926_b() ? "" : TextFormatting.BOLD + this.storedItem.func_82833_r();
        }
        return this.cachedItemName;
    }

    @Override
    public String getItemDisplayCount(boolean sneaking, boolean creative, boolean infinite) {
        if (creative) {
            return "INF";
        }
        if (sneaking) {
            return infinite ? Integer.toString(this.itemCount) : this.itemCount + " / " + this.getMaxItems(this.storedItem);
        }
        if (this.cachedItemCount == null) {
            int max;
            int n = max = this.storedItem.func_190926_b() ? 64 : this.storedItem.func_77976_d();
            if (max == 1 || this.itemCount <= max) {
                this.cachedItemCount = Integer.toString(this.itemCount);
            } else {
                this.cachedItemCount = this.itemCount / max + "x" + max;
                int extra = this.itemCount % max;
                if (extra != 0) {
                    this.cachedItemCount = this.cachedItemCount + "+" + extra;
                }
            }
        }
        return this.cachedItemCount;
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    @Override
    public void setRawItemCount(int v) {
        this.itemCount = v;
        this.cachedItemCount = null;
    }

    @Override
    public ItemStack getStoredItemType() {
        return this.storedItem;
    }

    @Override
    public void setRawItemType(ItemStack type) {
        this.storedItem = type;
        this.cachedItemName = null;
    }

    @Override
    public void addItem(EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        int c = heldItem.func_190916_E();
        heldItem.func_190920_e(this.insertItem(0, heldItem, false).func_190916_E());
        if (c != heldItem.func_190916_E()) {
            player.field_71071_by.func_70296_d();
            if (player.field_71070_bA != null) {
                player.field_71070_bA.func_75142_b();
            }
        }
    }

    @Override
    public void addAllItems(EntityPlayer player, EnumHand hand) {
        if (this.storedItem.func_190926_b()) {
            return;
        }
        boolean updateInv = false;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack0 = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            ItemStack is = this.insertItem(0, stack0, false);
            if (is == (stack0 = (ItemStack)player.field_71071_by.field_70462_a.get(i))) continue;
            stack0.func_190920_e(is.func_190916_E());
            if (!stack0.func_190926_b()) continue;
            player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            updateInv = true;
        }
        if (updateInv) {
            player.field_71071_by.func_70296_d();
            if (player.field_71070_bA != null) {
                player.field_71070_bA.func_75142_b();
            }
        }
    }

    @Override
    public void removeItem(EntityPlayer player, boolean removeStack) {
        int size;
        ItemStack stack;
        if (!this.storedItem.func_190926_b() && this.itemCount == 0 && !this.isLocked()) {
            this.setStoredItemType(ItemStack.field_190927_a, 0);
            this.markBarrelDirty(true);
            return;
        }
        if (!this.storedItem.func_190926_b() && this.itemCount > 0 && !(stack = this.extractItem(0, size = removeStack ? this.storedItem.func_77976_d() : 1, false)).func_190926_b()) {
            int slot = player.field_71071_by.field_70461_c;
            if (!player.field_71071_by.func_70301_a(slot).func_190926_b()) {
                slot = -1;
            }
            if (player.field_71071_by.func_191971_c(slot, stack)) {
                player.field_71071_by.func_70296_d();
                if (player.field_71070_bA != null) {
                    player.field_71070_bA.func_75142_b();
                }
            } else {
                EntityItem entityItem = player.func_71019_a(stack, false);
                if (entityItem != null) {
                    entityItem.func_174868_q();
                    entityItem.func_145797_a(player.func_70005_c_());
                }
            }
        }
    }

    @Override
    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.setStoredItemType(this.storedItem, this.itemCount);
    }

    @Override
    public void createConfig(YabbaConfigEvent event) {
        super.createConfig(event);
        if (!this.tier.creative()) {
            event.getConfig().add("locked", (ConfigValue)this.isLocked, (ConfigValue)new ConfigBoolean(false));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"lang.yabba.tier", (Object[])new Object[]{I18n.func_135052_a((String)this.tier.getLangKey(), (Object[])new Object[0])}));
        if (this.isLocked()) {
            tooltip.add(I18n.func_135052_a((String)"barrel_config.locked", (Object[])new Object[0]));
        }
        if (!this.storedItem.func_190926_b()) {
            tooltip.add(I18n.func_135052_a((String)"lang.yabba.item", (Object[])new Object[]{this.storedItem.func_82833_r()}));
        }
        if (!this.tier.creative()) {
            if (this.tier.infiniteCapacity()) {
                tooltip.add(I18n.func_135052_a((String)"lang.yabba.item_count_inf", (Object[])new Object[]{this.itemCount}));
            } else if (!this.storedItem.func_190926_b()) {
                tooltip.add(I18n.func_135052_a((String)"lang.yabba.item_count", (Object[])new Object[]{this.itemCount, this.getMaxItems(this.storedItem)}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"lang.yabba.item_count_max", (Object[])new Object[]{this.tier.maxItemStacks}));
            }
        }
        if (!this.upgrades.isEmpty()) {
            tooltip.add(I18n.func_135052_a((String)"lang.yabba.upgrades", (Object[])new Object[0]));
            for (UpgradeInst upgrade : this.upgrades.values()) {
                tooltip.add("> " + upgrade.getStack().func_82833_r());
            }
        }
    }

    @Override
    public int redstoneOutput(EnumFacing facing) {
        DataStorage data = this.getUpgradeData(YabbaItems.UPGRADE_REDSTONE_OUT);
        if (data instanceof ItemUpgradeRedstone.Data) {
            return ((ItemUpgradeRedstone.Data)data).redstoneOutput(facing, this.itemCount);
        }
        return 0;
    }
}

