/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.itemstages.ConfigurationHandler;
import net.darkhax.itemstages.ItemStages;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@JEIPlugin
public class PluginItemStages
implements IModPlugin {
    public static IIngredientBlacklist blacklist;
    public static IIngredientRegistry ingredientRegistry;
    public static IIngredientHelper<ItemStack> ingredientHelper;

    public void register(IModRegistry registry) {
        blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        ingredientRegistry = registry.getIngredientRegistry();
        ingredientHelper = ingredientRegistry.getIngredientHelper(ItemStack.class);
    }

    @SideOnly(value=Side.CLIENT)
    public static void syncHiddenItems(EntityPlayer player) {
        if (player != null && player.func_130014_f_().field_72995_K && ConfigurationHandler.hideRestrictionsInJEI) {
            if (!Minecraft.func_71410_x().func_152345_ab()) {
                Minecraft.func_71410_x().func_152344_a(() -> PluginItemStages.syncHiddenItems(player));
                return;
            }
            ItemStages.LOG.info("Syncing {} items with JEI!.", new Object[]{ItemStages.ITEM_STAGES.size()});
            long time = System.currentTimeMillis();
            ArrayList itemBlacklist = new ArrayList();
            ArrayList itemWhitelist = new ArrayList();
            ArrayList fluidBlacklist = new ArrayList();
            ArrayList fluidWhitelist = new ArrayList();
            for (String key : ItemStages.SORTED_STAGES.keySet()) {
                List entries = ItemStages.SORTED_STAGES.get((Object)key);
                if (GameStageHelper.clientHasStage((EntityPlayer)player, (String)key)) {
                    itemWhitelist.addAll(ingredientHelper.expandSubtypes(entries));
                    continue;
                }
                itemBlacklist.addAll(ingredientHelper.expandSubtypes(entries));
            }
            for (String key : ItemStages.FLUID_STAGES.keySet()) {
                if (GameStageHelper.clientHasStage((EntityPlayer)player, (String)key)) {
                    fluidWhitelist.addAll(ItemStages.FLUID_STAGES.get((Object)key));
                    continue;
                }
                fluidBlacklist.addAll(ItemStages.FLUID_STAGES.get((Object)key));
            }
            if (!itemBlacklist.isEmpty()) {
                ingredientRegistry.removeIngredientsAtRuntime(ItemStack.class, itemBlacklist);
            }
            if (!itemWhitelist.isEmpty()) {
                ingredientRegistry.addIngredientsAtRuntime(ItemStack.class, itemWhitelist);
            }
            if (!fluidBlacklist.isEmpty()) {
                ingredientRegistry.removeIngredientsAtRuntime(FluidStack.class, fluidBlacklist);
            }
            if (!fluidWhitelist.isEmpty()) {
                ingredientRegistry.addIngredientsAtRuntime(FluidStack.class, fluidWhitelist);
            }
            ItemStages.LOG.info("Finished JEI Sync, took " + (System.currentTimeMillis() - time) + "ms. " + itemBlacklist.size() + " hidden, " + itemWhitelist.size() + " shown.", new Object[0]);
        }
    }
}

