/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.handlers;

import com.feed_the_beast.ftblib.events.FTBLibPreInitRegistryEvent;
import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.Action;
import com.feed_the_beast.ftblib.lib.data.AdminPanelAction;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ISyncData;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesUniverseData;
import com.feed_the_beast.ftbutilities.handlers.FTBUtilitiesSyncData;
import com.feed_the_beast.ftbutilities.net.MessageRanks;
import com.feed_the_beast.ftbutilities.net.MessageViewCrashList;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import java.io.File;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameRules;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesRegistryEventHandler {
    @SubscribeEvent
    public static void onFTBLibPreInitRegistry(FTBLibPreInitRegistryEvent event) {
        FTBLibPreInitRegistryEvent.Registry registry = event.getRegistry();
        registry.registerServerReloadHandler(new ResourceLocation("ftbutilities", "config"), reloadEvent -> FTBUtilitiesConfig.sync());
        registry.registerServerReloadHandler(new ResourceLocation("ftbutilities", "ranks"), reloadEvent -> Ranks.INSTANCE.reload());
        registry.registerServerReloadHandler(new ResourceLocation("ftbutilities", "badges"), reloadEvent -> FTBUtilitiesUniverseData.reloadServerBadges(reloadEvent.getUniverse()));
        registry.registerSyncData("ftbutilities", (ISyncData)new FTBUtilitiesSyncData());
        registry.registerAdminPanelAction(new AdminPanelAction("ftbutilities", "crash_reports", ItemIcon.getItemIcon((ItemStack)new ItemStack(Blocks.field_180401_cv)), 0){

            public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
                return Action.Type.fromBoolean((boolean)player.hasPermission("admin_panel.ftbutilities.crash_reports.view"));
            }

            public void onAction(ForgePlayer player, NBTTagCompound data) {
                new MessageViewCrashList(new File(player.team.universe.server.func_71238_n(), "crash-reports")).sendTo(player.getPlayer());
            }
        });
        registry.registerAdminPanelAction(new AdminPanelAction("ftbutilities", "edit_world", GuiIcons.GLOBE, 0){

            public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
                return Action.Type.fromBoolean((boolean)player.hasPermission("admin_panel.ftbutilities.edit_world.gamerules"));
            }

            public void onAction(ForgePlayer player, NBTTagCompound data) {
                ConfigGroup main = ConfigGroup.newGroup((String)"edit_world");
                main.setDisplayName((ITextComponent)new TextComponentTranslation("admin_panel.ftbutilities.edit_world", new Object[0]));
                if (player.hasPermission("admin_panel.ftbutilities.edit_world.gamerules")) {
                    ConfigGroup gamerules = main.getGroup("gamerules");
                    gamerules.setDisplayName((ITextComponent)new TextComponentTranslation("gamerules", new Object[0]));
                    final GameRules rules = player.team.universe.world.func_82736_K();
                    block4: for (final String key : rules.func_82763_b()) {
                        switch (this.getType(rules, key)) {
                            case BOOLEAN_VALUE: {
                                gamerules.add(key, (ConfigValue)new ConfigBoolean(rules.func_82766_b(key)){

                                    public boolean getBoolean() {
                                        return rules.func_82766_b(key);
                                    }

                                    public void setBoolean(boolean value) {
                                        rules.func_82764_b(key, Boolean.toString(value));
                                    }
                                }, null).setDisplayName((ITextComponent)new TextComponentString(StringUtils.camelCaseToWords((String)key)));
                                continue block4;
                            }
                            case NUMERICAL_VALUE: {
                                gamerules.add(key, (ConfigValue)new ConfigInt(rules.func_180263_c(key)){

                                    public int getInt() {
                                        return rules.func_180263_c(key);
                                    }

                                    public void setInt(int value) {
                                        rules.func_82764_b(key, Integer.toString(value));
                                    }
                                }, null).setDisplayName((ITextComponent)new TextComponentString(StringUtils.camelCaseToWords((String)key)));
                                continue block4;
                            }
                            default: {
                                gamerules.add(key, (ConfigValue)new ConfigString(rules.func_82767_a(key)){

                                    public String getString() {
                                        return rules.func_82767_a(key);
                                    }

                                    public void setString(String value) {
                                        rules.func_82764_b(key, value);
                                    }
                                }, null).setDisplayName((ITextComponent)new TextComponentString(StringUtils.camelCaseToWords((String)key)));
                            }
                        }
                    }
                }
                FTBLibAPI.editServerConfig((EntityPlayerMP)player.getPlayer(), (ConfigGroup)main, (IConfigCallback)IConfigCallback.DEFAULT);
            }

            private GameRules.ValueType getType(GameRules gameRules, String key) {
                if (gameRules.func_180264_a(key, GameRules.ValueType.BOOLEAN_VALUE)) {
                    return GameRules.ValueType.BOOLEAN_VALUE;
                }
                if (gameRules.func_180264_a(key, GameRules.ValueType.NUMERICAL_VALUE)) {
                    return GameRules.ValueType.NUMERICAL_VALUE;
                }
                if (gameRules.func_180264_a(key, GameRules.ValueType.FUNCTION)) {
                    return GameRules.ValueType.FUNCTION;
                }
                return GameRules.ValueType.ANY_VALUE;
            }
        });
        registry.registerAdminPanelAction(new AdminPanelAction("ftbutilities", "ranks", ItemIcon.getItemIcon((ItemStack)new ItemStack(Items.field_151048_u)), 0){

            public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
                return Ranks.isActive() ? Action.Type.fromBoolean((boolean)player.hasPermission("admin_panel.ftbutilities.ranks.view")) : Action.Type.INVISIBLE;
            }

            public void onAction(ForgePlayer player, NBTTagCompound data) {
                new MessageRanks(Ranks.INSTANCE).sendTo(player.getPlayer());
            }
        });
    }
}

