/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.command.client;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.item.ItemEntry;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftbutilities.client.FTBUtilitiesClientConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.oredict.OreDictionary;

public class CmdScanItems
extends CmdBase {
    public CmdScanItems() {
        super("scan_items", CmdBase.Level.ALL);
    }

    public static boolean filter(ItemEntry entry) {
        String s = entry.item.getRegistryName().toString();
        for (String s1 : FTBUtilitiesClientConfig.general.scan_items_whitelist) {
            if (!s.startsWith(s1)) continue;
            return true;
        }
        for (String s1 : FTBUtilitiesClientConfig.general.scan_items_blacklist) {
            if (!s.startsWith(s1)) continue;
            return false;
        }
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, final String[] args) throws CommandException {
        new Thread("Scanning Items"){

            @Override
            public void run() {
                boolean md = args.length > 0 && args[0].equals("md");
                ArrayList<String> list = new ArrayList<String>();
                list.add("# Item format: mod:item metadata {nbt}");
                list.add("");
                list.add("## Items with duplicate display names:");
                list.add("");
                StringBuilder builder = new StringBuilder();
                NonNullList stacks = NonNullList.func_191196_a();
                LinkedHashMap<String, LinkedHashSet<ItemEntry>> itemToDisplayNameMap = new LinkedHashMap<String, LinkedHashSet<ItemEntry>>();
                LinkedHashMap<ItemEntry, Boolean> hasRecipe = new LinkedHashMap<ItemEntry, Boolean>();
                for (Item item : Item.field_150901_e) {
                    stacks.clear();
                    item.func_150895_a(CreativeTabs.field_78027_g, stacks);
                    block1: for (ItemStack stack : stacks) {
                        ItemEntry itemEntry = ItemEntry.get((ItemStack)stack);
                        if (stack.func_190926_b() || !CmdScanItems.filter(itemEntry)) continue;
                        String displayName = stack.func_82833_r();
                        LinkedHashSet<ItemEntry> set = (LinkedHashSet<ItemEntry>)itemToDisplayNameMap.get(displayName);
                        if (set == null) {
                            set = new LinkedHashSet<ItemEntry>();
                            itemToDisplayNameMap.put(displayName, set);
                        }
                        set.add(itemEntry);
                        hasRecipe.put(itemEntry, false);
                        ItemEntry itemEntry1 = ItemEntry.get((ItemStack)FurnaceRecipes.func_77602_a().func_151395_a(stack));
                        if (itemEntry.equalsEntry(itemEntry1)) {
                            hasRecipe.put(itemEntry, true);
                            continue;
                        }
                        for (IRecipe recipe : CraftingManager.field_193380_a) {
                            itemEntry1 = ItemEntry.get((ItemStack)recipe.func_77571_b());
                            if (!itemEntry.equalsEntry(itemEntry1)) continue;
                            hasRecipe.put(itemEntry, true);
                            continue block1;
                        }
                    }
                }
                for (Map.Entry entry : itemToDisplayNameMap.entrySet()) {
                    if (((LinkedHashSet)entry.getValue()).size() <= 1) continue;
                    list.add((String)entry.getKey());
                    if (md) {
                        list.add("");
                    }
                    for (ItemEntry itemEntry : (LinkedHashSet)entry.getValue()) {
                        builder.append('-');
                        builder.append(' ');
                        itemEntry.toString(builder);
                        list.add(builder.toString());
                        builder.setLength(0);
                    }
                    list.add("");
                }
                list.add("");
                list.add("");
                list.add("## Ore Dictionary names with more than one item:");
                list.add("");
                for (String ore : OreDictionary.getOreNames()) {
                    NonNullList oreItems = OreDictionary.getOres((String)ore);
                    if (oreItems.size() <= 1) continue;
                    boolean added = false;
                    for (ItemStack stack : oreItems) {
                        ItemEntry itemEntry = ItemEntry.get((ItemStack)stack);
                        if (itemEntry.isEmpty() || !CmdScanItems.filter(itemEntry)) continue;
                        if (!added) {
                            added = true;
                            list.add(ore);
                            if (md) {
                                list.add("");
                            }
                        }
                        builder.append('-');
                        builder.append(' ');
                        itemEntry.toString(builder);
                        list.add(builder.toString());
                        builder.setLength(0);
                    }
                    list.add("");
                }
                list.add("");
                list.add("");
                list.add("## Items without crafting table or furnace recipe (can be inaccurate):");
                list.add("");
                for (Map.Entry entry : hasRecipe.entrySet()) {
                    if (((Boolean)entry.getValue()).booleanValue()) continue;
                    builder.append('-');
                    builder.append(' ');
                    ((ItemEntry)entry.getKey()).toString(builder);
                    list.add(builder.toString());
                    builder.setLength(0);
                }
                FileUtils.saveSafe((File)new File(ClientUtils.MC.field_71412_D, "local/client/scanneditems." + (md ? "md" : "txt")), list);
                ClientUtils.MC.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Duplicate items have been exported in ./local/client/scanneditems." + (md ? "md" : "txt") + "!"), false);
            }
        }.start();
    }
}

