/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.generic;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.xnet.blocks.cables.ConnectorBlock;
import mcjty.xnet.blocks.cables.ConnectorType;
import mcjty.xnet.blocks.facade.FacadeBlockId;
import mcjty.xnet.blocks.generic.CableColor;
import mcjty.xnet.blocks.generic.CablePatterns;
import mcjty.xnet.blocks.generic.GenericCableBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class GenericCableBakedModel
implements IBakedModel {
    public static final ModelResourceLocation modelConnector = new ModelResourceLocation("xnet:connector");
    public static final ModelResourceLocation modelCable = new ModelResourceLocation("xnet:netcable");
    private TextureAtlasSprite spriteCable;
    private TextureAtlasSprite spriteConnector;
    private static CableTextures[] cableTextures = null;
    private static TextureAtlasSprite spriteSide;
    private VertexFormat format;

    private static void initTextures() {
        if (cableTextures == null) {
            CableTextures[] tt = new CableTextures[CableColor.VALUES.length];
            for (CableColor color : CableColor.VALUES) {
                int i = color.ordinal();
                tt[i] = new CableTextures();
                tt[i].spriteConnector = Minecraft.func_71410_x().func_147117_R().func_110572_b("xnet:blocks/cable" + i + "/connector");
                tt[i].spriteAdvancedConnector = Minecraft.func_71410_x().func_147117_R().func_110572_b("xnet:blocks/cable" + i + "/advanced_connector");
                tt[i].spriteNormalCable = Minecraft.func_71410_x().func_147117_R().func_110572_b("xnet:blocks/cable" + i + "/normal_netcable");
                tt[i].spriteNoneCable = Minecraft.func_71410_x().func_147117_R().func_110572_b("xnet:blocks/cable" + i + "/normal_none_netcable");
                tt[i].spriteEndCable = Minecraft.func_71410_x().func_147117_R().func_110572_b("xnet:blocks/cable" + i + "/normal_end_netcable");
                tt[i].spriteCornerCable = Minecraft.func_71410_x().func_147117_R().func_110572_b("xnet:blocks/cable" + i + "/normal_corner_netcable");
                tt[i].spriteThreeCable = Minecraft.func_71410_x().func_147117_R().func_110572_b("xnet:blocks/cable" + i + "/normal_three_netcable");
                tt[i].spriteCrossCable = Minecraft.func_71410_x().func_147117_R().func_110572_b("xnet:blocks/cable" + i + "/normal_cross_netcable");
            }
            spriteSide = Minecraft.func_71410_x().func_147117_R().func_110572_b("xnet:blocks/connector_side");
            cableTextures = tt;
        }
    }

    private static TextureAtlasSprite getSpriteNormal(CablePatterns.SpriteIdx idx, int index) {
        GenericCableBakedModel.initTextures();
        CableTextures cableTexture = cableTextures[index];
        switch (idx) {
            case SPRITE_NONE: {
                return cableTexture.spriteNoneCable;
            }
            case SPRITE_END: {
                return cableTexture.spriteEndCable;
            }
            case SPRITE_STRAIGHT: {
                return cableTexture.spriteNormalCable;
            }
            case SPRITE_CORNER: {
                return cableTexture.spriteCornerCable;
            }
            case SPRITE_THREE: {
                return cableTexture.spriteThreeCable;
            }
            case SPRITE_CROSS: {
                return cableTexture.spriteCrossCable;
            }
        }
        return cableTexture.spriteNoneCable;
    }

    public GenericCableBakedModel(VertexFormat format) {
        this.format = format;
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float color) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{color, color, color, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, int rotation, float hilight) {
        switch (rotation) {
            case 0: {
                return this.createQuad(v1, v2, v3, v4, sprite, hilight);
            }
            case 1: {
                return this.createQuad(v2, v3, v4, v1, sprite, hilight);
            }
            case 2: {
                return this.createQuad(v3, v4, v1, v2, sprite, hilight);
            }
            case 3: {
                return this.createQuad(v4, v1, v2, v3, sprite, hilight);
            }
        }
        return this.createQuad(v1, v2, v3, v4, sprite, hilight);
    }

    private BakedQuad createQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, float hilight) {
        Vec3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(sprite);
        this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f, sprite, hilight);
        this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, 16.0f, sprite, hilight);
        this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, 16.0f, 16.0f, sprite, hilight);
        this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, 16.0f, 0.0f, sprite, hilight);
        return builder.build();
    }

    private static Vec3d v(double x, double y, double z) {
        return new Vec3d(x, y, z);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        CablePatterns.QuadSetting pattern;
        if (state == null) {
            return Collections.emptyList();
        }
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        FacadeBlockId facadeId = (FacadeBlockId)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.FACADEID);
        if (facadeId != null) {
            IBlockState facadeState = facadeId.getBlockState();
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            if (layer != null && !facadeState.func_177230_c().canRenderInLayer(facadeState, layer)) {
                return Collections.emptyList();
            }
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(facadeState);
            try {
                return model.func_188616_a(state, side, rand);
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        if (side != null || state.func_177230_c() instanceof ConnectorBlock && MinecraftForgeClient.getRenderLayer() != BlockRenderLayer.CUTOUT_MIPPED) {
            return Collections.emptyList();
        }
        ConnectorType north = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.NORTH));
        ConnectorType south = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.SOUTH));
        ConnectorType west = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.WEST));
        ConnectorType east = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.EAST));
        ConnectorType up = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.UP));
        ConnectorType down = (ConnectorType)((Object)extendedBlockState.getValue((IUnlistedProperty)GenericCableBlock.DOWN));
        CableColor cableColor = (CableColor)((Object)extendedBlockState.func_177229_b(GenericCableBlock.COLOR));
        int index = cableColor.ordinal();
        GenericCableBakedModel.initTextures();
        CableTextures ct = cableTextures[index];
        this.spriteCable = ct.spriteNormalCable;
        GenericCableBlock block = (GenericCableBlock)state.func_177230_c();
        this.spriteConnector = block.isAdvancedConnector() ? ct.spriteAdvancedConnector : ct.spriteConnector;
        Function getSprite = idx -> GenericCableBakedModel.getSpriteNormal(idx, index);
        float hilight = 1.0f;
        if (block instanceof ConnectorBlock && north != ConnectorType.BLOCK && south != ConnectorType.BLOCK && west != ConnectorType.BLOCK && east != ConnectorType.BLOCK && up != ConnectorType.BLOCK && down != ConnectorType.BLOCK) {
            hilight = 0.5f;
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        double o = 0.4;
        double p = 0.1;
        double q = 0.2;
        if (up == ConnectorType.CABLE) {
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - o, 1.0, o), GenericCableBakedModel.v(1.0 - o, 1.0, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0, 1.0 - o), GenericCableBakedModel.v(o, 1.0, o), GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0, o), GenericCableBakedModel.v(1.0 - o, 1.0, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), GenericCableBakedModel.v(o, 1.0 - o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0, 1.0 - o), GenericCableBakedModel.v(o, 1.0, 1.0 - o), this.spriteCable, hilight));
        } else if (up == ConnectorType.BLOCK) {
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - o, 1.0 - p, o), GenericCableBakedModel.v(1.0 - o, 1.0 - p, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - p, 1.0 - o), GenericCableBakedModel.v(o, 1.0 - p, o), GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - p, o), GenericCableBakedModel.v(1.0 - o, 1.0 - p, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), GenericCableBakedModel.v(o, 1.0 - o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - p, 1.0 - o), GenericCableBakedModel.v(o, 1.0 - p, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - q, 1.0 - p, q), GenericCableBakedModel.v(1.0 - q, 1.0, q), GenericCableBakedModel.v(1.0 - q, 1.0, 1.0 - q), GenericCableBakedModel.v(1.0 - q, 1.0 - p, 1.0 - q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 1.0 - p, 1.0 - q), GenericCableBakedModel.v(q, 1.0, 1.0 - q), GenericCableBakedModel.v(q, 1.0, q), GenericCableBakedModel.v(q, 1.0 - p, q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 1.0, q), GenericCableBakedModel.v(1.0 - q, 1.0, q), GenericCableBakedModel.v(1.0 - q, 1.0 - p, q), GenericCableBakedModel.v(q, 1.0 - p, q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 1.0 - p, 1.0 - q), GenericCableBakedModel.v(1.0 - q, 1.0 - p, 1.0 - q), GenericCableBakedModel.v(1.0 - q, 1.0, 1.0 - q), GenericCableBakedModel.v(q, 1.0, 1.0 - q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 1.0 - p, q), GenericCableBakedModel.v(1.0 - q, 1.0 - p, q), GenericCableBakedModel.v(1.0 - q, 1.0 - p, 1.0 - q), GenericCableBakedModel.v(q, 1.0 - p, 1.0 - q), this.spriteConnector, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 1.0, q), GenericCableBakedModel.v(q, 1.0, 1.0 - q), GenericCableBakedModel.v(1.0 - q, 1.0, 1.0 - q), GenericCableBakedModel.v(1.0 - q, 1.0, q), spriteSide, hilight));
        } else {
            pattern = CablePatterns.findPattern(west, south, east, north);
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), GenericCableBakedModel.v(o, 1.0 - o, o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
        }
        if (down == ConnectorType.CABLE) {
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - o, o, o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 0.0, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 0.0, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, 1.0 - o), GenericCableBakedModel.v(o, o, o), GenericCableBakedModel.v(o, 0.0, o), GenericCableBakedModel.v(o, 0.0, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, o), GenericCableBakedModel.v(1.0 - o, o, o), GenericCableBakedModel.v(1.0 - o, 0.0, o), GenericCableBakedModel.v(o, 0.0, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 0.0, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 0.0, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(o, o, 1.0 - o), this.spriteCable, hilight));
        } else if (down == ConnectorType.BLOCK) {
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - o, o, o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, p, 1.0 - o), GenericCableBakedModel.v(1.0 - o, p, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, 1.0 - o), GenericCableBakedModel.v(o, o, o), GenericCableBakedModel.v(o, p, o), GenericCableBakedModel.v(o, p, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, o), GenericCableBakedModel.v(1.0 - o, o, o), GenericCableBakedModel.v(1.0 - o, p, o), GenericCableBakedModel.v(o, p, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, p, 1.0 - o), GenericCableBakedModel.v(1.0 - o, p, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(o, o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - q, 0.0, q), GenericCableBakedModel.v(1.0 - q, p, q), GenericCableBakedModel.v(1.0 - q, p, 1.0 - q), GenericCableBakedModel.v(1.0 - q, 0.0, 1.0 - q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 0.0, 1.0 - q), GenericCableBakedModel.v(q, p, 1.0 - q), GenericCableBakedModel.v(q, p, q), GenericCableBakedModel.v(q, 0.0, q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, p, q), GenericCableBakedModel.v(1.0 - q, p, q), GenericCableBakedModel.v(1.0 - q, 0.0, q), GenericCableBakedModel.v(q, 0.0, q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 0.0, 1.0 - q), GenericCableBakedModel.v(1.0 - q, 0.0, 1.0 - q), GenericCableBakedModel.v(1.0 - q, p, 1.0 - q), GenericCableBakedModel.v(q, p, 1.0 - q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, p, 1.0 - q), GenericCableBakedModel.v(1.0 - q, p, 1.0 - q), GenericCableBakedModel.v(1.0 - q, p, q), GenericCableBakedModel.v(q, p, q), this.spriteConnector, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 0.0, 1.0 - q), GenericCableBakedModel.v(q, 0.0, q), GenericCableBakedModel.v(1.0 - q, 0.0, q), GenericCableBakedModel.v(1.0 - q, 0.0, 1.0 - q), spriteSide, hilight));
        } else {
            pattern = CablePatterns.findPattern(west, north, east, south);
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, o), GenericCableBakedModel.v(1.0 - o, o, o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(o, o, 1.0 - o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
        }
        if (east == ConnectorType.CABLE) {
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0, o, o), GenericCableBakedModel.v(1.0, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0, 1.0 - o, o), GenericCableBakedModel.v(1.0, o, o), GenericCableBakedModel.v(1.0 - o, o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0, o, 1.0 - o), GenericCableBakedModel.v(1.0, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), this.spriteCable, hilight));
        } else if (east == ConnectorType.BLOCK) {
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - p, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - p, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - p, o, o), GenericCableBakedModel.v(1.0 - p, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - p, 1.0 - o, o), GenericCableBakedModel.v(1.0 - p, o, o), GenericCableBakedModel.v(1.0 - o, o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - p, o, 1.0 - o), GenericCableBakedModel.v(1.0 - p, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - p, 1.0 - q, 1.0 - q), GenericCableBakedModel.v(1.0, 1.0 - q, 1.0 - q), GenericCableBakedModel.v(1.0, 1.0 - q, q), GenericCableBakedModel.v(1.0 - p, 1.0 - q, q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - p, q, q), GenericCableBakedModel.v(1.0, q, q), GenericCableBakedModel.v(1.0, q, 1.0 - q), GenericCableBakedModel.v(1.0 - p, q, 1.0 - q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - p, 1.0 - q, q), GenericCableBakedModel.v(1.0, 1.0 - q, q), GenericCableBakedModel.v(1.0, q, q), GenericCableBakedModel.v(1.0 - p, q, q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - p, q, 1.0 - q), GenericCableBakedModel.v(1.0, q, 1.0 - q), GenericCableBakedModel.v(1.0, 1.0 - q, 1.0 - q), GenericCableBakedModel.v(1.0 - p, 1.0 - q, 1.0 - q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - p, q, 1.0 - q), GenericCableBakedModel.v(1.0 - p, 1.0 - q, 1.0 - q), GenericCableBakedModel.v(1.0 - p, 1.0 - q, q), GenericCableBakedModel.v(1.0 - p, q, q), this.spriteConnector, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0, q, 1.0 - q), GenericCableBakedModel.v(1.0, q, q), GenericCableBakedModel.v(1.0, 1.0 - q, q), GenericCableBakedModel.v(1.0, 1.0 - q, 1.0 - q), spriteSide, hilight));
        } else {
            pattern = CablePatterns.findPattern(down, north, up, south);
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - o, o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
        }
        if (west == ConnectorType.CABLE) {
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(0.0, 1.0 - o, o), GenericCableBakedModel.v(0.0, 1.0 - o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, o), GenericCableBakedModel.v(o, o, 1.0 - o), GenericCableBakedModel.v(0.0, o, 1.0 - o), GenericCableBakedModel.v(0.0, o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(o, o, o), GenericCableBakedModel.v(0.0, o, o), GenericCableBakedModel.v(0.0, 1.0 - o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, 1.0 - o), GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(0.0, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(0.0, o, 1.0 - o), this.spriteCable, hilight));
        } else if (west == ConnectorType.BLOCK) {
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(p, 1.0 - o, o), GenericCableBakedModel.v(p, 1.0 - o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, o), GenericCableBakedModel.v(o, o, 1.0 - o), GenericCableBakedModel.v(p, o, 1.0 - o), GenericCableBakedModel.v(p, o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(o, o, o), GenericCableBakedModel.v(p, o, o), GenericCableBakedModel.v(p, 1.0 - o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, 1.0 - o), GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(p, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(p, o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(0.0, 1.0 - q, 1.0 - q), GenericCableBakedModel.v(p, 1.0 - q, 1.0 - q), GenericCableBakedModel.v(p, 1.0 - q, q), GenericCableBakedModel.v(0.0, 1.0 - q, q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(0.0, q, q), GenericCableBakedModel.v(p, q, q), GenericCableBakedModel.v(p, q, 1.0 - q), GenericCableBakedModel.v(0.0, q, 1.0 - q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(0.0, 1.0 - q, q), GenericCableBakedModel.v(p, 1.0 - q, q), GenericCableBakedModel.v(p, q, q), GenericCableBakedModel.v(0.0, q, q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(0.0, q, 1.0 - q), GenericCableBakedModel.v(p, q, 1.0 - q), GenericCableBakedModel.v(p, 1.0 - q, 1.0 - q), GenericCableBakedModel.v(0.0, 1.0 - q, 1.0 - q), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(p, q, q), GenericCableBakedModel.v(p, 1.0 - q, q), GenericCableBakedModel.v(p, 1.0 - q, 1.0 - q), GenericCableBakedModel.v(p, q, 1.0 - q), this.spriteConnector, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(0.0, q, q), GenericCableBakedModel.v(0.0, q, 1.0 - q), GenericCableBakedModel.v(0.0, 1.0 - q, 1.0 - q), GenericCableBakedModel.v(0.0, 1.0 - q, q), spriteSide, hilight));
        } else {
            pattern = CablePatterns.findPattern(down, south, up, north);
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, 1.0 - o), GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(o, o, o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
        }
        if (north == ConnectorType.CABLE) {
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 0.0), GenericCableBakedModel.v(o, 1.0 - o, 0.0), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, 0.0), GenericCableBakedModel.v(1.0 - o, o, 0.0), GenericCableBakedModel.v(1.0 - o, o, o), GenericCableBakedModel.v(o, o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - o, o, 0.0), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 0.0), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, o), GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(o, 1.0 - o, 0.0), GenericCableBakedModel.v(o, o, 0.0), this.spriteCable, hilight));
        } else if (north == ConnectorType.BLOCK) {
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, p), GenericCableBakedModel.v(o, 1.0 - o, p), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, p), GenericCableBakedModel.v(1.0 - o, o, p), GenericCableBakedModel.v(1.0 - o, o, o), GenericCableBakedModel.v(o, o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - o, o, p), GenericCableBakedModel.v(1.0 - o, 1.0 - o, p), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, o, o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, o), GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(o, 1.0 - o, p), GenericCableBakedModel.v(o, o, p), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 1.0 - q, p), GenericCableBakedModel.v(1.0 - q, 1.0 - q, p), GenericCableBakedModel.v(1.0 - q, 1.0 - q, 0.0), GenericCableBakedModel.v(q, 1.0 - q, 0.0), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, q, 0.0), GenericCableBakedModel.v(1.0 - q, q, 0.0), GenericCableBakedModel.v(1.0 - q, q, p), GenericCableBakedModel.v(q, q, p), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - q, q, 0.0), GenericCableBakedModel.v(1.0 - q, 1.0 - q, 0.0), GenericCableBakedModel.v(1.0 - q, 1.0 - q, p), GenericCableBakedModel.v(1.0 - q, q, p), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, q, p), GenericCableBakedModel.v(q, 1.0 - q, p), GenericCableBakedModel.v(q, 1.0 - q, 0.0), GenericCableBakedModel.v(q, q, 0.0), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, q, p), GenericCableBakedModel.v(1.0 - q, q, p), GenericCableBakedModel.v(1.0 - q, 1.0 - q, p), GenericCableBakedModel.v(q, 1.0 - q, p), this.spriteConnector, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, q, 0.0), GenericCableBakedModel.v(q, 1.0 - q, 0.0), GenericCableBakedModel.v(1.0 - q, 1.0 - q, 0.0), GenericCableBakedModel.v(1.0 - q, q, 0.0), spriteSide, hilight));
        } else {
            pattern = CablePatterns.findPattern(west, up, east, down);
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, o), GenericCableBakedModel.v(1.0 - o, o, o), GenericCableBakedModel.v(o, o, o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
        }
        if (south == ConnectorType.CABLE) {
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, 1.0), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0), GenericCableBakedModel.v(o, o, 1.0), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0), GenericCableBakedModel.v(1.0 - o, o, 1.0), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, 1.0), GenericCableBakedModel.v(o, 1.0 - o, 1.0), GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(o, o, 1.0 - o), this.spriteCable, hilight));
        } else if (south == ConnectorType.BLOCK) {
            quads.add(this.createQuad(GenericCableBakedModel.v(o, 1.0 - o, 1.0 - p), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - p), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - p), GenericCableBakedModel.v(o, o, 1.0 - p), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - p), GenericCableBakedModel.v(1.0 - o, o, 1.0 - p), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, 1.0 - p), GenericCableBakedModel.v(o, 1.0 - o, 1.0 - p), GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(o, o, 1.0 - o), this.spriteCable, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 1.0 - q, 1.0), GenericCableBakedModel.v(1.0 - q, 1.0 - q, 1.0), GenericCableBakedModel.v(1.0 - q, 1.0 - q, 1.0 - p), GenericCableBakedModel.v(q, 1.0 - q, 1.0 - p), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, q, 1.0 - p), GenericCableBakedModel.v(1.0 - q, q, 1.0 - p), GenericCableBakedModel.v(1.0 - q, q, 1.0), GenericCableBakedModel.v(q, q, 1.0), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(1.0 - q, q, 1.0 - p), GenericCableBakedModel.v(1.0 - q, 1.0 - q, 1.0 - p), GenericCableBakedModel.v(1.0 - q, 1.0 - q, 1.0), GenericCableBakedModel.v(1.0 - q, q, 1.0), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, q, 1.0), GenericCableBakedModel.v(q, 1.0 - q, 1.0), GenericCableBakedModel.v(q, 1.0 - q, 1.0 - p), GenericCableBakedModel.v(q, q, 1.0 - p), spriteSide, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 1.0 - q, 1.0 - p), GenericCableBakedModel.v(1.0 - q, 1.0 - q, 1.0 - p), GenericCableBakedModel.v(1.0 - q, q, 1.0 - p), GenericCableBakedModel.v(q, q, 1.0 - p), this.spriteConnector, hilight));
            quads.add(this.createQuad(GenericCableBakedModel.v(q, 1.0 - q, 1.0), GenericCableBakedModel.v(q, q, 1.0), GenericCableBakedModel.v(1.0 - q, q, 1.0), GenericCableBakedModel.v(1.0 - q, 1.0 - q, 1.0), spriteSide, hilight));
        } else {
            pattern = CablePatterns.findPattern(west, down, east, up);
            quads.add(this.createQuad(GenericCableBakedModel.v(o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, o, 1.0 - o), GenericCableBakedModel.v(1.0 - o, 1.0 - o, 1.0 - o), GenericCableBakedModel.v(o, 1.0 - o, 1.0 - o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.spriteCable;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    static {
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_NONE, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 3));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 2));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 2));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 3));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_STRAIGHT, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_STRAIGHT, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 2));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 3));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CROSS, 0));
    }

    public static class CableTextures {
        TextureAtlasSprite spriteConnector;
        TextureAtlasSprite spriteAdvancedConnector;
        TextureAtlasSprite spriteNoneCable;
        TextureAtlasSprite spriteNormalCable;
        TextureAtlasSprite spriteEndCable;
        TextureAtlasSprite spriteCornerCable;
        TextureAtlasSprite spriteThreeCable;
        TextureAtlasSprite spriteCrossCable;
    }
}

