/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.items;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.ItemStackList;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.AbstractConnectorSettings;
import mcjty.xnet.apiimpl.items.ItemFilterCache;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class ItemConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final String TAG_MODE = "mode";
    public static final String TAG_STACK = "stack";
    public static final String TAG_EXTRACT_AMOUNT = "extract_amount";
    public static final String TAG_SPEED = "speed";
    public static final String TAG_EXTRACT = "extract";
    public static final String TAG_OREDICT = "od";
    public static final String TAG_NBT = "nbt";
    public static final String TAG_META = "meta";
    public static final String TAG_PRIORITY = "priority";
    public static final String TAG_COUNT = "count";
    public static final String TAG_FILTER = "flt";
    public static final String TAG_BLACKLIST = "blacklist";
    public static final int FILTER_SIZE = 18;
    private ItemMode itemMode = ItemMode.INS;
    private ExtractMode extractMode = ExtractMode.FIRST;
    private int speed = 2;
    private StackMode stackMode = StackMode.SINGLE;
    private boolean oredictMode = false;
    private boolean metaMode = false;
    private boolean nbtMode = false;
    private boolean blacklist = false;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer count = null;
    @Nullable
    private Integer extractAmount = null;
    private ItemStackList filters = ItemStackList.create((int)18);
    private Predicate<ItemStack> matcher = null;
    private static final Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"count", "priority", "od", "meta", "nbt", "blacklist"});
    private static final Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"count", "od", "meta", "nbt", "blacklist", "stack", "speed", "extract", "extract_amount"});

    public ItemMode getItemMode() {
        return this.itemMode;
    }

    public ItemConnectorSettings(@Nonnull EnumFacing side) {
        super(side);
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.itemMode) {
            case INS: {
                return new IndicatorIcon(iconGuiElements, 0, 70, 13, 10);
            }
            case EXT: {
                return new IndicatorIcon(iconGuiElements, 13, 70, 13, 10);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getIndicator() {
        return null;
    }

    @Override
    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        String[] speeds = this.advanced ? new String[]{"5", "10", "20", "60", "100", "200"} : new String[]{"10", "20", "60", "100", "200"};
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices(TAG_MODE, "Insert or extract mode", this.itemMode, ItemMode.values()).shift(5).choices(TAG_STACK, "Single item, stack, or count", this.stackMode, StackMode.values());
        if (this.stackMode == StackMode.COUNT && this.itemMode == ItemMode.EXT) {
            gui.integer(TAG_EXTRACT_AMOUNT, "Amount of items to extract|per operation", this.extractAmount, 30, 64);
        }
        gui.shift(10).choices(TAG_SPEED, "Number of ticks for each operation", Integer.toString(this.speed * 5), speeds).nl();
        gui.label("Pri").integer(TAG_PRIORITY, "Insertion priority", this.priority, 36).shift(5).label("#").integer(TAG_COUNT, this.itemMode == ItemMode.EXT ? "Amount in destination inventory|to keep" : "Max amount in destination|inventory", this.count, 30);
        if (this.itemMode == ItemMode.EXT) {
            gui.shift(5).choices(TAG_EXTRACT, "Extract mode (first available,|random slot or round robin)", this.extractMode, ExtractMode.values());
        }
        gui.nl().toggleText(TAG_BLACKLIST, "Enable blacklist mode", "BL", this.blacklist).shift(2).toggleText(TAG_OREDICT, "Ore dictionary matching", "Ore", this.oredictMode).shift(2).toggleText(TAG_META, "Metadata matching", "Meta", this.metaMode).shift(2).toggleText(TAG_NBT, "NBT matching", "NBT", this.nbtMode).nl();
        for (int i = 0; i < 18; ++i) {
            gui.ghostSlot(TAG_FILTER + i, (ItemStack)this.filters.get(i));
        }
    }

    public Predicate<ItemStack> getMatcher() {
        if (this.matcher == null) {
            ItemStackList filterList = ItemStackList.create();
            for (ItemStack stack : this.filters) {
                if (stack.func_190926_b()) continue;
                filterList.add((Object)stack);
            }
            if (filterList.isEmpty()) {
                this.matcher = itemStack -> true;
            } else {
                ItemFilterCache filterCache = new ItemFilterCache(this.metaMode, this.oredictMode, this.blacklist, this.nbtMode, filterList);
                this.matcher = filterCache::match;
            }
        }
        return this.matcher;
    }

    public StackMode getStackMode() {
        return this.stackMode;
    }

    public ExtractMode getExtractMode() {
        return this.extractMode;
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nullable
    public Integer getCount() {
        return this.count;
    }

    public int getExtractAmount() {
        return this.extractAmount == null ? 1 : this.extractAmount;
    }

    public int getSpeed() {
        return this.speed;
    }

    @Override
    public boolean isEnabled(String tag) {
        if (tag.startsWith(TAG_FILTER)) {
            return true;
        }
        if (tag.equals("facing")) {
            return this.advanced;
        }
        if (this.itemMode == ItemMode.INS) {
            return INSERT_TAGS.contains(tag);
        }
        return EXTRACT_TAGS.contains(tag);
    }

    @Override
    public void update(Map<String, Object> data) {
        super.update(data);
        this.itemMode = ItemMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        Object emode = data.get(TAG_EXTRACT);
        this.extractMode = emode == null ? ExtractMode.FIRST : ExtractMode.valueOf(((String)emode).toUpperCase());
        this.stackMode = StackMode.valueOf(((String)data.get(TAG_STACK)).toUpperCase());
        this.speed = Integer.parseInt((String)data.get(TAG_SPEED)) / 5;
        if (this.speed == 0) {
            this.speed = 4;
        }
        this.oredictMode = Boolean.TRUE.equals(data.get(TAG_OREDICT));
        this.metaMode = Boolean.TRUE.equals(data.get(TAG_META));
        this.nbtMode = Boolean.TRUE.equals(data.get(TAG_NBT));
        this.blacklist = Boolean.TRUE.equals(data.get(TAG_BLACKLIST));
        this.priority = (Integer)data.get(TAG_PRIORITY);
        this.count = (Integer)data.get(TAG_COUNT);
        this.extractAmount = (Integer)data.get(TAG_EXTRACT_AMOUNT);
        for (int i = 0; i < 18; ++i) {
            this.filters.set(i, (Object)((ItemStack)data.get(TAG_FILTER + i)));
        }
        this.matcher = null;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.itemMode = ItemMode.values()[tag.func_74771_c("itemMode")];
        this.extractMode = ExtractMode.values()[tag.func_74771_c("extractMode")];
        this.stackMode = StackMode.values()[tag.func_74771_c("stackMode")];
        if (tag.func_74764_b("spd")) {
            this.speed = tag.func_74762_e("spd");
        } else {
            this.speed = tag.func_74762_e(TAG_SPEED);
            if (this.speed == 0) {
                this.speed = 2;
            }
            this.speed *= 2;
        }
        this.oredictMode = tag.func_74767_n("oredictMode");
        this.metaMode = tag.func_74767_n("metaMode");
        this.nbtMode = tag.func_74767_n("nbtMode");
        this.blacklist = tag.func_74767_n(TAG_BLACKLIST);
        this.priority = tag.func_74764_b(TAG_PRIORITY) ? Integer.valueOf(tag.func_74762_e(TAG_PRIORITY)) : null;
        this.extractAmount = tag.func_74764_b("extractAmount") ? Integer.valueOf(tag.func_74762_e("extractAmount")) : null;
        this.count = tag.func_74764_b(TAG_COUNT) ? Integer.valueOf(tag.func_74762_e(TAG_COUNT)) : null;
        for (int i = 0; i < 18; ++i) {
            if (tag.func_74764_b("filter" + i)) {
                NBTTagCompound itemTag = tag.func_74775_l("filter" + i);
                this.filters.set(i, (Object)new ItemStack(itemTag));
                continue;
            }
            this.filters.set(i, (Object)ItemStack.field_190927_a);
        }
        this.matcher = null;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("itemMode", (byte)this.itemMode.ordinal());
        tag.func_74774_a("extractMode", (byte)this.extractMode.ordinal());
        tag.func_74774_a("stackMode", (byte)this.stackMode.ordinal());
        tag.func_74768_a("spd", this.speed);
        tag.func_74757_a("oredictMode", this.oredictMode);
        tag.func_74757_a("metaMode", this.metaMode);
        tag.func_74757_a("nbtMode", this.nbtMode);
        tag.func_74757_a(TAG_BLACKLIST, this.blacklist);
        if (this.priority != null) {
            tag.func_74768_a(TAG_PRIORITY, this.priority.intValue());
        }
        if (this.extractAmount != null) {
            tag.func_74768_a("extractAmount", this.extractAmount.intValue());
        }
        if (this.count != null) {
            tag.func_74768_a(TAG_COUNT, this.count.intValue());
        }
        for (int i = 0; i < 18; ++i) {
            if (((ItemStack)this.filters.get(i)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            ((ItemStack)this.filters.get(i)).func_77955_b(itemTag);
            tag.func_74782_a("filter" + i, (NBTBase)itemTag);
        }
    }

    public static enum ExtractMode {
        FIRST,
        RND,
        ORDER;

    }

    public static enum StackMode {
        SINGLE,
        STACK,
        COUNT;

    }

    public static enum ItemMode {
        INS,
        EXT;

    }
}

