/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.util.recipes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.modmuss50.ftba.api.IPoweredRecipe;
import me.modmuss50.ftba.util.recipes.PoweredRecipes;
import me.modmuss50.ftba.util.recipes.PoweredTierRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PoweredCraftingManager {
    private static Map<ResourceLocation, IPoweredRecipe> RECIPES = new HashMap<ResourceLocation, IPoweredRecipe>();

    public static void testRecipes() {
        ResourceLocation resourceLocation = new ResourceLocation("ftbachievements", "test");
        PoweredCraftingManager.register(resourceLocation, new PoweredRecipes.PoweredShapelessRecipe(resourceLocation, new ItemStack(Items.field_151045_i), 100, new ItemStack(Blocks.field_150348_b)));
        PoweredTierRecipe.addTierdShapelessRecipe("test", 0, new ItemStack(Items.field_151122_aG), 100, new ItemStack(Items.field_151042_j));
        PoweredTierRecipe.addTierdShapelessRecipe("test", 1, new ItemStack(Items.field_151122_aG), 200, new ItemStack(Items.field_151043_k));
        PoweredTierRecipe.addTierdShapelessRecipe("test", 3, new ItemStack(Items.field_151122_aG), 300, new ItemStack(Items.field_151045_i));
    }

    public static void register(ResourceLocation resourceLocation, IPoweredRecipe recipe) {
        if (RECIPES.containsKey(resourceLocation)) {
            throw new RuntimeException("Recipe allready registered!");
        }
        RECIPES.put(resourceLocation, recipe);
    }

    public static List<IPoweredRecipe> getAllRecipes() {
        return RECIPES.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public static ItemStack findMatchingResult(InventoryCrafting craftMatrix, World worldIn) {
        for (IPoweredRecipe irecipe : PoweredCraftingManager.getAllRecipes()) {
            if (!irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe.func_77572_b(craftMatrix);
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public static IPoweredRecipe findMatchingRecipe(InventoryCrafting craftMatrix, World worldIn) {
        for (IPoweredRecipe irecipe : PoweredCraftingManager.getAllRecipes()) {
            if (!irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe;
        }
        return null;
    }

    public static List<IPoweredRecipe> findAllMatchingRecipe(InventoryCrafting craftMatrix, World worldIn) {
        return PoweredCraftingManager.getAllRecipes().stream().filter(recipe -> recipe.func_77569_a(craftMatrix, worldIn)).collect(Collectors.toList());
    }

    public static NonNullList<ItemStack> getRemainingItems(InventoryCrafting craftMatrix, World worldIn, EntityPlayer player) {
        for (IPoweredRecipe irecipe : PoweredCraftingManager.getAllRecipes()) {
            if (!irecipe.func_77569_a(craftMatrix, worldIn) || !irecipe.enabled(player)) continue;
            return irecipe.func_179532_b(craftMatrix);
        }
        NonNullList nonnulllist = NonNullList.func_191197_a((int)craftMatrix.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)craftMatrix.func_70301_a(i));
        }
        return nonnulllist;
    }

    @Nullable
    public static IPoweredRecipe getRecipe(ResourceLocation name) {
        return RECIPES.get(name);
    }

    public static ResourceLocation getRecipeName(IPoweredRecipe recipe) {
        ResourceLocation[] name = new ResourceLocation[]{null};
        RECIPES.forEach((resourceLocation, iPoweredRecipe) -> {
            if (recipe == iPoweredRecipe) {
                name[0] = resourceLocation;
            }
        });
        return name[0];
    }
}

