/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.util;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import me.modmuss50.ftba.packets.PacketSyncPlayerCount;
import me.modmuss50.ftba.team.TeamEnum;
import me.modmuss50.ftba.team.TeamManager;
import me.modmuss50.ftba.util.FTBTeamUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.commons.io.FileUtils;
import reborncore.RebornCore;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;
import reborncore.common.util.serialization.SerializationUtil;

public class WorldPlayerCountHandler {
    public static int playerCount = 4;

    @SubscribeEvent
    public static void loadWorld(WorldEvent.Load event) throws IOException {
        if (event.getWorld().field_73011_w.getDimension() == 0 && !event.getWorld().field_72995_K) {
            WorldPlayerCountHandler.readWorldType(event.getWorld());
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        NetworkManager.sendToPlayer((INetworkPacket)new PacketSyncPlayerCount(playerCount), (EntityPlayerMP)((EntityPlayerMP)event.player));
        if (playerCount == 1) {
            WorldPlayerCountHandler.handleSinglePlayer((EntityPlayerMP)event.player);
        }
    }

    public static void readWorldType(World world) throws IOException {
        File worldTypeFile = new File(world.func_72860_G().func_75765_b(), "ftba_worldtype.json");
        if (!worldTypeFile.exists()) {
            FileUtils.writeStringToFile((File)worldTypeFile, (String)SerializationUtil.GSON.toJson((Object)new WorldTypeData()), (Charset)Charsets.UTF_8);
        } else {
            String json = FileUtils.readFileToString((File)worldTypeFile, (Charset)Charsets.UTF_8);
            WorldTypeData worldTypeData = (WorldTypeData)SerializationUtil.GSON.fromJson(json, WorldTypeData.class);
            playerCount = worldTypeData.playerCount;
        }
        RebornCore.logHelper.info((Object)("Map player count set to: " + playerCount));
    }

    public static void handleSinglePlayer(EntityPlayerMP entityPlayerMP) {
        if (FTBTeamUtil.getTeam((EntityPlayer)entityPlayerMP) != null && FTBTeamUtil.getTeam((EntityPlayer)entityPlayerMP).isValid()) {
            return;
        }
        RebornCore.logHelper.info((Object)"Adding player to singleplayer team");
        TeamManager.joinPlayerToTeam((EntityPlayer)entityPlayerMP, TeamEnum.SINGLEPLAYER);
    }

    public static class WorldTypeData {
        int playerCount = 4;
    }
}

