/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.util;

import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseLoadedEvent;
import com.feed_the_beast.ftblib.lib.EnumTeamColor;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.TeamType;
import com.feed_the_beast.ftblib.lib.data.Universe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.modmuss50.ftba.packets.PacketSendJEIRecipeData;
import me.modmuss50.ftba.packets.PacketSyncFTBTeam;
import me.modmuss50.ftba.team.TeamEnum;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import reborncore.RebornCore;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;

public class FTBTeamUtil {
    public static final HashMap<TeamEnum, String> teamNameMap = new HashMap();

    public static void handleOnlineMemebers(EntityPlayer player, Consumer<EntityPlayer> playerRunnable) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        FTBTeamUtil.getTeamMemebersOnServer(player, player.field_70170_p.func_73046_m()).forEach(playerRunnable);
    }

    public static List<EntityPlayer> getTeamMemebersOnServer(EntityPlayer player, MinecraftServer server) {
        ForgeTeam team = FTBTeamUtil.getTeam(player);
        return server.func_184103_al().func_181057_v().stream().filter(playerMP -> FTBTeamUtil.getTeam((EntityPlayer)playerMP) != null && FTBTeamUtil.getTeam((EntityPlayer)playerMP).getTitle().func_150260_c().equals(team.getTitle().func_150260_c())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static EntityPlayerMP getPlayerFromUUID(UUID uuid, MinecraftServer server) {
        for (EntityPlayerMP playerMP : server.func_184103_al().func_181057_v()) {
            if (!playerMP.func_110124_au().equals(uuid)) continue;
            return playerMP;
        }
        return null;
    }

    public static ForgePlayer getForgePlayer(EntityPlayer player) {
        if (!Universe.get().players.containsKey(player.func_110124_au())) {
            return null;
        }
        ForgePlayer forgePlayer = Universe.get().getPlayer((ICommandSender)player);
        return forgePlayer;
    }

    @Nullable
    public static ForgeTeam getTeam(EntityPlayer player) {
        ForgePlayer forgePlayer = Universe.get().getPlayer((ICommandSender)player);
        if (!forgePlayer.hasTeam()) {
            return null;
        }
        return forgePlayer.team;
    }

    @SubscribeEvent
    public static void createTeams(UniverseLoadedEvent.CreateServerTeams event) {
        teamNameMap.clear();
        Arrays.stream(TeamEnum.values()).forEach(teamEnum -> {
            Universe universe = event.getUniverse();
            ForgeTeam team = new ForgeTeam(universe, teamEnum.getName(), TeamType.SERVER);
            team.setColor(FTBTeamUtil.getFTBTeamColor(teamEnum));
            team.setTitle(teamEnum.getDisplayName());
            team.setFreeToJoin(false);
            universe.teams.put(teamEnum.getName(), team);
            teamNameMap.put((TeamEnum)((Object)teamEnum), teamEnum.getName());
        });
    }

    private static EnumTeamColor getFTBTeamColor(TeamEnum teamEnum) {
        switch (teamEnum) {
            case RED: {
                return EnumTeamColor.RED;
            }
            case GREEN: {
                return EnumTeamColor.GREEN;
            }
            case BLUE: {
                return EnumTeamColor.BLUE;
            }
            case YELLOW: {
                return EnumTeamColor.YELLOW;
            }
            case SPECTATOR: {
                return EnumTeamColor.GRAY;
            }
            case SINGLEPLAYER: {
                return EnumTeamColor.GRAY;
            }
        }
        return EnumTeamColor.GRAY;
    }

    public static void joinPlayerToTeam(EntityPlayer player, TeamEnum teamEnum) {
        ForgeTeam team = Universe.get().getTeam(teamNameMap.get((Object)teamEnum));
        team.setFreeToJoin(true);
        ForgePlayer forgePlayer = FTBTeamUtil.getForgePlayer(player);
        if (forgePlayer.hasTeam()) {
            forgePlayer.team.removeMember(forgePlayer);
        }
        team.addMember(forgePlayer, false);
        team.setFreeToJoin(false);
    }

    @SubscribeEvent
    public static void playerJoinTeamEvent(ForgeTeamPlayerJoinedEvent event) {
        ForgePlayer player = event.getPlayer();
        FTBTeamUtil.updatePlatyerTeamDetails(player.getPlayer(), event.getTeam().getTitle().func_150260_c());
    }

    @SubscribeEvent
    public static void playerJoinedWorldEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP) || event.player.field_70170_p.field_72995_K) {
            return;
        }
        PacketSendJEIRecipeData.sendJEIPacket((EntityPlayerMP)event.player);
        if (FTBTeamUtil.getTeam(event.player) == null) {
            RebornCore.logHelper.info((Object)(event.player.getDisplayNameString() + " has joined the server world, but is currently not part of a team"));
            return;
        }
        FTBTeamUtil.updatePlatyerTeamDetails((EntityPlayerMP)event.player, FTBTeamUtil.getTeam(event.player).getTitle().func_150260_c());
    }

    public static void updatePlatyerTeamDetails(EntityPlayerMP playerMP, String newTeam) {
        RebornCore.logHelper.info((Object)(newTeam + " : Team name has been sent to the client " + playerMP.getDisplayNameString()));
        NetworkManager.sendToPlayer((INetworkPacket)new PacketSyncFTBTeam(newTeam), (EntityPlayerMP)playerMP);
    }
}

